/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.filters;

public enum DataType {
    DIRECTORY(true),
    FUNCTION(true),
    JOB(true),
    MATERIALIZED_VIEW(true, "MATERIALIZED VIEW"),
    PACKAGE(true),
    PROCEDURE(true),
    TRIGGER(true),
    SEQUENCE(true),
    TABLE(true),
    POST_TABLE_ACTION(false),
    TABLESPACE(false),
    VIEW(false),
    CLUSTER(false),
    DB_LINK(false, "DATABASE LINK"),
    INDEX(false),
    INDEXTYPE(false),
    MATERIALIZED_VIEW_LOG(false),
    MATERIALIZED_ZONEMAP(false),
    REF_CONSTRAINT(false),
    RLS_POLICY(false),
    USER(false),
    SYNONYM(false),
    PROFILE(false),
    GRANT(false),
    ROLE_GRANT(false, "ROLE GRANT"),
    OBJECT_GRANT(false),
    PROCOBJ(false),
    ALL(false),
    JAVA_DATA(false, "JAVA DATA"),
    JAVA_CLASS(false, "JAVA CLASS"),
    JAVA_SOURCE(false, "JAVA SOURCE"),
    JAVA_RESOURCE(false, "JAVA RESOURCE"),
    LIBRARY(false),
    LOB(false),
    TABLE_PARTITION(false, "TABLE PARTITION"),
    TABLE_SUBPARTITION(false, "TABLE SUBPARTITION"),
    XMLSCHEMA(false, "XML SCHEMA");

    private final boolean allowNamed;
    private final String dbaObjectsName;

    private DataType(boolean allowNamedParam) {
        this.allowNamed = allowNamedParam;
        this.dbaObjectsName = this.name();
    }

    private DataType(boolean allowNamedParam, String dbaObjectsName) {
        this.allowNamed = allowNamedParam;
        this.dbaObjectsName = dbaObjectsName;
    }

    public boolean isNameAllowed() {
        return this.allowNamed;
    }

    public String getDbaObjectsName() {
        return this.dbaObjectsName;
    }

    public static DataType fromDbaObjectsName(String name) {
        for (DataType dt : DataType.values()) {
            if (!dt.getDbaObjectsName().equals(name)) continue;
            return dt;
        }
        throw new IllegalArgumentException("Data Type '" + name + "' not yet supported");
    }
}

