/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.filters;

import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.filters.DataType;
import com.oracle.premigration.reports.filters.Filter;
import com.oracle.premigration.reports.filters.FilterType;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class FilterCriteria {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(FilterCriteria.class.getName());
    private final FilterType filterType;
    private final List<Filter> filters;

    public boolean include(String schemaName, String objectName, String dataType) {
        if (this.filters.size() == 0) {
            return true;
        }
        boolean isIncluded = this.filterType == FilterType.EXCLUDE;
        for (Filter filter : this.filters) {
            boolean typeMatched;
            boolean schemaMatched = filter.getObjectOwner().matcher(schemaName).matches();
            boolean nameMatched = filter.getObjectName().matcher(objectName).matches();
            boolean bl = typeMatched = filter.getObjectType().equals(DataType.ALL.name()) || filter.getObjectType().equals(dataType);
            if (!schemaMatched || !nameMatched || !typeMatched) continue;
            return this.filterType != FilterType.EXCLUDE;
        }
        return isIncluded;
    }

    public static FilterCriteria fromProperties(Properties srcAnalysisProps, List<PremigrationException> nonFatalErrors) throws PremigrationException {
        boolean hasInclude = srcAnalysisProps.containsKey(SourceAnalysisProp.REPORT_FILTER.getKey(FilterType.INCLUDE.name()));
        boolean hasExclude = srcAnalysisProps.containsKey(SourceAnalysisProp.REPORT_FILTER.getKey(FilterType.EXCLUDE.name()));
        FilterCriteriaBuilder filterCriteriaBuilder = FilterCriteria.builder();
        if (hasInclude && hasExclude) {
            throw new PremigrationException(Utilities.getErrorText("ERROR2005", new String[0]));
        }
        if (!hasExclude && !hasInclude) {
            return filterCriteriaBuilder.filters(new ArrayList<Filter>()).build();
        }
        FilterType filterType = hasExclude ? FilterType.EXCLUDE : FilterType.INCLUDE;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        int i = 0;
        while (true) {
            String keySuffix = i == 0 ? "" : "_" + i;
            String filterKey = SourceAnalysisProp.REPORT_FILTER.getKey(filterType.name() + keySuffix);
            String filterValue = srcAnalysisProps.getProperty(filterKey);
            if (filterValue == null) break;
            try {
                Filter filter = Filter.fromPropertyValue(filterValue);
                filters.add(filter);
            }
            catch (Throwable e) {
                PremigrationException pe = new PremigrationException(Utilities.getErrorText("ERROR2006", filterKey), e);
                log.warning(pe.getMessage(), e);
                nonFatalErrors.add(pe);
            }
            ++i;
        }
        return filterCriteriaBuilder.filters(filters).filterType(filterType).build();
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (int i = 0; i < this.filters.size(); ++i) {
            String keySuffix = i == 0 ? "" : "_" + i;
            String filterKey = SourceAnalysisProp.REPORT_FILTER.getKey(this.filterType.name() + keySuffix);
            String filterValue = this.filters.get(i).toString();
            props.setProperty(filterKey, filterValue);
        }
        return props;
    }

    FilterCriteria(FilterType filterType, List<Filter> filters) {
        this.filterType = filterType;
        this.filters = filters;
    }

    public static FilterCriteriaBuilder builder() {
        return new FilterCriteriaBuilder();
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterCriteria)) {
            return false;
        }
        FilterCriteria other = (FilterCriteria)o;
        FilterType this$filterType = this.getFilterType();
        FilterType other$filterType = other.getFilterType();
        if (this$filterType == null ? other$filterType != null : !((Object)((Object)this$filterType)).equals((Object)other$filterType)) {
            return false;
        }
        List<Filter> this$filters = this.getFilters();
        List<Filter> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterType $filterType = this.getFilterType();
        result = result * 59 + ($filterType == null ? 43 : ((Object)((Object)$filterType)).hashCode());
        List<Filter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "FilterCriteria(filterType=" + (Object)((Object)this.getFilterType()) + ", filters=" + this.getFilters() + ")";
    }

    public static class FilterCriteriaBuilder {
        private FilterType filterType;
        private List<Filter> filters;

        FilterCriteriaBuilder() {
        }

        public FilterCriteriaBuilder filterType(FilterType filterType) {
            this.filterType = filterType;
            return this;
        }

        public FilterCriteriaBuilder filters(List<Filter> filters) {
            this.filters = filters;
            return this;
        }

        public FilterCriteria build() {
            return new FilterCriteria(this.filterType, this.filters);
        }

        public String toString() {
            return "FilterCriteria.FilterCriteriaBuilder(filterType=" + (Object)((Object)this.filterType) + ", filters=" + this.filters + ")";
        }
    }
}

