/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text;

import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.GlobalVariables;
import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.helpers.Utilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class TextReportContext {
    private PrintWriter printWriter;
    private int reportWidth;
    private Integer maxRelevantDataRows;
    private boolean sqlExcluded;
    String textReportPath;
    public String DASHED_LINE;
    public String SOLID_LINE;
    public String PARALLEL_DASHED_LINE;

    private TextReportContext(PrintWriter printWriter, int reportWidth, boolean isSqlInTextReport, Integer maxTextRows) {
        this.printWriter = printWriter;
        this.reportWidth = reportWidth;
        this.maxRelevantDataRows = maxTextRows == null ? Integer.MAX_VALUE : maxTextRows;
        this.sqlExcluded = !isSqlInTextReport;
        this.DASHED_LINE = Utilities.repeatCharacter(reportWidth, '~');
        this.SOLID_LINE = Utilities.repeatCharacter(reportWidth, '-');
        this.PARALLEL_DASHED_LINE = Utilities.repeatCharacter(reportWidth, '=');
    }

    public static TextReportContext createTextReportContext(CommandLineArgs cla) throws AccessDeniedException, IOException {
        String textPath = Utilities.getValidatedFilePath(cla.getOutdir(), GlobalVariables.TEXT_OUTPUT_FILENAME);
        File reportFile = new File(textPath);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(reportFile)));
        TextReportContext reportContext = new TextReportContext(printWriter, 132, cla.isSqlInTextReport(), cla.getMaxTextRows());
        reportContext.setTextReportPath(reportFile.getCanonicalPath());
        return reportContext;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public int getReportWidth() {
        return this.reportWidth;
    }

    public Integer getMaxRelevantDataRows() {
        return this.maxRelevantDataRows;
    }

    public boolean isSqlExcluded() {
        return this.sqlExcluded;
    }

    public String getDASHED_LINE() {
        return this.DASHED_LINE;
    }

    public String getSOLID_LINE() {
        return this.SOLID_LINE;
    }

    public String getPARALLEL_DASHED_LINE() {
        return this.PARALLEL_DASHED_LINE;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setReportWidth(int reportWidth) {
        this.reportWidth = reportWidth;
    }

    public void setMaxRelevantDataRows(Integer maxRelevantDataRows) {
        this.maxRelevantDataRows = maxRelevantDataRows;
    }

    public void setSqlExcluded(boolean sqlExcluded) {
        this.sqlExcluded = sqlExcluded;
    }

    public void setDASHED_LINE(String DASHED_LINE) {
        this.DASHED_LINE = DASHED_LINE;
    }

    public void setSOLID_LINE(String SOLID_LINE) {
        this.SOLID_LINE = SOLID_LINE;
    }

    public void setPARALLEL_DASHED_LINE(String PARALLEL_DASHED_LINE) {
        this.PARALLEL_DASHED_LINE = PARALLEL_DASHED_LINE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportContext)) {
            return false;
        }
        TextReportContext other = (TextReportContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReportWidth() != other.getReportWidth()) {
            return false;
        }
        if (this.isSqlExcluded() != other.isSqlExcluded()) {
            return false;
        }
        Integer this$maxRelevantDataRows = this.getMaxRelevantDataRows();
        Integer other$maxRelevantDataRows = other.getMaxRelevantDataRows();
        if (this$maxRelevantDataRows == null ? other$maxRelevantDataRows != null : !((Object)this$maxRelevantDataRows).equals(other$maxRelevantDataRows)) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        if (this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter)) {
            return false;
        }
        String this$textReportPath = this.getTextReportPath();
        String other$textReportPath = other.getTextReportPath();
        if (this$textReportPath == null ? other$textReportPath != null : !this$textReportPath.equals(other$textReportPath)) {
            return false;
        }
        String this$DASHED_LINE = this.getDASHED_LINE();
        String other$DASHED_LINE = other.getDASHED_LINE();
        if (this$DASHED_LINE == null ? other$DASHED_LINE != null : !this$DASHED_LINE.equals(other$DASHED_LINE)) {
            return false;
        }
        String this$SOLID_LINE = this.getSOLID_LINE();
        String other$SOLID_LINE = other.getSOLID_LINE();
        if (this$SOLID_LINE == null ? other$SOLID_LINE != null : !this$SOLID_LINE.equals(other$SOLID_LINE)) {
            return false;
        }
        String this$PARALLEL_DASHED_LINE = this.getPARALLEL_DASHED_LINE();
        String other$PARALLEL_DASHED_LINE = other.getPARALLEL_DASHED_LINE();
        return !(this$PARALLEL_DASHED_LINE == null ? other$PARALLEL_DASHED_LINE != null : !this$PARALLEL_DASHED_LINE.equals(other$PARALLEL_DASHED_LINE));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReportContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReportWidth();
        result = result * 59 + (this.isSqlExcluded() ? 79 : 97);
        Integer $maxRelevantDataRows = this.getMaxRelevantDataRows();
        result = result * 59 + ($maxRelevantDataRows == null ? 43 : ((Object)$maxRelevantDataRows).hashCode());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        String $textReportPath = this.getTextReportPath();
        result = result * 59 + ($textReportPath == null ? 43 : $textReportPath.hashCode());
        String $DASHED_LINE = this.getDASHED_LINE();
        result = result * 59 + ($DASHED_LINE == null ? 43 : $DASHED_LINE.hashCode());
        String $SOLID_LINE = this.getSOLID_LINE();
        result = result * 59 + ($SOLID_LINE == null ? 43 : $SOLID_LINE.hashCode());
        String $PARALLEL_DASHED_LINE = this.getPARALLEL_DASHED_LINE();
        result = result * 59 + ($PARALLEL_DASHED_LINE == null ? 43 : $PARALLEL_DASHED_LINE.hashCode());
        return result;
    }

    public String toString() {
        return "TextReportContext(printWriter=" + this.getPrintWriter() + ", reportWidth=" + this.getReportWidth() + ", maxRelevantDataRows=" + this.getMaxRelevantDataRows() + ", sqlExcluded=" + this.isSqlExcluded() + ", textReportPath=" + this.getTextReportPath() + ", DASHED_LINE=" + this.getDASHED_LINE() + ", SOLID_LINE=" + this.getSOLID_LINE() + ", PARALLEL_DASHED_LINE=" + this.getPARALLEL_DASHED_LINE() + ")";
    }

    public String getTextReportPath() {
        return this.textReportPath;
    }

    public void setTextReportPath(String textReportPath) {
        this.textReportPath = textReportPath;
    }
}

