/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.text.TextValueHint;
import java.text.BreakIterator;

class TextReportDisplayElement {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TextReportDisplayElement.class.getName());
    private String value;
    private TextValueHint valueTypeHint;

    TextReportDisplayElement(String value, TextValueHint valueTypeHint) {
        this.value = valueTypeHint == TextValueHint.SQL_TEXT ? value.replace("\n", " ") : value;
        this.valueTypeHint = valueTypeHint;
    }

    boolean hasDataRemaining() {
        return this.value.length() > 0;
    }

    String getSomeText(int amountOfText) {
        String text;
        if (!this.hasDataRemaining()) {
            return Utilities.padRight("", amountOfText);
        }
        if (this.valueTypeHint == TextValueHint.NATURAL_LANGUAGE && this.value.length() > amountOfText) {
            BreakIterator bi = BreakIterator.getWordInstance();
            bi.setText(this.value);
            if (bi.isBoundary(amountOfText)) {
                text = this.value.substring(0, amountOfText);
            } else {
                int preceding = bi.preceding(amountOfText);
                if (preceding == 0) {
                    preceding = amountOfText + 1;
                }
                text = this.value.substring(0, preceding - 1);
            }
            if (text.contains("(") || text.contains(")")) {
                bi.setText(text);
                int start = bi.first();
                int end = bi.next();
                int par = -1;
                while (end != -1) {
                    if (text.charAt(start) == '(') {
                        par = start;
                    } else if (text.charAt(start) == ')') {
                        par = -1;
                    }
                    start = end;
                    end = bi.next();
                }
                if (par != -1) {
                    text = this.value.substring(0, bi.preceding(par));
                }
            }
            this.value = this.value.substring(text.length()).trim();
        } else {
            text = this.value.substring(0, Math.min(this.value.length(), amountOfText));
            if (this.value.length() >= amountOfText) {
                int preceding;
                BreakIterator bi = BreakIterator.getWordInstance();
                bi.setText(this.value);
                if (!bi.isBoundary(amountOfText) && (preceding = bi.preceding(amountOfText)) > 1) {
                    text = this.value.substring(0, preceding - 1);
                }
            }
            this.value = this.value.substring(text.length());
        }
        if (amountOfText > text.length()) {
            text = Utilities.padRight(text, amountOfText);
        }
        return text;
    }

    public String getValue() {
        return this.value;
    }

    public TextValueHint getValueTypeHint() {
        return this.valueTypeHint;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValueTypeHint(TextValueHint valueTypeHint) {
        this.valueTypeHint = valueTypeHint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportDisplayElement)) {
            return false;
        }
        TextReportDisplayElement other = (TextReportDisplayElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        TextValueHint this$valueTypeHint = this.getValueTypeHint();
        TextValueHint other$valueTypeHint = other.getValueTypeHint();
        return !(this$valueTypeHint == null ? other$valueTypeHint != null : !((Object)((Object)this$valueTypeHint)).equals((Object)other$valueTypeHint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReportDisplayElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        TextValueHint $valueTypeHint = this.getValueTypeHint();
        result = result * 59 + ($valueTypeHint == null ? 43 : ((Object)((Object)$valueTypeHint)).hashCode());
        return result;
    }

    public String toString() {
        return "TextReportDisplayElement(value=" + this.getValue() + ", valueTypeHint=" + (Object)((Object)this.getValueTypeHint()) + ")";
    }
}

