/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import oracle.cloudstorage.api.queryparam.QueryParam;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;

public class ScopedMethod {
    private static final Set<String>[][] validQueryParams = (Set[][])Array.newInstance(Set.class, Scope.values().length, Method.values().length);
    private final Scope scope;
    private final Method method;

    public ScopedMethod(Scope scope, Method method) {
        this.scope = scope;
        this.method = method;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return (Object)((Object)this.method) + " " + (Object)((Object)this.scope);
    }

    public static void add(ScopedMethod[] validScopedMethods, QueryParam queryParam) {
        for (ScopedMethod scopedMethod : validScopedMethods) {
            Scope scope = scopedMethod.getScope();
            Method method = scopedMethod.getMethod();
            validQueryParams[scope.ordinal()][method.ordinal()].add(queryParam.getKey());
        }
    }

    public static boolean isValid(Scope scope, Method method, String queryParamKey) {
        boolean validParam = validQueryParams[scope.ordinal()][method.ordinal()].contains(queryParamKey);
        return validParam;
    }

    static {
        for (int s = 0; s < Scope.values().length; ++s) {
            for (int m = 0; m < Method.values().length; ++m) {
                ScopedMethod.validQueryParams[s][m] = new HashSet<String>();
            }
        }
    }
}

