/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.model.LabelProvider;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.markers.MarkableImpl;

public class MarkableComparator
implements Comparator<Markable>,
AdapterFactory<Markable, Comparator> {
    @Override
    public int compare(Markable m1, Markable m2) {
        String label2;
        String label1;
        int rank2;
        MarkableImpl impl1 = MarkableComparator.getMarkableImpl(m1);
        MarkableImpl impl2 = MarkableComparator.getMarkableImpl(m2);
        int rank1 = impl1.getRank();
        if (rank1 != (rank2 = impl2.getRank())) {
            return rank1 - rank2;
        }
        LabelProvider p1 = (LabelProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)m1, LabelProvider.class);
        LabelProvider p2 = (LabelProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)m2, LabelProvider.class);
        if (null == p1 || null == p2) {
            label1 = URLFileSystem.getFileName((URL)m1.getUrl());
            label2 = URLFileSystem.getFileName((URL)m2.getUrl());
        } else {
            label1 = p1.labelFor((Object)m1, LabelProvider.SHORT_LABEL);
            label2 = p2.labelFor((Object)m2, LabelProvider.SHORT_LABEL);
        }
        return label1.compareTo(label2);
    }

    public Comparator adapt(Markable obj) {
        return this;
    }

    public static MarkableImpl getMarkableImpl(Markable markable) {
        InvocationHandler handler;
        if (null == markable) {
            return null;
        }
        if (markable instanceof MarkableImpl) {
            return (MarkableImpl)markable;
        }
        if (Proxy.isProxyClass(markable.getClass()) && (handler = Proxy.getInvocationHandler(markable)) instanceof Markable) {
            return MarkableComparator.getMarkableImpl((Markable)((Object)handler));
        }
        MarkableImpl impl = (MarkableImpl)AdapterManager.Factory.getAdapterManager().adapt((Object)markable, MarkableImpl.class);
        if (null != impl) {
            return impl;
        }
        final int[] markableRank = new int[]{Integer.MAX_VALUE};
        ArrayList<Marker> markers = new ArrayList<Marker>(markable.getMarkers());
        if (!markers.isEmpty()) {
            Collections.sort(markers);
            Marker topMarker = (Marker)markers.get(0);
            Integer rank = (Integer)AdapterManager.Factory.getAdapterManager().adapt((Object)topMarker, Integer.class);
            if (null != rank) {
                markableRank[0] = rank;
            }
        }
        return new MarkableImpl(markable){

            @Override
            public synchronized int getRank() {
                return markableRank[0];
            }
        };
    }
}

