/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.TextMarker;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.TextBufferTracker;
import oracle.ide.model.TextNode;
import oracle.ideimpl.markers.MarkableNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.util.Log;
import org.openide.util.RequestProcessor;

public class MarkableText
extends MarkableNode<TextNode> {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("MarkableText");
    private static final Log LOG = new Log("MarkableText");
    private static final String OFFSET_ATTR = "offset";
    private static final String LENGTH_ATTR = "length";
    private static final String BUFFER_VERSION_ATTR = "#_buffer_version";
    private static final String LINE_ATTR = "line";
    private static final String COLUMN_ATTR = "column";
    private TextBufferTracker tracker;
    private TBL listener;

    public MarkableText(TextNode textNode) {
        super(textNode);
    }

    @Override
    protected void init(TextNode textNode) {
        super.init(textNode);
        this.tracker = TextBufferTracker.getTracker((TextNode)textNode);
        if (textNode.isOpen()) {
            textNode.addTextBufferListener(this.getListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMarkers(Marker ... markers) throws MarkerException {
        for (Marker marker : markers) {
            if (!(marker instanceof TextMarker)) continue;
            TextMarker textMarker = (TextMarker)marker;
            Map<String, Object> attrs = textMarker.getAttributes();
            attrs.put(BUFFER_VERSION_ATTR, this.tracker.getVersion());
            if (attrs.containsKey(LINE_ATTR) && attrs.containsKey(COLUMN_ATTR) && !attrs.containsKey(OFFSET_ATTR)) {
                TextNode textNode = (TextNode)this.getNode();
                try {
                    TextBuffer buffer = textNode.acquireTextBuffer();
                    if (null != buffer) {
                        LineMap lineMap = buffer.getLineMap();
                        int offset = lineMap.getLineStartOffset(textMarker.line()) + textMarker.column();
                        attrs.put(OFFSET_ATTR, offset);
                    }
                }
                finally {
                    textNode.releaseTextBuffer();
                }
            }
            marker.update(attrs, true);
        }
        super.addMarkers(markers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextMarkers() {
        int[] newOffsetAndLength = new int[]{0, 0};
        TextNode textNode = (TextNode)this.getNode();
        try {
            LOG.trace("Updating TextMarkers for {0}", (Object)textNode);
            TextBuffer buffer = textNode.acquireTextBuffer();
            LineMap lineMap = null != buffer ? buffer.getLineMap() : null;
            List<TextMarker> markers = this.getMarkers(TextMarker.class, true);
            for (TextMarker marker : markers) {
                int oldOffset = marker.offset();
                int oldLength = marker.length();
                int oldVersion = marker.getAttribute(BUFFER_VERSION_ATTR, 0);
                if (oldVersion == this.tracker.getVersion()) continue;
                this.tracker.adjustOffsetLength(oldOffset, oldLength, oldVersion, newOffsetAndLength);
                try {
                    HashMap<String, Object> attrs = new HashMap<String, Object>();
                    attrs.put(OFFSET_ATTR, newOffsetAndLength[0]);
                    attrs.put(LENGTH_ATTR, newOffsetAndLength[1]);
                    attrs.put(BUFFER_VERSION_ATTR, this.tracker.getVersion());
                    if (null != lineMap) {
                        int offset = newOffsetAndLength[0];
                        int line = lineMap.getLineFromOffset(offset);
                        int column = offset - lineMap.getLineStartOffset(line);
                        if (0 == column) {
                            column = offset - lineMap.getLineStartOffset(--line);
                        }
                        attrs.put(LINE_ATTR, ++line);
                        attrs.put(COLUMN_ATTR, column);
                    }
                    LOG.trace("Updating attributes for marker ({0}) to {1}", (Object)marker, attrs);
                    marker.update(attrs, false);
                }
                catch (MarkerException me) {
                    FeedbackManager.reportException((Throwable)me);
                }
            }
        }
        finally {
            textNode.releaseTextBuffer();
        }
    }

    public void nodeOpened(NodeEvent e) {
        Node node = e.getNode();
        if (node instanceof TextNode) {
            ((TextNode)node).addTextBufferListener(this.getListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBufferListener getListener() {
        MarkableText markableText = this;
        synchronized (markableText) {
            if (null == this.listener) {
                this.listener = new TBL();
            }
        }
        return this.listener;
    }

    private class TBL
    implements TextBufferListener {
        private ScheduledFuture<?> scheduled;

        private TBL() {
        }

        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            this.updateTextMarkers();
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            this.updateTextMarkers();
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        private void updateTextMarkers() {
            if (null != this.scheduled && !this.scheduled.isDone()) {
                return;
            }
            this.scheduled = PROCESSOR.schedule(new Runnable(){

                @Override
                public void run() {
                    MarkableText.this.updateTextMarkers();
                }
            }, 500L, TimeUnit.MILLISECONDS);
        }
    }
}

