/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.markers.Marker;
import oracle.ide.markers.ProblemMarker;
import oracle.ide.markers.TaskMarker;
import oracle.ide.markers.TextMarker;
import oracle.javatools.util.ClassHierarchy;

public class MarkerRankCalculator {
    private static final int BASE_PROBLEM_MARKER_RANK = 100;
    private static final int BASE_TASK_MARKER_RANK = 100 + ProblemMarker.Severity.INCOMPLETE.value;
    private static final int BASE_TEXT_MARKER_RANK = BASE_TASK_MARKER_RANK + TaskMarker.Priority.LOW.value;
    private static final int BASE_MARKER_RANK = Integer.MAX_VALUE;
    private static final Map<Class<? extends Marker>, Integer> MARKER_TYPE_RANKS = new HashMap<Class<? extends Marker>, Integer>();

    public static long calculateRank(Marker marker) {
        int majorRank = Integer.MAX_VALUE;
        int minorRank = marker instanceof TextMarker ? ((TextMarker)marker).offset() : 0;
        List classOrder = ClassHierarchy.getClassOrder(marker.getClass());
        for (Class _class : classOrder) {
            Integer typeRank = MARKER_TYPE_RANKS.get(_class);
            if (null == typeRank) continue;
            majorRank = Math.min(majorRank, typeRank);
        }
        majorRank = MarkerRankCalculator.adjustRank(majorRank, marker);
        return (long)minorRank << 32 | (long)majorRank;
    }

    private static int adjustRank(int majorRank, Marker marker) {
        Integer adjustment = (Integer)AdapterManager.Factory.getAdapterManager().adapt((Object)marker, Integer.class);
        if (null != adjustment) {
            return majorRank + adjustment;
        }
        return majorRank;
    }

    static {
        MARKER_TYPE_RANKS.put(ProblemMarker.class, 100);
        MARKER_TYPE_RANKS.put(TaskMarker.class, BASE_TASK_MARKER_RANK);
        MARKER_TYPE_RANKS.put(TextMarker.class, BASE_TEXT_MARKER_RANK);
        MARKER_TYPE_RANKS.put(Marker.class, Integer.MAX_VALUE);
    }
}

