/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerEvent;
import oracle.ide.markers.MarkerEventHandler;
import oracle.ide.markers.MarkerEventType;
import oracle.ide.markers.MarkerException;
import oracle.ide.util.Assert;
import oracle.ideimpl.markers.MarkerEventHandlerDescriptor;
import oracle.ideimpl.markers.MarkerStore;
import oracle.ideimpl.markers.ProjectMarkerStore;
import org.openide.util.RequestProcessor;

public class MasterMarkerStore
implements MarkerStore {
    private final RequestProcessor processor = new RequestProcessor(MasterMarkerStore.class.getName(), 10);
    private final MarkerStore store;

    public MasterMarkerStore() {
        this(new ProjectMarkerStore());
    }

    public MasterMarkerStore(MarkerStore store) {
        if (null == store) {
            throw new IllegalArgumentException("MarkerStore delegate must not be null");
        }
        this.store = store;
    }

    @Override
    public <M extends Marker> Collection<M> addMarkers(M ... markers) throws MarkerException {
        if (null == markers || 0 == markers.length) {
            throw new MarkerException("At least one marker expected");
        }
        Collection added = this.store.addMarkers((Marker[])markers);
        if (null != added && !added.isEmpty()) {
            this.fireEvent(new MarkerEvent(this, MarkerEventType.MARKERS_ADDED, added.toArray(new Marker[added.size()])));
        }
        return added;
    }

    @Override
    public <M extends Marker> Collection<M> removeMarkers(M ... markers) throws MarkerException {
        if (null == markers || 0 == markers.length) {
            return Collections.emptyList();
        }
        Collection removed = this.store.removeMarkers((Marker[])markers);
        if (null != removed && !removed.isEmpty()) {
            this.fireEvent(new MarkerEvent(this, MarkerEventType.MARKERS_REMOVED, removed.toArray(new Marker[removed.size()])));
        }
        return removed;
    }

    @Override
    public Collection<Marker> getMarkers(Markable markable) {
        if (null == markable) {
            return Collections.emptyList();
        }
        return this.store.getMarkers(markable);
    }

    private void fireEvent(MarkerEvent event) {
        NotificationTask task = new NotificationTask(event, MarkerEventHandlerDescriptor.Factory.getHandlers());
        this.processor.execute((Runnable)task);
    }

    @Override
    public <M extends Marker> Collection<M> updateMarkers(M ... markers) throws MarkerException {
        Collection updated = this.store.updateMarkers((Marker[])markers);
        this.fireEvent(new MarkerEvent(this, MarkerEventType.MARKERS_CHANGED, (Marker[])markers));
        return updated;
    }

    @Override
    public Collection<Marker> getMarkers() {
        return this.store.getMarkers();
    }

    @Override
    public void clear() {
        Collection<Marker> allMarkers = this.getMarkers();
        try {
            this.removeMarkers(allMarkers.toArray(new Marker[allMarkers.size()]));
        }
        catch (MarkerException e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public void dispose() {
        this.store.dispose();
    }

    private class NotificationTask
    implements Runnable {
        private final String TIMING_KEY = this.toString();
        private final Iterable<MarkerEventHandlerDescriptor> handlerDescriptors;
        private final MarkerEvent event;

        public NotificationTask(MarkerEvent event, Iterable<MarkerEventHandlerDescriptor> handlerDescriptors) {
            this.event = event;
            this.handlerDescriptors = handlerDescriptors;
        }

        @Override
        public void run() {
            for (MarkerEventHandlerDescriptor descriptor : this.handlerDescriptors) {
                MarkerEventHandler handler;
                if (!descriptor.matches(this.event) || null == (handler = descriptor.getHandler())) continue;
                Assert.startTiming((String)this.TIMING_KEY, null, (boolean)false);
                handler.handleEvent(this.event);
                String msg = MessageFormat.format("{0} processed marker event ({1}) with {2} marker(s)", new Object[]{handler.getClass().getSimpleName(), this.event.getEventType(), this.event.getMarkers().size()});
                Assert.endTiming((String)this.TIMING_KEY, (String)msg, null, (boolean)false);
            }
        }
    }
}

