/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf2.FixedFieldCaret;

public class OracleFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    public static ComponentUI createUI(JComponent c) {
        return new OracleFormattedTextFieldUI();
    }

    @Override
    protected Caret createCaret() {
        return new FormatFieldCaret();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent comp;
        Color background;
        super.propertyChange(evt);
        if ("enabled".equals(evt.getPropertyName()) && (background = (comp = this.getComponent()).getBackground()) instanceof UIResource) {
            LookAndFeel.installProperty(comp, "opaque", evt.getNewValue());
        }
    }

    private class FormatFieldCaret
    extends FixedFieldCaret {
        private FormatFieldCaret() {
        }

        @Override
        public void focusGained(final FocusEvent fe) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormatFieldCaret.super.focusGained(fe);
                }
            });
        }

        @Override
        public void mousePressed(final MouseEvent me) {
            super.mousePressed(me);
            if (SwingUtilities.isLeftMouseButton(me)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormatFieldCaret.this.positionCaret(me);
                    }
                });
            }
        }
    }
}

