/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterables {
    public static <T> Iterable<T> iterable(T[] a) {
        return new FilteredArrayIterable<Object>(a, p -> true);
    }

    public static <T> Iterable<T> filteredIterable(Iterable<T> i, Predicate<T> filter) {
        return new FilteredIterable<T>(i, filter);
    }

    public static <T, R> Iterable<R> filteredIterable(Iterable<T> i, Predicate<T> filter, Function<T, R> mapper) {
        return new FilteredMappedIterable<T, R>(i, filter, mapper);
    }

    public static <T> Iterable<T> filteredIterable(T[] a, Predicate<T> filter) {
        return new FilteredArrayIterable<T>(a, filter);
    }

    public static <T, R> Iterable<R> filteredIterable(T[] a, Predicate<T> filter, Function<T, R> mapper) {
        return new FilteredMappedArrayIterable<T, R>(a, filter, mapper);
    }

    public static <T> Iterator<T> filteredIterator(Iterator<T> i, Predicate<T> filter) {
        return new FilteredIterator<T>(i, filter);
    }

    public static <T, R> Iterator<R> filteredIterator(Iterator<T> i, Predicate<T> filter, Function<T, R> mapper) {
        return new FilteredMappedIterator<T, R>(i, filter, mapper);
    }

    public static <T> Iterator<T> filteredIterator(T[] a, Predicate<T> filter) {
        return new FilteredArrayIterator<T>(a, filter);
    }

    public static <T, R> Iterator<R> filteredIterator(T[] a, Predicate<T> filter, Function<T, R> mapper) {
        return new FilteredMappedArrayIterator<T, R>(a, filter, mapper);
    }

    public static <T> Iterable<T> flatteningIterable(Iterable<? extends Iterable<T>> i) {
        return new FlatteningIterable(i);
    }

    public static <T> Iterator<T> flatteningIterator(Iterator<? extends Iterable<T>> i) {
        return new FlatteningIterator(i);
    }

    public static <T, R> Iterable<R> mappedIterable(Iterable<T> i, Function<T, R> mapper) {
        return new FilteredMappedIterable<Object, R>(i, t -> true, mapper);
    }

    public static <T, R> Iterable<R> mappedIterable(T[] a, Function<T, R> mapper) {
        return new FilteredMappedArrayIterable<Object, R>(a, t -> true, mapper);
    }

    public static <T, R> Iterator<R> mappedIterator(Iterator<T> i, Function<T, R> mapper) {
        return new FilteredMappedIterator<Object, R>(i, t -> true, mapper);
    }

    public static <T, R> Iterator<R> mappedIterator(T[] a, Function<T, R> mapper) {
        return new FilteredMappedArrayIterator<Object, R>(a, t -> true, mapper);
    }

    public static <T> List<T> sortedList(Iterator<T> iterator) {
        ArrayList<Object> elements = new ArrayList<Object>();
        while (iterator.hasNext()) {
            elements.add(iterator.next());
        }
        elements.sort(null);
        return elements;
    }

    public static <T> List<T> sortedList(Iterator<T> iterator, Comparator<? super T> comparator) {
        ArrayList<Object> elements = new ArrayList<Object>();
        while (iterator.hasNext()) {
            elements.add(iterator.next());
        }
        elements.sort(comparator);
        return elements;
    }

    public static <T> List<T> sortedList(Iterable<T> iterable) {
        ArrayList<Object> elements = iterable instanceof Collection ? new ArrayList<Object>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            elements.add(element);
        }
        elements.sort(null);
        return elements;
    }

    public static <T> List<T> sortedList(Iterable<T> iterable, Comparator<? super T> comparator) {
        ArrayList<Object> elements = iterable instanceof Collection ? new ArrayList<Object>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            elements.add(element);
        }
        elements.sort(comparator);
        return elements;
    }

    private static class FlatteningIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends Iterable<T>> outer;
        private Iterator<T> inner;

        public FlatteningIterator(Iterator<? extends Iterable<T>> outer) {
            this.outer = outer;
            if (outer.hasNext()) {
                this.inner = outer.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.inner == null) {
                return false;
            }
            if (this.inner.hasNext()) {
                return true;
            }
            while (this.outer.hasNext()) {
                this.inner = this.outer.next().iterator();
                if (!this.inner.hasNext()) continue;
                return true;
            }
            this.inner = null;
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.inner.next();
        }
    }

    private static class FlatteningIterable<T>
    implements Iterable<T> {
        private final Iterable<? extends Iterable<T>> i;

        public FlatteningIterable(Iterable<? extends Iterable<T>> i) {
            this.i = i;
        }

        @Override
        public Iterator<T> iterator() {
            return new FlatteningIterator(this.i.iterator());
        }
    }

    private static class FilteredMappedArrayIterator<T, R>
    implements Iterator<R> {
        private final T[] a;
        private final Predicate<T> filter;
        private final Function<T, R> mapper;
        private int index;

        public FilteredMappedArrayIterator(T[] a, Predicate<T> filter, Function<T, R> mapper) {
            this.a = a;
            this.filter = filter;
            this.mapper = mapper;
            this.index = this.advance(0);
        }

        private int advance(int index) {
            for (int i = index; i < this.a.length; ++i) {
                if (!this.filter.test(this.a[i])) continue;
                return i;
            }
            return this.a.length;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.a.length;
        }

        @Override
        public R next() {
            if (this.index >= this.a.length) {
                throw new NoSuchElementException();
            }
            R result = this.mapper.apply(this.a[this.index]);
            this.index = this.advance(this.index + 1);
            return result;
        }
    }

    private static class FilteredArrayIterator<T>
    implements Iterator<T> {
        private final T[] a;
        private final Predicate<T> filter;
        private int index;
        private int length;

        public FilteredArrayIterator(T[] a, Predicate<T> filter) {
            this.a = a;
            this.filter = filter;
            this.index = this.advance(0);
            this.length = a.length;
        }

        private int advance(int index) {
            for (int i = index; i < this.length; ++i) {
                if (!this.filter.test(this.a[i])) continue;
                return i;
            }
            return this.length;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public T next() {
            if (this.index >= this.length) {
                throw new NoSuchElementException();
            }
            T result = this.a[this.index];
            this.index = this.advance(this.index + 1);
            return result;
        }
    }

    private static class FilteredMappedIterator<T, R>
    implements Iterator<R> {
        private final Iterator<T> delegate;
        private final Predicate<T> predicate;
        private final Function<T, R> mapper;
        private T next;

        public FilteredMappedIterator(Iterator<T> delegate, Predicate<T> predicate, Function<T, R> mapper) {
            this.delegate = delegate;
            this.predicate = predicate;
            this.mapper = mapper;
            this.next = this.advance();
        }

        private T advance() {
            while (this.delegate.hasNext()) {
                T item = this.delegate.next();
                if (!this.predicate.test(item)) continue;
                return item;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public R next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            R result = this.mapper.apply(this.next);
            this.next = this.advance();
            return result;
        }
    }

    private static class FilteredIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;
        private final Predicate<T> predicate;
        private T next;

        public FilteredIterator(Iterator<T> delegate, Predicate<T> predicate) {
            this.delegate = delegate;
            this.predicate = predicate;
            this.next = this.advance();
        }

        private T advance() {
            while (this.delegate.hasNext()) {
                T item = this.delegate.next();
                if (!this.predicate.test(item)) continue;
                return item;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T result = this.next;
            this.next = this.advance();
            return result;
        }
    }

    private static class FilteredMappedArrayIterable<T, R>
    implements Iterable<R> {
        private final T[] a;
        private final Predicate<T> filter;
        private final Function<T, R> mapper;

        public FilteredMappedArrayIterable(T[] a, Predicate<T> filter, Function<T, R> mapper) {
            this.a = a;
            this.filter = filter;
            this.mapper = mapper;
        }

        @Override
        public Iterator<R> iterator() {
            return new FilteredMappedArrayIterator<T, R>(this.a, this.filter, this.mapper);
        }
    }

    private static class FilteredArrayIterable<T>
    implements Iterable<T> {
        private final T[] a;
        private final Predicate<T> filter;

        public FilteredArrayIterable(T[] a, Predicate<T> filter) {
            this.a = a;
            this.filter = filter;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilteredArrayIterator<T>(this.a, this.filter);
        }
    }

    private static class FilteredMappedIterable<T, R>
    implements Iterable<R> {
        private final Iterable<T> delegate;
        private final Predicate<T> predicate;
        private final Function<T, R> mapper;

        public FilteredMappedIterable(Iterable<T> delegate, Predicate<T> predicate, Function<T, R> mapper) {
            this.delegate = delegate;
            this.predicate = predicate;
            this.mapper = mapper;
        }

        @Override
        public Iterator<R> iterator() {
            return new FilteredMappedIterator<T, R>(this.delegate.iterator(), this.predicate, this.mapper);
        }
    }

    private static class FilteredIterable<T>
    implements Iterable<T> {
        private final Iterable<T> delegate;
        private final Predicate<T> predicate;

        public FilteredIterable(Iterable<T> delegate, Predicate<T> predicate) {
            this.delegate = delegate;
            this.predicate = predicate;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilteredIterator<T>(this.delegate.iterator(), this.predicate);
        }
    }
}

