/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.installation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;

public class Macros {
    private Map<String, String> macros = new HashMap<String, String>();

    public Macros(Path middlewareHome, Log log) throws CommandException {
        if (middlewareHome == null) {
            return;
        }
        Path macrosDir = middlewareHome.resolve("jdeveloper/ide/macros");
        if (!Files.isDirectory(macrosDir, new LinkOption[0])) {
            return;
        }
        try {
            for (Path path : Files.newDirectoryStream(macrosDir, p -> Paths.hasSuffix(p, ".properties", ".xml"))) {
                try {
                    InputStream bytes = Files.newInputStream(path, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        Properties properties = new Properties();
                        if (path.getFileName().endsWith(".xml")) {
                            properties.loadFromXML(bytes);
                        } else {
                            properties.load(bytes);
                        }
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            StringBuilder builder = new StringBuilder();
                            int start = 0;
                            while (start < value.length()) {
                                int end = value.indexOf(44, start);
                                if (end < 0) {
                                    end = value.length();
                                }
                                if (value.regionMatches(start, "file:", 0, "file:".length())) {
                                    Path resolution = path.getParent().resolve(value.substring(start + "file:".length(), end).trim()).normalize();
                                    builder.append(resolution);
                                } else {
                                    builder.append(value, start, end);
                                }
                                if (end < value.length()) {
                                    builder.append(',');
                                }
                                start = end + 1;
                            }
                            this.macros.put(key, builder.toString());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bytes == null) continue;
                        if (throwable != null) {
                            try {
                                bytes.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        bytes.close();
                    }
                }
                catch (IOException e) {
                    log.error("installation-macros-unread", "JDeveloper macros %s file not read: %s", path, e);
                }
            }
        }
        catch (IOException e) {
            throw new CommandException("JDeveloper macro directory %s not scanned: %s", macrosDir, e);
        }
    }

    public void addMacro(String key, String value) {
        if (this.macros.putIfAbsent(key, value) != null) {
            throw new IllegalArgumentException("key already present");
        }
    }

    public Map<String, String> getMacros() {
        return this.macros;
    }
}

