/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

public class IllegalNameException
extends IllegalArgumentException {
    public static final String END_OF_NAME = "END-OF-NAME";
    private final String message;
    private final String expected;
    private final String found;
    private final String name;

    public IllegalNameException(String message, String name) {
        this.message = message;
        this.name = name;
        this.found = null;
        this.expected = null;
    }

    public IllegalNameException(String expected, int at, String name) {
        this(expected, at, at, name, 0, name.length());
    }

    public IllegalNameException(String expected, int at, String name, int offset) {
        this(expected, at, at, name, offset, name.length());
    }

    public IllegalNameException(String expected, int at, String name, int offset, int endOffset) {
        this(expected, at, at, name, offset, endOffset);
    }

    public IllegalNameException(String expected, int from, int to, String name, int offset) {
        this(expected, from, to, name, offset, name.length());
    }

    public IllegalNameException(String expected, int from, int to, String name) {
        this(expected, from, to, name, 0, name.length());
    }

    public IllegalNameException(String expected, int from, int to, String name, int offset, int endOffset) {
        this.expected = expected;
        endOffset = Math.min(endOffset, name.length());
        offset = Math.min(offset, endOffset);
        this.name = name.substring(offset, endOffset);
        to = Math.min(to, endOffset);
        from = Math.min(from, to);
        this.found = from >= endOffset ? END_OF_NAME : (to - from <= 1 ? "'" + name.charAt(from) + "'" : '\"' + name.substring(from, to) + '\"');
        this.message = null;
    }

    public IllegalNameException(String expected, String found, String name) {
        this(expected, found, name, 0, name.length());
    }

    public IllegalNameException(String expected, String found, String name, int offset) {
        this(expected, found, name, offset, name.length());
    }

    public IllegalNameException(String expected, String found, String name, int offset, int endOffset) {
        this.expected = expected;
        switch (found.length()) {
            case 1: {
                this.found = "'" + found + "'";
                break;
            }
            default: {
                this.found = found.charAt(0) == '\"' && found.endsWith("\"") ? found : '\"' + found + '\"';
            }
        }
        this.name = name.substring(offset, endOffset);
        this.message = null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return String.format(this.name, new Object[0]);
        }
        return "expected " + this.expected + ", found " + this.found + ": \"" + this.name + '\"';
    }
}

