/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.IllegalNameException;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.Scanner;
import oracle.javatools.exports.specification.TypeExportSpecification;
import oracle.javatools.util.ArraySortedSet;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.UnexpectedExceptionError;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportSpecificationReader
extends DefaultHandler {
    private NameSpace nameSpace;
    private boolean schemaValidating;
    private boolean domainValidating;
    private boolean quiet;
    private ExportDomain globalDomain;
    private SAXParser parser;
    private URL fileUrl;
    private Locator locator;
    private int line;
    private int column;
    private String qualifiedNameToSkip;
    private Log log;
    private String owner;
    private AtomicInteger nextAnonymousOwner = new AtomicInteger();
    private String source;
    private Set<String> consumers;
    private ExportDomain localDomain;
    private String domainName;
    private Set<String> exceptionNames;
    private Map<PackageName, PackageExportSpecification> rootPackages;
    private PackageName packageName;
    private CompatibilityAccess packageExtensionAccess;
    private CompatibilityAccess packageMembersAccess;
    private Map<TypeName, TypeExportSpecification> packageTypes;
    private Set<TypeName> packageInterfaces;
    private Map<String, CompatibilityAccess> packageResources;
    private TypeName typeName;
    private CompatibilityAccess typeAccess;
    private CompatibilityAccess typeExtensionAccess;
    private CompatibilityAccess typeMembersAccess;
    private Map<MemberName, CompatibilityAccess> typeMembers;
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_EXPORTED_MEMBERS_EXPORTED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.EXPORTED, null, CompatibilityAccess.EXPORTED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_EXPORTED_MEMBERS_RESTRICTED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.EXPORTED, null, CompatibilityAccess.RESTRICTED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_EXPORTED_MEMBERS_CONCEALED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.EXPORTED, null, CompatibilityAccess.CONCEALED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_RESTRICTED_MEMBERS_EXPORTED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.RESTRICTED, null, CompatibilityAccess.EXPORTED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_RESTRICTED_MEMBERS_RESTRICTED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.RESTRICTED, null, CompatibilityAccess.RESTRICTED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_RESTRICTED_MEMBERS_CONCEALED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.RESTRICTED, null, CompatibilityAccess.CONCEALED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_CONCEALED_MEMBERS_EXPORTED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.CONCEALED, null, CompatibilityAccess.EXPORTED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_CONCEALED_MEMBERS_RESTRICTED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.CONCEALED, null, CompatibilityAccess.RESTRICTED);
    private static final TypeExportSpecification TYPE_EXPORTED_EXTENSION_CONCEALED_MEMBERS_CONCEALED = new TypeExportSpecification(CompatibilityAccess.EXPORTED, CompatibilityAccess.CONCEALED, null, CompatibilityAccess.CONCEALED);
    private static final TypeExportSpecification TYPE_RESTRICTED_EXTENSION_RESTRICTED_MEMBERS_RESTRICTED = new TypeExportSpecification(CompatibilityAccess.RESTRICTED, CompatibilityAccess.RESTRICTED, null, CompatibilityAccess.RESTRICTED);
    private static final TypeExportSpecification TYPE_RESTRICTED_EXTENSION_RESTRICTED_MEMBERS_CONCEALED = new TypeExportSpecification(CompatibilityAccess.RESTRICTED, CompatibilityAccess.RESTRICTED, null, CompatibilityAccess.CONCEALED);
    private static final TypeExportSpecification TYPE_RESTRICTED_EXTENSION_CONCEALED_MEMBERS_RESTRICTED = new TypeExportSpecification(CompatibilityAccess.RESTRICTED, CompatibilityAccess.CONCEALED, null, CompatibilityAccess.RESTRICTED);
    private static final TypeExportSpecification TYPE_RESTRICTED_EXTENSION_CONCEALED_MEMBERS_CONCEALED = new TypeExportSpecification(CompatibilityAccess.RESTRICTED, CompatibilityAccess.CONCEALED, null, CompatibilityAccess.CONCEALED);
    private static final TypeExportSpecification TYPE_CONCEALED_EXTENSION_CONCEALED_MEMBERS_CONCEALED = new TypeExportSpecification(CompatibilityAccess.CONCEALED, CompatibilityAccess.CONCEALED, null, CompatibilityAccess.CONCEALED);
    private static final PackageExportSpecification PACKAGE_EXPORTED_MEMBERS_EXPORTED = PackageExportSpecification.EXPORTED_MEMBERS_EXPORTED;
    private static final PackageExportSpecification PACKAGE_RESTRICTED_MEMBERS_RESTRICTED = PackageExportSpecification.RESTRICTED_MEMBERS_RESTRICTED;
    private static final String LIB_EXPORTS = "lib-exports";
    private static final String CONSUMER = "consumer";
    private static final String DOMAINS = "domains";
    private static final String DOMAIN = "domain";
    private static final String EXCEPT = "except";
    private static final String PACKAGE = "package";
    private static final String CLASS = "class";
    private static final String INTERFACE = "interface";
    private static final String CONSTRUCTOR = "constructor";
    private static final String METHOD = "method";
    private static final String FIELD = "field";
    private static final String RESOURCE = "resource";
    static final String END_LABEL = "END-OF-TEXT";

    public ExportSpecificationReader() {
        this(NameSpace.defaultNameSpace(), null, false, false);
    }

    public ExportSpecificationReader(NameSpace nameSpace, ExportDomain domain, boolean validating, boolean quiet) {
        if (nameSpace == null) {
            throw new NullArgumentException("pool == null");
        }
        this.nameSpace = nameSpace;
        this.globalDomain = domain != null ? domain : new ExportDomain(new String[0]);
        this.schemaValidating = validating;
        this.domainValidating = validating;
        this.quiet = quiet;
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(NameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    public ExportDomain getExportDomain() {
        return this.globalDomain;
    }

    public boolean isSchemaValidating() {
        return this.schemaValidating;
    }

    public void setSchemaValidating(boolean schemaValidating) {
        if (schemaValidating != this.schemaValidating) {
            this.schemaValidating = schemaValidating;
            this.parser = null;
        }
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isDomainValidating() {
        return this.domainValidating;
    }

    public void setDomainValidating(boolean domainValidating) {
        this.domainValidating = domainValidating;
    }

    public ExportSpecification read(Scope scope, Path path, Log log) throws ParserConfigurationException, SAXException, IOException {
        try (InputStream exportsStream = Files.newInputStream(path, new OpenOption[0]);){
            ExportSpecification exportSpecification = this.readInternal(scope, Paths.toUrl(path), exportsStream, log);
            return exportSpecification;
        }
    }

    public ExportSpecification read(Scope scope, URL url, Log log) throws ParserConfigurationException, SAXException, IOException {
        try (InputStream exportsStream = URLFileSystem.openInputStream(url);){
            ExportSpecification exportSpecification = this.readInternal(scope, url, exportsStream, log);
            return exportSpecification;
        }
    }

    public ExportSpecification read(Scope scope, URL exportsUrl, InputStream exportsStream, Log log) throws ParserConfigurationException, SAXException, IOException {
        try (InputStream stream = exportsStream;){
            ExportSpecification exportSpecification = this.readInternal(scope, exportsUrl, stream, log);
            return exportSpecification;
        }
    }

    private ExportSpecification readInternal(Scope scope, URL exportsUrl, InputStream exportsStream, Log log) throws ParserConfigurationException, SAXException, IOException {
        if (exportsStream == null) {
            throw new IOException("null input stream for " + exportsUrl);
        }
        this.log = log.child(new Tag("scope", exportsUrl));
        this.fileUrl = exportsUrl;
        if (this.parser == null) {
            if (this.schemaValidating) {
                InputStream schemaInputStream = ExportSpecification.class.getResourceAsStream("lib-exports.xsd");
                StreamSource schemaSource = new StreamSource(schemaInputStream);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaSource);
                SAXParserFactory factory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", ClassLoader.getSystemClassLoader());
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setSchema(schema);
                this.parser = factory.newSAXParser();
            } else {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
        }
        this.column = 0;
        this.line = 0;
        try {
            this.parser.parse(exportsStream, (DefaultHandler)this);
        }
        catch (LocatorSAXException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new LocatorSAXException(e, e.getMessage() + this.at(), new Object[0]);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage() + this.at(), e);
        }
        ExportDomain domain = ExportDomain.intersection(this.localDomain, this.globalDomain);
        return new ExportSpecification(scope, this.owner, this.source, this.consumers.isEmpty() ? Collections.emptySet() : this.consumers, domain, this.rootPackages.isEmpty() ? Collections.emptyMap() : this.rootPackages);
    }

    @Override
    public void startDocument() throws SAXException {
        this.consumers = new LinkedHashSet<String>();
        this.localDomain = new ExportDomain(new String[0]);
        this.rootPackages = new LinkedHashMap<PackageName, PackageExportSpecification>();
        this.packageName = null;
        this.packageTypes = new LinkedHashMap<TypeName, TypeExportSpecification>();
        this.packageInterfaces = new HashSet<TypeName>();
        this.packageResources = new LinkedHashMap<String, CompatibilityAccess>();
        this.typeMembers = new LinkedHashMap<MemberName, CompatibilityAccess>();
        this.qualifiedNameToSkip = null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        try {
            switch (qualifiedName) {
                case "lib-exports": {
                    this.owner = attributes.getValue("owner");
                    if (this.owner == null || (this.owner = this.owner.trim()).isEmpty()) {
                        this.owner = "anonymous" + this.nextAnonymousOwner.getAndIncrement();
                        if (this.schemaValidating) {
                            this.log.error("exports-owner-absent", "expected non-empty owner attribute: synthesizing unique owner \"%s\"%s", this.owner, this.at());
                        }
                    }
                    this.source = attributes.getValue("source");
                    break;
                }
                case "consumer": {
                    this.consumers.add(this.getRequiredAttribute("team", attributes, qualifiedName));
                    break;
                }
                case "domains": {
                    break;
                }
                case "domain": {
                    if (this.packageName != null) {
                        throw new LocatorSAXException("<domain> element not allowed after <package> element" + this.at(), new Object[0]);
                    }
                    this.domainName = this.sanitizeQualifiedName(this.getRequiredAttribute("name", attributes, qualifiedName), this.log);
                    if (!this.domainName.endsWith(".")) {
                        this.domainName = this.domainName + '.';
                    }
                    this.exceptionNames = new ArraySortedSet<String>();
                    break;
                }
                case "except": {
                    if (this.domainName == null) {
                        throw new LocatorSAXException("<except> element not allowed outside <domain> element" + this.at(), new Object[0]);
                    }
                    String exceptionName = this.sanitizeQualifiedName(this.getRequiredAttribute("name", attributes, qualifiedName), this.log);
                    if (!exceptionName.endsWith(".")) {
                        exceptionName = exceptionName + '.';
                    }
                    if (!this.exceptionNames.add(exceptionName) && this.schemaValidating) {
                        this.log.warning("domain-duplicate-exception", "duplicate exception name %s%s", exceptionName.substring(0, exceptionName.length() - 1), this.at());
                    }
                    break;
                }
                case "package": {
                    this.packageName = this.nameSpace.packageNameSource(this.getRequiredAttribute("name", attributes, qualifiedName));
                    this.packageMembersAccess = this.exportedAccess(attributes.getValue("members"), CompatibilityAccess.EXPORTED, "members");
                    this.packageExtensionAccess = this.access(attributes.getValue("extension"), this.packageMembersAccess, "extension");
                    break;
                }
                case "class": 
                case "interface": {
                    this.typeName = this.nameSpace.typeNameSource(this.packageName, this.getRequiredAttribute("name", attributes, qualifiedName));
                    this.typeAccess = this.exportedAccess(attributes.getValue("access"), this.packageMembersAccess, "access");
                    this.typeExtensionAccess = this.access(attributes.getValue("extension"), CompatibilityAccess.mostConcealed(this.typeAccess, this.packageExtensionAccess), "extension");
                    this.typeMembersAccess = this.access(attributes.getValue("members"), this.typeAccess, "members");
                    break;
                }
                case "constructor": {
                    ConstructorName name = this.nameSpace.constructorNameSource(this.typeName, this.getRequiredAttribute("name", attributes, qualifiedName));
                    CompatibilityAccess access = this.exportedAccess(attributes.getValue("access"), this.typeMembersAccess, "access");
                    this.typeMembers.put(name, access);
                    break;
                }
                case "method": {
                    MethodName name = this.nameSpace.methodNameSource(this.typeName, this.getRequiredAttribute("name", attributes, qualifiedName));
                    CompatibilityAccess access = this.exportedAccess(attributes.getValue("access"), this.typeMembersAccess, "access");
                    this.typeMembers.put(name, access);
                    break;
                }
                case "field": {
                    FieldName name = this.nameSpace.fieldName(this.typeName, this.getRequiredAttribute("name", attributes, qualifiedName));
                    CompatibilityAccess access = this.exportedAccess(attributes.getValue("access"), this.typeMembersAccess, "access");
                    this.typeMembers.put(name, access);
                    break;
                }
                case "resource": {
                    String name = this.getRequiredAttribute("name", attributes, qualifiedName);
                    CompatibilityAccess access = this.exportedAccess(attributes.getValue("access"), this.packageMembersAccess, "access");
                    this.packageResources.put(name, access);
                    break;
                }
                default: {
                    this.log.error("exports-unexpected-element", "unexpected XML element name %s%s", qualifiedName, this.at());
                    break;
                }
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IllegalNameException e) {
            this.qualifiedNameToSkip = qualifiedName;
            this.log.error("exports-illegal-name", "illegal Java name in <%s> element, discarding: %s%s", qualifiedName, e.getMessage(), this.at());
        }
        catch (Exception e) {
            this.qualifiedNameToSkip = qualifiedName;
            throw new UnexpectedExceptionError("unexpected exception" + this.at() + ": " + e, e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
        }
        if (this.qualifiedNameToSkip != null) {
            if (qualifiedName.equals(this.qualifiedNameToSkip)) {
                this.qualifiedNameToSkip = null;
            }
            return;
        }
        switch (qualifiedName) {
            case "lib-exports": {
                break;
            }
            case "consumer": {
                break;
            }
            case "domains": {
                break;
            }
            case "domain": {
                this.localDomain.addSubdomain(this.domainName, this.exceptionNames);
                if (!this.exceptionNames.isEmpty()) {
                    this.exceptionNames = new ArraySortedSet<String>();
                }
                this.domainName = null;
                break;
            }
            case "except": {
                break;
            }
            case "package": {
                PackageExportSpecification packageSpecification;
                if (!this.localDomain.isUniversal() && !this.localDomain.dominates(this.packageName)) {
                    if (!this.domainValidating) break;
                    this.log.warning("exports-package-local", "package name %s not in local domain %s%s", this.packageName, this.localDomain, this.at());
                    break;
                }
                if (!this.globalDomain.isUniversal() && !this.globalDomain.dominates(this.packageName)) {
                    if (!this.domainValidating) break;
                    this.log.warning("exports-package-global", "package name %s not in global domain %s%s", this.packageName, this.globalDomain, this.at());
                    break;
                }
                if (this.packageTypes.isEmpty() && this.packageResources.isEmpty()) {
                    packageSpecification = CompatibilityAccess.isRestricted(this.packageMembersAccess) ? PACKAGE_RESTRICTED_MEMBERS_RESTRICTED : PACKAGE_EXPORTED_MEMBERS_EXPORTED;
                } else {
                    Map<TypeName, TypeExportSpecification> types = this.packageTypes;
                    if (types.isEmpty()) {
                        types = Collections.emptyMap();
                    } else {
                        this.packageTypes = new LinkedHashMap<TypeName, TypeExportSpecification>();
                    }
                    Set<TypeName> interfaces = this.packageInterfaces;
                    if (interfaces.isEmpty()) {
                        interfaces = Collections.emptySet();
                    } else {
                        this.packageInterfaces = new HashSet<TypeName>();
                    }
                    Map<String, CompatibilityAccess> resources = this.packageResources;
                    if (resources.isEmpty()) {
                        resources = Collections.emptyMap();
                    } else {
                        this.packageResources = new LinkedHashMap<String, CompatibilityAccess>();
                    }
                    packageSpecification = new PackageExportSpecification(CompatibilityAccess.CONCEALED, types, interfaces, resources);
                }
                PackageExportSpecification predecessor = this.rootPackages.putIfAbsent(this.packageName, packageSpecification);
                if (predecessor == null) break;
                Merge<PackageExportSpecification> merge = predecessor.merge(packageSpecification);
                this.rootPackages.put(this.packageName, merge.getValue());
                if (merge.getSeverity() != Severity.ERROR) break;
                this.log.warning("exports-merge-duplicate", "merging multiple specifications for package %s: %s%s", this.packageName, merge.getDescription(), this.at());
                break;
            }
            case "class": 
            case "interface": {
                TypeExportSpecification typeSpecification;
                if (CompatibilityAccess.isMoreExported(this.typeExtensionAccess, this.typeAccess)) {
                    this.log.warning("exports-extension-access", "extension=\"%s\" of type %s more exported than access \"%s\"%s", new Object[]{this.typeExtensionAccess, this.typeName, this.typeAccess, this.at()});
                    this.typeExtensionAccess = this.typeAccess;
                }
                if (CompatibilityAccess.isMoreExported(this.typeMembersAccess, this.typeAccess)) {
                    this.log.warning("exports-members-access", "members=\"%s\" of type %s more exported than access \"%s\"%s", new Object[]{this.typeMembersAccess, this.typeName, this.typeAccess, this.at()});
                    this.typeMembersAccess = this.typeAccess;
                }
                if (!this.typeMembers.isEmpty()) {
                    typeSpecification = new TypeExportSpecification(this.typeAccess, this.typeExtensionAccess, this.typeMembers, CompatibilityAccess.CONCEALED);
                    this.typeMembers = new LinkedHashMap<MemberName, CompatibilityAccess>();
                } else {
                    block25 : switch (this.typeAccess) {
                        case EXPORTED: {
                            switch (this.typeExtensionAccess) {
                                case EXPORTED: {
                                    switch (this.typeMembersAccess) {
                                        case EXPORTED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_EXPORTED_MEMBERS_EXPORTED;
                                            break block25;
                                        }
                                        case RESTRICTED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_EXPORTED_MEMBERS_RESTRICTED;
                                            break block25;
                                        }
                                        case CONCEALED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_EXPORTED_MEMBERS_CONCEALED;
                                            break block25;
                                        }
                                    }
                                    throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeMembersAccess));
                                }
                                case RESTRICTED: {
                                    switch (this.typeMembersAccess) {
                                        case EXPORTED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_RESTRICTED_MEMBERS_EXPORTED;
                                            break block25;
                                        }
                                        case RESTRICTED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_RESTRICTED_MEMBERS_RESTRICTED;
                                            break block25;
                                        }
                                        case CONCEALED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_RESTRICTED_MEMBERS_CONCEALED;
                                            break block25;
                                        }
                                    }
                                    throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeMembersAccess));
                                }
                                case CONCEALED: {
                                    switch (this.typeMembersAccess) {
                                        case EXPORTED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_CONCEALED_MEMBERS_EXPORTED;
                                            break block25;
                                        }
                                        case RESTRICTED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_CONCEALED_MEMBERS_RESTRICTED;
                                            break block25;
                                        }
                                        case CONCEALED: {
                                            typeSpecification = TYPE_EXPORTED_EXTENSION_CONCEALED_MEMBERS_CONCEALED;
                                            break block25;
                                        }
                                    }
                                    throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeMembersAccess));
                                }
                            }
                            throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeExtensionAccess));
                        }
                        case RESTRICTED: {
                            switch (this.typeExtensionAccess) {
                                case RESTRICTED: {
                                    switch (this.typeMembersAccess) {
                                        case RESTRICTED: {
                                            typeSpecification = TYPE_RESTRICTED_EXTENSION_RESTRICTED_MEMBERS_RESTRICTED;
                                            break block25;
                                        }
                                        case CONCEALED: {
                                            typeSpecification = TYPE_RESTRICTED_EXTENSION_RESTRICTED_MEMBERS_CONCEALED;
                                            break block25;
                                        }
                                    }
                                    throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeMembersAccess));
                                }
                                case CONCEALED: {
                                    switch (this.typeMembersAccess) {
                                        case RESTRICTED: {
                                            typeSpecification = TYPE_RESTRICTED_EXTENSION_CONCEALED_MEMBERS_RESTRICTED;
                                            break block25;
                                        }
                                        case CONCEALED: {
                                            typeSpecification = TYPE_RESTRICTED_EXTENSION_CONCEALED_MEMBERS_CONCEALED;
                                            break block25;
                                        }
                                    }
                                    throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeMembersAccess));
                                }
                            }
                            throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeExtensionAccess));
                        }
                        case CONCEALED: {
                            switch (this.typeExtensionAccess) {
                                case CONCEALED: {
                                    switch (this.typeMembersAccess) {
                                        case CONCEALED: {
                                            typeSpecification = TYPE_CONCEALED_EXTENSION_CONCEALED_MEMBERS_CONCEALED;
                                            break block25;
                                        }
                                    }
                                    throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeMembersAccess));
                                }
                            }
                            throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeExtensionAccess));
                        }
                        default: {
                            throw new IllegalStateException("unexpected access: " + (Object)((Object)this.typeAccess));
                        }
                    }
                }
                TypeExportSpecification predecessorType = this.packageTypes.putIfAbsent(this.typeName, typeSpecification);
                if (INTERFACE.equals(qualifiedName)) {
                    this.packageInterfaces.add(this.typeName);
                }
                if (predecessorType == null) break;
                Merge<TypeExportSpecification> merge = predecessorType.merge(typeSpecification);
                this.packageTypes.put(this.typeName, merge.getValue());
                if (merge.getSeverity() != Severity.ERROR) break;
                this.log.warning("exports-merge-duplicate", "merging multiple specifications for type %s: %s%s", this.typeName, merge.getDescription(), this.at());
                break;
            }
            case "constructor": 
            case "method": 
            case "field": {
                break;
            }
            case "resource": {
                break;
            }
        }
    }

    private String getRequiredAttribute(String name, Attributes attributes, String elementName) throws LocatorSAXException {
        String value = attributes.getValue(name);
        if (value == null) {
            throw new LocatorSAXException("%s attribute required in %s%s", name, elementName, this.at());
        }
        if ((value = value.trim()).isEmpty()) {
            throw new LocatorSAXException("non-empty %s attribute required in %s%s", name, elementName, this.at());
        }
        return value;
    }

    String sanitizeQualifiedName(String name, Log log) throws LocatorSAXException {
        Scanner scanner = new Scanner(name, true);
        try {
            block17: {
                int slashes = 0;
                do {
                    if (!Character.isJavaIdentifierStart(scanner.next())) {
                        if (!this.quiet) {
                            log.error("exports-id-syntax", "expected identifier: found %s%s", scanner.label(), this.atLine());
                        }
                        return name;
                    }
                    while (!scanner.done() && Character.isJavaIdentifierPart(scanner.next())) {
                    }
                    if (scanner.done()) break block17;
                    if (scanner.current() == '/') {
                        scanner.replace('/', '.');
                        if (++slashes == 1 && this.schemaValidating && !this.quiet) {
                            log.warning("exports-dot-slash", "expected identifier character, '.', or %s: found '/' and corrected to '.'%s", scanner.endLabel(), this.atLine());
                        }
                    }
                    if (scanner.current() != '<') continue;
                    scanner.reject('<');
                    int mark = scanner.index();
                    int depth = 1;
                    char c = scanner.next();
                    while (!scanner.done()) {
                        if (c == '>') {
                            --depth;
                        } else if (c == '<') {
                            ++depth;
                        }
                        scanner.reject(c);
                        c = scanner.next();
                    }
                    if (depth == 0) {
                        if (!this.quiet) {
                            log.warning("exports-id-syntax", "expected identifier character, '.', or %s: found and skipped \"%s\"%s", scanner.endLabel(), scanner.substring(mark), this.atLine());
                        }
                        return scanner.toString();
                    }
                    if (!this.quiet) {
                        log.error("exports-id-syntax", "expected identifier character, '.', or %s: found '<'%s", scanner.endLabel(), this.atLine());
                    }
                    return name;
                } while (scanner.current() == '.');
                if (!this.quiet) {
                    log.error("exports-id-syntax", "expected identifier character, '.', or %s: found %s%s", scanner.endLabel(), scanner.label(), this.atLine());
                }
                return name;
            }
            return scanner.toString();
        }
        catch (IllegalStateException e) {
            if (!this.quiet) {
                log.error("exports-id-syntax", "unexpected character at offset %d of \"%s\"%s", scanner.index(), name, this.atLine());
            }
            return name;
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (!this.quiet) {
            this.log.warning("exports-schema-validation-warning", "%s (%s:%d)", e.getMessage(), this.fileName(), e.getLineNumber());
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (!this.quiet) {
            this.log.error("exports-schema-validation-error", "%s (%s:%d)", e.getMessage(), this.fileName(), e.getLineNumber());
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected String at() {
        return " (" + this.fileName() + ", line " + this.line + ", column " + this.column + ')';
    }

    protected String atLine() {
        return " (" + this.fileName() + ":" + this.line + ')';
    }

    private String fileName() {
        return URLFileSystem.getPlatformPathName(this.fileUrl);
    }

    private CompatibilityAccess access(String value, CompatibilityAccess defaultValue, String attributeName) throws SAXException {
        if (value == null) {
            return defaultValue;
        }
        switch (value) {
            case "exported": {
                return CompatibilityAccess.EXPORTED;
            }
            case "restricted": {
                return CompatibilityAccess.RESTRICTED;
            }
            case "concealed": {
                return CompatibilityAccess.CONCEALED;
            }
        }
        throw new SAXException(attributeName + " attribute value \"" + value + "\" must be \"exported\", \"restricted\", or \"concealed\"" + this.at());
    }

    private CompatibilityAccess exportedAccess(String value, CompatibilityAccess defaultValue, String attributeName) throws SAXException {
        if (value == null) {
            return defaultValue;
        }
        switch (value) {
            case "exported": {
                return CompatibilityAccess.EXPORTED;
            }
            case "restricted": {
                return CompatibilityAccess.RESTRICTED;
            }
            case "concealed": {
                throw new SAXException(attributeName + " attribute value can only be \"exported\" or \"restricted\", not \"concealed\"" + this.at());
            }
        }
        throw new SAXException(attributeName + " attribute value \"" + value + "\" must be \"exported\" or \"restricted\"" + this.at());
    }

    private static class LocatorSAXException
    extends SAXException {
        public LocatorSAXException(String message, Object ... arguments) {
            super(arguments.length == 0 ? message : String.format(message, arguments));
        }

        public LocatorSAXException(Exception e, String message, Object ... arguments) {
            super(arguments.length == 0 ? message : String.format(message, arguments), e);
        }
    }
}

