/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import oracle.javatools.exports.message.Severity;

public class Merge<E> {
    private final E left;
    private final E right;
    private final String type;
    private final Object[] arguments;
    private boolean equals;
    private Severity severity;
    private E value;
    private List<Merge> nestedMerges = new ArrayList<Merge>();

    public Merge(E left, E right, String type, Object ... arguments) {
        this.left = left;
        this.right = right;
        this.type = type;
        this.arguments = arguments;
    }

    public Merge(E left, E right, Merge<?> merge, String type, Object ... arguments) {
        this.left = left;
        this.right = right;
        this.type = type;
        this.arguments = arguments;
        merge.addMerge(this);
    }

    public void addMerge(Merge<?> nestedMerge) {
        if (this.severity != null) {
            throw new IllegalStateException("merge already complete: " + this);
        }
        this.nestedMerges.add(nestedMerge);
    }

    public void addNestedMerges(Merge<?> merge) {
        if (this.severity != null) {
            throw new IllegalStateException("merge already complete: " + this);
        }
        for (Merge nestedMerge : merge.nestedMerges) {
            this.nestedMerges.add(nestedMerge);
        }
    }

    public boolean completeIfIdentical() {
        if (this.severity != null) {
            throw new IllegalStateException("merge already completed: " + this);
        }
        if (!this.nestedMerges.isEmpty()) {
            throw new IllegalStateException("nested merges created: " + this);
        }
        this.equals = this.left == this.right;
        if (this.equals) {
            this.complete(this.left, Severity.NOTE);
        }
        return this.equals;
    }

    public boolean completeIfEqual() {
        if (this.severity != null) {
            throw new IllegalStateException("merge already completed: " + this);
        }
        if (!this.nestedMerges.isEmpty()) {
            throw new IllegalStateException("nested merges created: " + this);
        }
        this.equals = Objects.equals(this.left, this.right);
        if (this.equals) {
            this.complete(this.left, Severity.NOTE);
        }
        return this.equals;
    }

    public boolean completeIfEqual(Function<E, ?> proxyFunction) {
        if (this.severity != null) {
            throw new IllegalStateException("merge already completed: " + this);
        }
        if (!this.nestedMerges.isEmpty()) {
            throw new IllegalStateException("nested merges created: " + this);
        }
        this.equals = Objects.equals(proxyFunction.apply(this.left), proxyFunction.apply(this.right));
        if (this.equals) {
            this.complete(this.left, Severity.NOTE);
        }
        return this.equals;
    }

    public void complete(E value) {
        this.complete(value, Severity.NOTE);
    }

    public void completeWarning(E value) {
        this.complete(value, Severity.WARNING);
    }

    public void completeError(E value) {
        this.complete(value, Severity.ERROR);
    }

    public void complete(E value, Severity severity) {
        if (this.severity != null) {
            throw new IllegalStateException("merge already completed: " + this);
        }
        if (severity == null) {
            throw new NullPointerException("severity == null");
        }
        this.value = value;
        for (Merge merge : this.nestedMerges) {
            if (merge.severity == null) {
                throw new IllegalStateException("nested merge not completed: " + merge);
            }
            severity = Severity.worstOf(merge.severity, severity);
        }
        this.severity = severity;
    }

    public boolean isCompleted() {
        return this.severity != null;
    }

    public String getType() {
        return this.arguments.length == 0 ? this.type : String.format(this.type, this.arguments);
    }

    public E getLeft() {
        return this.left;
    }

    public E getRight() {
        return this.right;
    }

    public E getValue() {
        return this.value;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public boolean isError() {
        return this.getSeverity() == Severity.ERROR;
    }

    public String toString() {
        return this.appendDescription(Severity.NOTE, false, 1, new StringBuilder(), "\n").toString();
    }

    public Object getDescription() {
        return this.getDescription(Severity.NOTE);
    }

    public Object getDescription(Severity severity) {
        return new Object(){

            public String toString() {
                return Merge.this.appendDescription(Severity.ERROR, false, 0, new StringBuilder(), "\n").toString();
            }
        };
    }

    public Object getNestedDescription() {
        return this.getNestedDescription(Severity.NOTE);
    }

    public Object getNestedDescription(final Severity severity) {
        return new Object(){

            public String toString() {
                return Merge.this.appendDescription(severity, true, 0, new StringBuilder(), "\n").toString();
            }
        };
    }

    public StringBuilder appendDescription(StringBuilder builder) {
        return this.appendDescription(Severity.NOTE, false, 0, builder, "\n");
    }

    public StringBuilder appendDescription(Severity severity, StringBuilder builder) {
        return this.appendDescription(severity, false, 0, builder, "\n");
    }

    private StringBuilder appendDescription(Severity severity, boolean nested, int depth, StringBuilder builder, String prefix) {
        builder.append(prefix);
        prefix = prefix + "  ";
        String description = String.format(this.type, this.arguments);
        if (severity == null) {
            builder.append("[pending] merging ").append(description).append(':');
            builder.append(prefix).append(this.left);
            builder.append(prefix).append(this.right);
        } else {
            switch (this.severity) {
                case ERROR: {
                    builder.append("[error] ");
                    break;
                }
                case WARNING: {
                    builder.append("[warning] ");
                }
            }
            if (nested) {
                builder.append("merged ").append(description);
            } else if (this.equals) {
                builder.append("trivially merged ").append(description).append(':');
                builder.append(prefix).append(this.left);
            } else if (this.left == this.value) {
                builder.append("selected left ").append(description).append(":");
                builder.append(prefix).append(this.left);
                builder.append(prefix).append(this.right);
            } else if (this.right == this.value) {
                builder.append("selected right ").append(description).append(':');
                builder.append(prefix).append(this.left);
                builder.append(prefix).append(this.right);
            } else {
                builder.append("merged ").append(description).append(':');
                builder.append(prefix).append(this.left);
                builder.append(prefix).append(this.right);
                builder.append(prefix).replace(builder.length() - 2, builder.length(), "->").append(this.value);
            }
        }
        if (--depth != 0 && this.severity.ordinal() <= severity.ordinal()) {
            prefix = prefix + "  ";
            for (Merge merge : this.nestedMerges) {
                Severity mergeSeverity = merge.getSeverity();
                if (severity != null && (mergeSeverity == null || mergeSeverity.ordinal() > severity.ordinal())) continue;
                builder.append('\n');
                merge.appendDescription(severity, false, depth, builder, prefix);
            }
        }
        return builder;
    }
}

