/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.command.ClassesSource;
import oracle.javatools.exports.command.Command;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandInput;
import oracle.javatools.exports.command.CommandOutput;
import oracle.javatools.exports.common.Iterables;
import oracle.javatools.exports.file.Paths;

public abstract class AbstractExportSignatureTest {
    private Path middlewareHome;
    private Matcher approvalsMatcher;

    protected Path getMiddlewareHome() throws URISyntaxException {
        if (this.middlewareHome != null) {
            return this.middlewareHome;
        }
        String override = System.getProperty("oracle.javatools.exports.middleware.home");
        if (override != null) {
            this.middlewareHome = Paths.get(override, new String[0]);
            return this.middlewareHome;
        }
        Class<URLFileSystem> WELL_KNOWN_CLASS = URLFileSystem.class;
        String JAR_RELATIVE_PATH = "oracle_common/modules/oracle.javatools/javatools-nodeps.jar";
        String DIR_RELATIVE_PATH = "built/javatools-nodeps/classes/";
        Path location = Paths.get(WELL_KNOWN_CLASS.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (location.endsWith("oracle_common/modules/oracle.javatools/javatools-nodeps.jar")) {
            this.middlewareHome = location.getParent().getParent().getParent().getParent();
            return this.middlewareHome;
        }
        if (location.endsWith("built/javatools-nodeps/classes/")) {
            this.middlewareHome = location.getParent().getParent().getParent();
            return this.middlewareHome;
        }
        throw new IllegalStateException("middleware home inference failed");
    }

    protected Path getWorkingDirectory() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    protected String getBaselineFileName() {
        return CommandInput.OutputType.BASELINE.getFileName();
    }

    protected InputStream getBaselineFileStream() {
        return this.getClass().getResourceAsStream(this.getBaselineFileName());
    }

    protected String getApprovalsDirectoryName() {
        return "approvals";
    }

    protected String getApprovalsFilePattern() {
        return ".*.lis";
    }

    protected Matcher getApprovalsFileMatcher() {
        if (this.approvalsMatcher == null) {
            this.approvalsMatcher = Pattern.compile(this.getApprovalsFilePattern()).matcher("");
        }
        return this.approvalsMatcher;
    }

    protected Iterable<InputStreamAndName> getApprovalsFileStreams() {
        return Iterables.mappedIterable(URLFileSystem.list(this.getClass().getResource(this.getApprovalsDirectoryName()), u -> this.getApprovalsFileMatcher().reset(URLFileSystem.getFileName(u)).matches()), u -> new InputStreamAndName(this.getClass(), this.getApprovalsDirectoryName(), URLFileSystem.getFileName(u)));
    }

    protected String getDomainFileName() {
        return "fmw";
    }

    protected InputStream getDomainFileStream() {
        return this.getClass().getResourceAsStream(this.getDomainFileName());
    }

    protected String getScopeFilesFileName() {
        return "scope-files.lis";
    }

    protected BufferedReader getScopeFilesFileReader() throws URISyntaxException, IOException {
        String override = System.getProperty("oracle.javatools.exports.scope.file");
        InputStream stream = override == null ? this.getClass().getResourceAsStream(this.getScopeFilesFileName()) : Files.newInputStream(Paths.get(override, new String[0]), new OpenOption[0]);
        return new ResolvingReader(this.getMiddlewareHome(), stream);
    }

    protected String getOutputDirectoryName() {
        return "output";
    }

    public void test(Domain domain) throws URISyntaxException, IOException, CommandException {
        List<String> errors;
        int errorCount;
        String message;
        Path workingDirectory = this.getWorkingDirectory();
        Path baselineFile = workingDirectory.resolve(this.getBaselineFileName());
        Path approvalsDirectory = workingDirectory.resolve(this.getApprovalsDirectoryName());
        Path domainFile = workingDirectory.resolve(this.getDomainFileName());
        Path scopeFile = workingDirectory.resolve(this.getScopeFilesFileName());
        Path outputDirectory = workingDirectory.resolve(this.getOutputDirectoryName());
        Path revisionPath = outputDirectory.resolve(this.getBaselineFileName());
        Path errorsPath = outputDirectory.resolve(CommandInput.OutputType.ERRORS.getFileName());
        Path middlewareHome = this.getMiddlewareHome();
        CommandOutput commandOutput = new CommandOutput(){};
        Files.copy(this.getBaselineFileStream(), baselineFile, StandardCopyOption.REPLACE_EXISTING);
        if (domain == Domain.FILE) {
            Files.copy(this.getDomainFileStream(), domainFile, StandardCopyOption.REPLACE_EXISTING);
        }
        int approvalsCount = 0;
        for (InputStreamAndName inputStreamAndName : this.getApprovalsFileStreams()) {
            if (approvalsCount == 0) {
                Files.createDirectories(approvalsDirectory, new FileAttribute[0]);
            }
            Files.copy(inputStreamAndName.inputStream, approvalsDirectory.resolve(inputStreamAndName.fileName), StandardCopyOption.REPLACE_EXISTING);
            ++approvalsCount;
        }
        BufferedReader scopeFilesFileReader = this.getScopeFilesFileReader();
        if (scopeFilesFileReader != null) {
            try (BufferedReader reader = scopeFilesFileReader;
                 BufferedWriter writer = Files.newBufferedWriter(scopeFile, new OpenOption[0]);){
                String line = reader.readLine();
                while (line != null) {
                    writer.write(line);
                    writer.newLine();
                    line = reader.readLine();
                }
            }
        }
        CommandInput inputProperties = new CommandInput(CommandInput.CommandType.CAPTURE);
        inputProperties.setLibraries(Collections.singletonList(ClassesSource.installation()));
        inputProperties.setCompareTo(baselineFile);
        if (approvalsCount > 0) {
            inputProperties.setApprovals(Collections.singletonList(approvalsDirectory));
        }
        inputProperties.setMiddlewareHome(middlewareHome);
        switch (domain) {
            case UNIVERSAL: {
                inputProperties.setDomain(CommandInput.UNIVERSAL_DOMAIN);
                break;
            }
            case FMW: {
                inputProperties.setDomain(CommandInput.FMW_DOMAIN);
                break;
            }
            case FILE: {
                inputProperties.setDomain(domainFile);
            }
        }
        inputProperties.setScope(Collections.singletonList(scopeFile));
        inputProperties.setOwner("all");
        inputProperties.setSource("CURRENT-VERSION");
        inputProperties.setDirectory(outputDirectory);
        inputProperties.setTraces(true);
        inputProperties.validate(commandOutput);
        Command.execute(inputProperties, commandOutput);
        System.out.flush();
        System.err.flush();
        if (!Files.exists(revisionPath, new LinkOption[0])) {
            message = String.format("revision baseline %s not found", revisionPath);
            commandOutput.error(message, new Object[0]);
            assert (false) : message;
        }
        if (!Files.exists(errorsPath, new LinkOption[0])) {
            message = "baseline errors file " + errorsPath + " expected but not found";
            commandOutput.error(message, new Object[0]);
            assert (Files.exists(errorsPath, new LinkOption[0])) : message;
        }
        if ((errorCount = (errors = Files.readAllLines(errorsPath)).size()) > 0) {
            commandOutput.error("%d error%s", errorCount, errorCount == 1 ? "" : "s");
            StringBuilder builder = new StringBuilder(errorCount * 200);
            builder.append(errorCount).append(" error").append(errorCount == 1 ? "" : "s").append(':');
            for (int i = 0; i < errorCount; ++i) {
                builder.append('\n').append(errors.get(i));
            }
            assert (errorCount == 0) : builder.toString();
        }
    }

    protected class ResolvingReader
    extends BufferedReader {
        private Path base;

        public ResolvingReader(Path base, InputStream stream) {
            super(new InputStreamReader(stream));
            this.base = base;
        }

        @Override
        public String readLine() throws IOException {
            String line;
            do {
                if ((line = super.readLine()) != null) continue;
                return null;
            } while ((line = line.trim()).isEmpty());
            try {
                return this.base.resolve(line).toString();
            }
            catch (Exception e) {
                return line;
            }
        }
    }

    protected static class InputStreamAndName {
        protected final InputStream inputStream;
        protected final String fileName;

        protected InputStreamAndName(InputStream inputStream, String fileName) {
            this.inputStream = inputStream;
            this.fileName = fileName;
        }

        protected InputStreamAndName(Class<?> resource, String subdirectory, String fileName) {
            this(resource.getResourceAsStream(subdirectory + '/' + fileName), fileName);
        }
    }

    protected static enum Domain {
        UNIVERSAL,
        FMW,
        FILE;

    }
}

