/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.report.IssueComparator;
import oracle.javatools.exports.report.IssueModel;
import oracle.javatools.exports.report.IssueProperty;
import oracle.javatools.exports.report.IssuesReport;
import oracle.javatools.exports.uses.DiscreteUsesHandler;

public class DiscreteUsesWriter {
    public static void writeCSV(IssuesReport uses, Path path, boolean printHeader, String delimiter, IssueProperty<?>[] properties, IssueProperty<?>[] propertiesExcludeIfEmpty) throws IOException {
        if (delimiter == null || delimiter.isEmpty()) {
            delimiter = ",";
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            IssueProperty<?> p0 = properties[0];
            if (printHeader) {
                for (IssueProperty<?> property : properties) {
                    if (property != p0) {
                        writer.write(delimiter);
                    }
                    writer.write(property.getName());
                }
                writer.newLine();
            }
            block10: for (IssueModel use : uses.getIssues(new IssueComparator(properties))) {
                for (IssueProperty<?> property : propertiesExcludeIfEmpty) {
                    if (property.toString(use).isEmpty()) continue block10;
                }
                for (IssueProperty<?> property : properties) {
                    if (property != p0) {
                        writer.write(delimiter);
                    }
                    writer.write(property.toString(use));
                }
                writer.newLine();
            }
        }
    }

    public static void writeSignatures(IssuesReport report, NameFormat format, Path path, String source) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            IssueProperty<ElementName> name = DiscreteUsesHandler.API;
            if (source != null && !source.isEmpty()) {
                writer.write("# SOURCE ");
                writer.write(source);
                writer.newLine();
            }
            for (IssueModel issue : report.getIssues()) {
                ElementName value = name.getValue(issue);
                if (value == null) continue;
                value.writeQualifiedName(writer, format);
                writer.newLine();
            }
        }
    }

    public static void writeDifferences(Collection<IssuesReport.Difference> differences, Path path, boolean printHeader, String delimiter, IssueProperty<?> ... properties) throws IOException {
        if (delimiter == null || delimiter.isEmpty()) {
            delimiter = ",";
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            IssueProperty<?> p0 = properties[0];
            if (printHeader) {
                for (IssueProperty<?> property : properties) {
                    if (property != p0) {
                        writer.write(delimiter);
                    }
                    writer.write(property.toString());
                }
                writer.newLine();
            }
            for (IssuesReport.Difference difference : differences) {
                IssueModel leftIssue = difference.getLeft();
                IssueModel rightIssue = difference.getRight();
                for (IssueProperty<?> property : properties) {
                    if (property != p0) {
                        writer.write(delimiter);
                    }
                    writer.write(property.toString(leftIssue, rightIssue));
                }
                writer.newLine();
            }
        }
    }
}

