/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugProbeDataInfo
implements DebugDataInfo {
    DebugProbe dp;
    DebugProbeClassInfo classInfo;
    DebugProbeValue dpv;
    Object owner;
    int stoppedCount;

    DebugProbeDataInfo(DebugProbe debugProbe, DebugProbeClassInfo debugProbeClassInfo, DebugProbeValue debugProbeValue, Object object) {
        this.dp = debugProbe;
        this.classInfo = debugProbeClassInfo;
        this.dpv = debugProbeValue;
        this.owner = object;
        this.stoppedCount = debugProbe.stoppedCount;
    }

    public DebugVirtualMachine getVM() {
        return this.dp;
    }

    public boolean hasExpired() {
        return this.dp.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Data has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getValue() {
        return this.dpv.getValue();
    }

    public String getHexValue() {
        try {
            String string = this.dpv.getValue();
            long l = Long.parseLong(string);
            return Long.toHexString(l);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean canModifyDataWithString() {
        return this.dpv.canModify();
    }

    public boolean modifyDataWithString(String string) {
        DebugProbeValue debugProbeValue;
        if (this.dpv.canModify() && (debugProbeValue = this.dp.modifyData(this, this.dpv.getType(), string)) != null) {
            this.dpv = debugProbeValue;
            return true;
        }
        return false;
    }

    public boolean canModifyDataWithData() {
        return this.canModifyDataWithString();
    }

    public boolean modifyDataWithData(DebugDataInfo debugDataInfo) {
        return this.modifyDataWithString(debugDataInfo.getValue());
    }

    public boolean canModifyDataWithNewObject() {
        return false;
    }

    public boolean modifyDataWithNewObject(DebugMethodInfo debugMethodInfo, String[] stringArray) {
        return false;
    }

    public int hashCode() {
        return this.classInfo.hashCode() + this.dpv.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DebugProbeDataInfo) {
            DebugProbeDataInfo debugProbeDataInfo = (DebugProbeDataInfo)object;
            return ModelUtil.areEqual((Object)this.dp, (Object)debugProbeDataInfo.dp) && ModelUtil.areEqual((Object)this.classInfo, (Object)debugProbeDataInfo.classInfo) && ModelUtil.areEqual((Object)this.dpv, (Object)debugProbeDataInfo.dpv);
        }
        return false;
    }
}

