/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.tsp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.tsp.MessageImprint;
import oracle.security.crypto.tsp.TSAPolicyID;
import oracle.security.crypto.tsp.TSPFormatException;
import oracle.security.crypto.tsp.TSPMessage;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class TSPTimeStampReq
extends TSPMessage {
    private final int version = 1;
    private MessageImprint messageImprint;
    private TSAPolicyID reqPolicy;
    private BigInteger nonce;
    private boolean certReq = false;
    private X509ExtensionSet extensions;
    private byte[] cache;

    public TSPTimeStampReq() {
        this(null, null, (BigInteger)null, false, null);
    }

    public TSPTimeStampReq(MessageImprint mi) {
        this(mi, null, (BigInteger)null, false, null);
    }

    public TSPTimeStampReq(MessageImprint mi, TSAPolicyID reqPolicy, byte[] nonce, boolean certReq, X509ExtensionSet extensions) {
        this.messageImprint = mi;
        this.reqPolicy = reqPolicy;
        if (nonce != null) {
            this.nonce = new BigInteger((byte[])nonce.clone());
        }
        this.certReq = certReq;
        this.extensions = extensions;
    }

    public TSPTimeStampReq(MessageImprint mi, TSAPolicyID reqPolicy, BigInteger nonce, boolean certReq, X509ExtensionSet extensions) {
        this.messageImprint = mi;
        this.reqPolicy = reqPolicy;
        if (nonce != null) {
            this.nonce = nonce;
        }
        this.certReq = certReq;
        this.extensions = extensions;
    }

    public TSPTimeStampReq(InputStream is) throws IOException {
        this.input(is);
    }

    public int getVersion() {
        return 1;
    }

    @Override
    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public void setMessageImprint(MessageImprint mi) {
        this.messageImprint = mi;
        this.update();
    }

    public TSAPolicyID getReqPolicy() {
        return this.reqPolicy;
    }

    public void setReqPolicy(TSAPolicyID id) {
        this.reqPolicy = id;
        this.update();
    }

    public byte[] getNonce() {
        return this.nonce.toByteArray();
    }

    public BigInteger getNonceAsBigInteger() {
        return this.nonce;
    }

    public void setNonce(BigInteger data) {
        this.nonce = data;
        this.update();
    }

    public void setNonce(byte[] data) {
        this.nonce = new BigInteger((byte[])data.clone());
        this.update();
    }

    public boolean getCertReq() {
        return this.certReq;
    }

    public void setCertReq(boolean b) {
        this.certReq = b;
        this.update();
    }

    public X509ExtensionSet getExtensions() {
        return this.extensions;
    }

    public void setExtensions(X509ExtensionSet ext) {
        this.extensions = ext;
        this.update();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TSPTimeStampReq tsq = (TSPTimeStampReq)o;
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)tsq));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("version = ");
        sb.append(1);
        sb.append(", ");
        sb.append("messageImprint = ");
        sb.append(this.messageImprint != null ? this.messageImprint.toString() : "null");
        sb.append(", ");
        sb.append("reqPolicy = ");
        sb.append(this.reqPolicy != null ? this.reqPolicy.toString() : "null");
        sb.append(", ");
        sb.append("nonce = ");
        sb.append(this.nonce != null ? Utils.toHexString((byte[])this.nonce.toByteArray()) : "null");
        sb.append(", ");
        sb.append("certReq = ");
        sb.append(this.certReq);
        sb.append(", ");
        sb.append("extensions = ");
        sb.append(this.extensions != null ? this.extensions.toString() : "null");
        return sb.toString();
    }

    @Override
    protected void parseMessage(byte[] data) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)new UnsyncByteArrayInputStream(data));
        int v = new ASN1Integer((InputStream)sis).intValue();
        if (v != 1) {
            throw new TSPFormatException("Unsupported version: " + v);
        }
        this.messageImprint = new MessageImprint((InputStream)sis);
        block6: while (sis.available() > 0) {
            int tag = sis.getCurrentTag();
            switch (tag) {
                case 6: {
                    this.reqPolicy = new TSAPolicyID((InputStream)sis);
                    continue block6;
                }
                case 2: {
                    this.nonce = new ASN1Integer((InputStream)sis).getValue();
                    continue block6;
                }
                case 1: {
                    this.certReq = new ASN1Boolean((InputStream)sis).getValue();
                    continue block6;
                }
                case 0: {
                    sis.setCurrentTag(16);
                    this.extensions = new X509ExtensionSet((InputStream)sis);
                    continue block6;
                }
            }
            throw new TSPFormatException("Unrecognized field.");
        }
        this.cache = (byte[])data.clone();
    }

    @Override
    protected byte[] getEncoded() throws IOException {
        if (this.cache != null) {
            return this.cache;
        }
        ASN1Sequence seq = new ASN1Sequence();
        seq.addElement((ASN1Object)new ASN1Integer(1L));
        if (this.messageImprint == null) {
            throw new TSPFormatException("messageImprint field not set");
        }
        seq.addElement((ASN1Object)this.messageImprint);
        if (this.reqPolicy != null) {
            seq.addElement((ASN1Object)this.reqPolicy);
        }
        if (this.nonce != null) {
            seq.addElement((ASN1Object)new ASN1Integer(this.nonce));
        }
        seq.addElement((ASN1Object)new ASN1Boolean(this.certReq));
        if (this.extensions != null) {
            ASN1Object o = ASN1Utils.addImplicitTag((ASN1Object)this.extensions, (int)0);
            seq.addElement(o);
        }
        this.cache = Utils.toBytes((Streamable)seq);
        return (byte[])this.cache.clone();
    }

    private void update() {
        this.cache = null;
    }
}

