/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.actions.OLAPObjectHelper;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.cube.model.CubeMeasureFolderContents;
import oracle.olap.cubexml.CubeDDLStatements;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.cubexml.MetadataXML;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.measurefolder.model.MeasureFolder;
import oracle.olap.measurefolder.model.MeasureID;

public class DropCubeAction
extends AbstractOLAPDDLAction {
    private static final String CUBE_TYPE = "CUBE";
    private static final String CUBE_MEASURE_FORMAT = "%s%s";
    private static final String CUBE_CALCULATED_MEASURE_TYPE = "CALCMEASURE";

    @Override
    protected Collection<String> getOLAPDDL(DBObject dBObject) {
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string)) {
            string = String.format("\"%s\"", string);
        }
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string2)) {
            string2 = String.format("\"%s\"", string2);
        }
        String string3 = String.format("DROP CUBE %s.%s", string, string2);
        arrayList.add(string3);
        return arrayList;
    }

    protected List<CubeDDLStatements> getCascadeMeasureFolderContentStatements() {
        ArrayList<CubeDDLStatements> arrayList = new ArrayList<CubeDDLStatements>();
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        List<CubeMeasureFolderContents> list = OLAPObjectHelper.getCubeMeasureFolderContents(string2, string, oracleDatabaseImpl);
        DDLGenerator dDLGenerator = oracleDatabaseImpl.getDDLGenerator();
        for (CubeMeasureFolderContents cubeMeasureFolderContents : list) {
            Object object2;
            String string3 = cubeMeasureFolderContents.getMeasureFolderName();
            String string4 = cubeMeasureFolderContents.getCubeOwner();
            String string5 = cubeMeasureFolderContents.getCubeName();
            String string6 = cubeMeasureFolderContents.getMeasureName();
            MeasureFolder measureFolder = OLAPObjectHelper.loadMeasureFolder(string4, string3, oracleDatabaseImpl);
            MeasureFolder measureFolder2 = (MeasureFolder)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)measureFolder);
            ResultSet resultSet = measureFolder.getMeasures();
            MeasureID measureID = null;
            for (Object object2 : resultSet) {
                if (!object2.getName().equalsIgnoreCase(string5 + "." + string6)) continue;
                measureID = object2;
                break;
            }
            if (measureID == null) continue;
            measureFolder2.removeMeasure(measureID);
            ResultSet resultSet2 = oracleDatabaseImpl.getDiffEngine().diff((Object)measureFolder, (Object)measureFolder2).getResult();
            DDL dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), (Difference)resultSet2);
            Collection collection = dDL.getStatements();
            object2 = new CubeDDLStatements((SystemObject)measureFolder, (SystemObject)measureFolder2, collection);
            arrayList.add((CubeDDLStatements)object2);
        }
        return arrayList;
    }

    @Override
    protected String getOLAPDDLStatements() throws Exception {
        DBObject dBObject = this.getDBObject();
        String string = "";
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(dBObject.getConnection());
        Schema schema = new Schema(dBObject.getSchemaName());
        Collection<String> collection = this.getOLAPDDL(dBObject);
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.getSchemaObjectWithDescription();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaUpdatedObjectWithDescription();
        if (abstractSchemaObjectWithDesc2 == null) {
            abstractSchemaObjectWithDesc2 = abstractSchemaObjectWithDesc;
        }
        if (collection != null && !collection.isEmpty()) {
            CubeDDLStatements cubeDDLStatements = new CubeDDLStatements((SystemObject)abstractSchemaObjectWithDesc, (SystemObject)abstractSchemaObjectWithDesc2, collection);
            List<CubeDDLStatements> list = this.getCascadeMeasureFolderContentStatements();
            list.add(cubeDDLStatements);
            MetadataContext metadataContext = new MetadataContext(this.getDBObject().getDatabase(), list);
            metadataContext.setSchema(schema);
            metadataContext.setDatabase(databaseImpl);
            MetadataXML metadataXML = new MetadataXML(metadataContext);
            metadataXML.parse();
            string = metadataXML.getSQLXML();
        }
        return string;
    }

    @Override
    protected void executeOLAPDDLStatements() throws Exception {
        DBObject dBObject = this.getDBObject();
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(dBObject.getConnection());
        Schema schema = new Schema(dBObject.getSchemaName());
        Collection<String> collection = this.getOLAPDDL(dBObject);
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = this.getSchemaObjectWithDescription();
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc2 = this.getSchemaUpdatedObjectWithDescription();
        if (abstractSchemaObjectWithDesc2 == null) {
            abstractSchemaObjectWithDesc2 = abstractSchemaObjectWithDesc;
        }
        if (collection != null && !collection.isEmpty()) {
            CubeDDLStatements cubeDDLStatements = new CubeDDLStatements((SystemObject)abstractSchemaObjectWithDesc, (SystemObject)abstractSchemaObjectWithDesc2, collection);
            List<CubeDDLStatements> list = this.getCascadeMeasureFolderContentStatements();
            list.add(cubeDDLStatements);
            MetadataContext metadataContext = new MetadataContext(this.getDBObject().getDatabase(), list);
            metadataContext.setSchema(schema);
            metadataContext.setDatabase(databaseImpl);
            MetadataXML metadataXML = new MetadataXML(metadataContext);
            metadataXML.parse();
            metadataXML.executeSQL();
            Database database = dBObject.getDatabase();
            if (database instanceof AbstractDatabase) {
                AbstractDatabase abstractDatabase = (AbstractDatabase)database;
                SystemObject[] systemObjectArray = new SystemObject[]{abstractSchemaObjectWithDesc};
                SystemObject[] systemObjectArray2 = new SystemObject[]{abstractSchemaObjectWithDesc2};
                Difference difference = abstractDatabase.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
            }
        }
    }

    @Override
    protected String getConfirmMessage(String string) {
        String string2 = OLAPArb.format("CUBE_DROP_CONFIRMATION_MSG", string);
        return string2;
    }

    @Override
    protected String getConfirmTitle(String string) {
        String string2 = OLAPArb.format("CUBE_DROP_DLG_TITLE", string);
        return string2;
    }

    @Override
    protected String getProgressMessage(String string) {
        String string2 = OLAPArb.format("CUBE_DROP_PROGRESS_TITLE", string);
        return string2;
    }

    @Override
    protected String getSuccessMessage(String string) {
        String string2 = OLAPArb.format("CUBE_DROP_SUCCESS_MSG", string);
        return string2;
    }
}

