/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.model;

import java.util.Set;
import oracle.olap.app.cubeddl.model.AttributeColLevel;
import oracle.olap.app.cubeddl.model.CubeDimensionCreate;

public class CubeDimColumn {
    private CubeDimensionCreate cubeDim;
    private String name;
    private String dataType;
    private boolean level;
    private boolean attributeAtLevel;
    private String attributeLevelName;
    private boolean dimKey;
    private boolean parent;
    private boolean endDate;
    private boolean timeSpan;
    private Set<AttributeColLevel> attributeColLevels;

    public CubeDimColumn(CubeDimensionCreate cubeDimensionCreate, String string, String string2) {
        this.cubeDim = cubeDimensionCreate;
        this.name = string.toUpperCase();
        this.dataType = string2;
    }

    public void setName(String string) {
        this.name = string.toUpperCase();
    }

    public String getName() {
        return this.name.toUpperCase();
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public String getDataType() {
        String string;
        String string2 = string = this.dataType == null ? "VARCHAR2(100)" : this.dataType;
        if (this.isEndDate()) {
            string = "DATE";
        }
        if (this.isTimeSpan()) {
            string = "NUMBER";
        }
        return string;
    }

    public void setLevel(boolean bl) {
        this.level = bl;
    }

    public boolean isLevel() {
        return this.level;
    }

    public void setAttributeAtLevel(boolean bl) {
        this.attributeAtLevel = bl;
    }

    public boolean isAttributeAtLevel() {
        return this.attributeAtLevel;
    }

    public void setAttributeLevelName(String string) {
        this.attributeLevelName = string;
    }

    public String getAttributeLevelName() {
        return this.attributeLevelName;
    }

    public boolean isAttributeVisibleAtLevel(String string) {
        if (this.attributeAtLevel && this.attributeLevelName.toUpperCase().equals(string.toUpperCase())) {
            return true;
        }
        if (this.attributeColLevels != null) {
            for (AttributeColLevel attributeColLevel : this.attributeColLevels) {
                for (CubeDimColumn cubeDimColumn : this.cubeDim.getAttributes()) {
                    if (!cubeDimColumn.attributeAtLevel || !cubeDimColumn.attributeLevelName.toUpperCase().equals(string.toUpperCase())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setDimKey(boolean bl) {
        this.dimKey = bl;
    }

    public boolean isDimKey() {
        return this.dimKey;
    }

    public void setParent(boolean bl) {
        this.parent = bl;
    }

    public boolean isParent() {
        return this.parent;
    }

    public void setEndDate(boolean bl) {
        this.endDate = bl;
    }

    public boolean isEndDate() {
        return this.endDate;
    }

    public void setTimeSpan(boolean bl) {
        this.timeSpan = bl;
    }

    public boolean isTimeSpan() {
        return this.timeSpan;
    }

    public void setAttributeColLevels(Set<AttributeColLevel> set) {
        this.attributeColLevels = set;
    }

    public Set<AttributeColLevel> getAttributeColLevels() {
        return this.attributeColLevels;
    }

    public AttributeColLevel getAttributeVisibleForLevel(String string) {
        return null;
    }

    public boolean equals(Object object) {
        Object object2;
        if (object instanceof CubeDimColumn) {
            object2 = (CubeDimColumn)object;
            if (((CubeDimColumn)object2).name != null && ((CubeDimColumn)object2).name.equals(this.name)) {
                return true;
            }
        }
        return object instanceof String && (object2 = (String)object) != null && ((String)object2).equals(this.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : super.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name.toLowerCase());
        if (!this.endDate && !this.timeSpan) {
            stringBuffer.append(" " + this.getDataType());
        }
        if (this.dimKey) {
            stringBuffer.append(" DIMENSION KEY");
        }
        if (this.parent) {
            stringBuffer.append(" PARENT");
        }
        if (this.attributeColLevels != null && this.attributeColLevels.size() > 0) {
            if (this.endDate) {
                stringBuffer.append(" END DATE");
            }
            if (this.timeSpan) {
                stringBuffer.append(" TIME SPAN");
            }
            stringBuffer.append(" GROUP (\n");
            for (AttributeColLevel attributeColLevel : this.attributeColLevels) {
                stringBuffer.append("    " + attributeColLevel.getColumn() + ",\n");
            }
            if (stringBuffer.toString().endsWith(",\n")) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

