/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.cubeddl.model;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.olap.app.cubeddl.model.AWSpecification;
import oracle.olap.app.cubeddl.model.AttributeColLevel;
import oracle.olap.app.cubeddl.model.CubeDimColumn;
import oracle.olap.app.cubeddl.model.Hierarchy;
import oracle.olap.app.cubeddl.model.MapDefinition;
import oracle.olap.app.cubeddl.model.SelectQuery;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;

public class CubeDimensionCreate
extends NamedObjectWithDesc
implements MapDefinition {
    private Set<CubeDimColumn> columns = new LinkedHashSet<CubeDimColumn>();
    private List<String> mapColumns;
    private SelectQuery selectQuery;
    private Set<Hierarchy> hierarchies = new LinkedHashSet<Hierarchy>();
    private boolean time;
    private AWSpecification awSpec;

    public CubeDimensionCreate(String string) {
        super(string, null);
    }

    public CubeDimensionCreate() {
        this(null);
    }

    public CubeDimColumn addColumn(String string, String string2) {
        CubeDimColumn cubeDimColumn = new CubeDimColumn(this, string, string2);
        this.columns.add(cubeDimColumn);
        return cubeDimColumn;
    }

    public void addColumn(CubeDimColumn cubeDimColumn) {
        this.columns.add(cubeDimColumn);
    }

    public void addHierarchy(Hierarchy hierarchy) {
        this.hierarchies.add(hierarchy);
    }

    public Set<Hierarchy> getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public SelectQuery getSelectQuery() {
        return this.selectQuery;
    }

    @Override
    public void setSelectQuery(SelectQuery selectQuery) {
        this.selectQuery = selectQuery;
    }

    @Override
    public List<String> getMapColumns() {
        return this.mapColumns;
    }

    @Override
    public void setMapColumns(List<String> list) {
        this.mapColumns = list;
    }

    public void setAWSpecification(AWSpecification aWSpecification) {
        this.awSpec = aWSpecification;
    }

    public AWSpecification getAWSpecification() {
        return this.awSpec;
    }

    public Hierarchy getHierarchy(String string) {
        for (Hierarchy hierarchy : this.getHierarchies()) {
            if (!hierarchy.getName().equals(string)) continue;
            return hierarchy;
        }
        return null;
    }

    public Set<CubeDimColumn> getAttributes() {
        HashSet<CubeDimColumn> hashSet = new HashSet<CubeDimColumn>();
        HashSet<CubeDimColumn> hashSet2 = new HashSet<CubeDimColumn>();
        for (Hierarchy object : this.hierarchies) {
            block1: for (String string : object.getLevels()) {
                for (CubeDimColumn cubeDimColumn : this.columns) {
                    if (!cubeDimColumn.equals(string)) continue;
                    hashSet.add(cubeDimColumn);
                    continue block1;
                }
            }
        }
        for (CubeDimColumn cubeDimColumn : this.columns) {
            if (hashSet.contains(cubeDimColumn) || cubeDimColumn.isDimKey() || cubeDimColumn.isParent()) continue;
            hashSet2.add(cubeDimColumn);
        }
        return hashSet2;
    }

    public CubeDimColumn getDimensionKey() {
        for (CubeDimColumn cubeDimColumn : this.columns) {
            if (!cubeDimColumn.isDimKey()) continue;
            return cubeDimColumn;
        }
        return null;
    }

    public CubeDimColumn getParent() {
        for (CubeDimColumn cubeDimColumn : this.columns) {
            if (!cubeDimColumn.isParent()) continue;
            return cubeDimColumn;
        }
        return null;
    }

    public boolean isFlat() {
        return this.hierarchies.size() == 0;
    }

    public boolean isValueHierarchy() {
        for (Hierarchy hierarchy : this.hierarchies) {
            if (hierarchy.getLevels().size() != 0) continue;
            return true;
        }
        return false;
    }

    public void setTime(boolean bl) {
        this.time = bl;
    }

    public boolean isTime() {
        return this.time;
    }

    public boolean isAttributeVisibleForLevel(CubeDimColumn cubeDimColumn, String string) {
        return cubeDimColumn.isAttributeVisibleAtLevel(string);
    }

    public AttributeColLevel getAttributeVisibleForLevel(CubeDimColumn cubeDimColumn, String string) {
        return cubeDimColumn.getAttributeVisibleForLevel(string);
    }

    public CubeDimColumn getEndDateAttribute() {
        for (CubeDimColumn cubeDimColumn : this.getAttributes()) {
            if (!cubeDimColumn.isEndDate()) continue;
            return cubeDimColumn;
        }
        return null;
    }

    public CubeDimColumn getTimeSpanAttribute() {
        for (CubeDimColumn cubeDimColumn : this.getAttributes()) {
            if (!cubeDimColumn.isTimeSpan()) continue;
            return cubeDimColumn;
        }
        return null;
    }

    public boolean isMapped() {
        return this.selectQuery != null;
    }

    public String getLevelMap(String string) {
        int n = 0;
        boolean bl = false;
        if (this.mapColumns == null) {
            return null;
        }
        for (String string2 : this.mapColumns) {
            if (string2.equalsIgnoreCase(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl && this.selectQuery != null && this.selectQuery.getColumns().size() > n) {
            String string3 = this.selectQuery.getColumns().get(n);
            return this.getFrom() + "." + (String)string3;
        }
        return null;
    }

    public String getAttributeMap(CubeDimColumn cubeDimColumn, String string) {
        if (cubeDimColumn.getAttributeColLevels() != null) {
            for (AttributeColLevel attributeColLevel : cubeDimColumn.getAttributeColLevels()) {
                for (CubeDimColumn cubeDimColumn2 : this.columns) {
                    if (!cubeDimColumn2.getName().equalsIgnoreCase(attributeColLevel.getColumn()) || !cubeDimColumn2.isAttributeAtLevel() || !cubeDimColumn2.getAttributeLevelName().equalsIgnoreCase(string)) continue;
                    return this.getLevelMap(cubeDimColumn2.getName());
                }
            }
        }
        return this.getLevelMap(cubeDimColumn.getName());
    }

    public String getFrom() {
        if (this.selectQuery != null) {
            return this.selectQuery.getFrom();
        }
        return "";
    }

    public String getShadowTableName() {
        return this.getName() + "$";
    }

    public String dropShadowTable() {
        StringBuffer stringBuffer = new StringBuffer("DROP TABLE " + this.getShadowTableName());
        return stringBuffer.toString();
    }

    public String createShadowTable() {
        StringBuffer stringBuffer = new StringBuffer("CREATE TABLE " + this.getShadowTableName() + " (\n");
        for (CubeDimColumn object : this.columns) {
            stringBuffer.append("  " + object.getName() + " " + object.getDataType() + ",\n");
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        if (this.getHierarchies().size() == 1) {
            for (Hierarchy hierarchy : this.getHierarchies()) {
                if (hierarchy.getLevels().size() <= 0) continue;
                stringBuffer.append(", PRIMARY KEY (");
                for (String string : hierarchy.getLevels()) {
                    stringBuffer.append(string + ",");
                }
                if (stringBuffer.toString().endsWith(",")) {
                    stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                }
                stringBuffer.append(")");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String drop() {
        return "DROP CUBE DIMENSION " + this.getName().toLowerCase();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CREATE CUBE DIMENSION " + this.getName().toLowerCase());
        if (this.time) {
            stringBuffer.append(" TIME");
        }
        stringBuffer.append(" (\n");
        for (CubeDimColumn object : this.columns) {
            stringBuffer.append("  " + object.toString() + ",\n");
        }
        for (Hierarchy hierarchy : this.hierarchies) {
            stringBuffer.append("  " + hierarchy.toString() + ",\n");
        }
        if (stringBuffer.toString().endsWith(",\n")) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        stringBuffer.append(");\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        CubeDimensionCreate cubeDimensionCreate = new CubeDimensionCreate("geog");
        cubeDimensionCreate.addColumn("year", "NUMBER");
        cubeDimensionCreate.addColumn("quarter", "VARCHAR2(20)");
        cubeDimensionCreate.addColumn("month", "VARCHAR2(20)");
        Hierarchy hierarchy = new Hierarchy("Standard");
        hierarchy.addLevel("year");
        hierarchy.addLevel("quarter");
        hierarchy.addLevel("month");
        cubeDimensionCreate.addHierarchy(hierarchy);
        System.out.println(cubeDimensionCreate.toString());
    }
}

