/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import oracle.olap.app.syntaxparser.ChildlessNode;
import oracle.olap.app.syntaxparser.ChoiceNode;
import oracle.olap.app.syntaxparser.ChoicePlaceHolderNode;
import oracle.olap.app.syntaxparser.FlatNode;
import oracle.olap.app.syntaxparser.LoopNode;
import oracle.olap.app.syntaxparser.LoopPlaceHolderNode;
import oracle.olap.app.syntaxparser.NestedParamProcessor;
import oracle.olap.app.syntaxparser.NodeProcessor;
import oracle.olap.app.syntaxparser.ParseNode;

public class NodeFlattener
implements NodeProcessor {
    private static final Logger LOG = Logger.getLogger(NodeFlattener.class.getName());
    protected FlatNode flatList;
    protected FlatNode prev;
    protected Map<String, ParseNode> paramPatterns;
    protected String currentParamName;
    protected NodeProcessor nestedProcessor;

    NodeFlattener() {
    }

    NodeFlattener(String string) {
        this.currentParamName = string;
    }

    @Override
    public FlatNode getFlatList() {
        return this.flatList;
    }

    @Override
    public void finish() {
    }

    public void setParamPatterns(Map<String, ParseNode> map) {
        this.paramPatterns = map;
    }

    protected Handle handleNode(ParseNode parseNode, String string, Handle handle) {
        if (handle == null) {
            handle = new Handle();
        }
        handle.replacement = parseNode;
        ParseNode parseNode2 = this.paramPatterns.get(string);
        if (parseNode2 != null) {
            if (parseNode2.getPatternType() != ParseNode.PatternType.CHOICE && parseNode2.getPatternType() != ParseNode.PatternType.LOOP) {
                parseNode.setCheckName(parseNode2.isCheckName());
            }
            if (parseNode2.getParamNames().isEmpty()) {
                LOG.warning(String.format("Param Pattern name for key [%s] is null, setting to key value", string));
                parseNode2.addParamName(string);
            }
        }
        if (parseNode2 != null && parseNode2.getPatternType() == ParseNode.PatternType.LOOP) {
            LoopNode loopNode = new LoopNode(parseNode, string);
            handle.flatNode = loopNode;
            this.nestedProcessor = new NestedParamProcessor(new NodeFlattener(string), new LoopPlaceHolderNode(loopNode), this.paramPatterns);
        } else if (parseNode2 != null && parseNode2.getPatternType() == ParseNode.PatternType.CHOICE) {
            ChoiceNode choiceNode = new ChoiceNode(parseNode, parseNode2);
            handle.flatNode = choiceNode;
            this.nestedProcessor = new NestedParamProcessor(new NodeFlattener(string), new ChoicePlaceHolderNode(choiceNode, parseNode2.getOffset()), this.paramPatterns);
        } else if (parseNode2 != null && parseNode2.getPatternType() == ParseNode.PatternType.SKIP_CHILDREN) {
            handle.flatNode = new ChildlessNode(parseNode, string);
            handle.replacement = null;
        } else {
            handle.flatNode = new FlatNode(parseNode, string);
        }
        return handle;
    }

    @Override
    public ParseNode processNode(ParseNode parseNode) {
        Iterator<String> iterator = parseNode.getParamNames().iterator();
        if (iterator.hasNext()) {
            return this.processNode(parseNode, iterator, iterator.next());
        }
        return this.processNode(parseNode, iterator, null);
    }

    protected ParseNode processNested(ParseNode parseNode) {
        ParseNode parseNode2 = parseNode;
        if (this.nestedProcessor != null) {
            parseNode2 = this.nestedProcessor.processNode(parseNode);
        }
        return parseNode2;
    }

    public ParseNode processNode(ParseNode parseNode, Iterator<String> iterator, String string) {
        Handle handle = new Handle();
        handle.replacement = this.processNested(parseNode);
        if (this.nestedProcessor != null && this.nestedProcessor.abort()) {
            this.nestedProcessor = null;
            this.processHandle(handle);
        }
        if (this.nestedProcessor == null) {
            handle = null;
            do {
                handle = this.handleNode(parseNode, string, handle);
                if (this.nestedProcessor == null) continue;
                this.processHandle(handle);
                return this.processNode(parseNode, iterator, string);
            } while ((string = iterator.hasNext() ? iterator.next() : null) != null);
            this.processHandle(handle);
        }
        return handle.replacement;
    }

    protected void processHandle(Handle handle) {
        if (handle == null) {
            return;
        }
        if (this.prev != null && handle.flatNode != null) {
            handle.flatNode = this.prev.linkNext(handle.flatNode);
        }
        if (this.flatList == null) {
            this.flatList = handle.flatNode;
        }
        if (handle.flatNode != null) {
            this.prev = handle.flatNode;
        }
    }

    @Override
    public boolean abort() {
        return false;
    }

    protected static class Handle {
        FlatNode flatNode;
        ParseNode replacement;

        protected Handle() {
        }
    }
}

