/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.syntaxparser;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ParseNode
extends DefaultMutableTreeNode {
    protected String type;
    protected PatternType patternType;
    protected boolean checkName;
    protected String fullValue;
    protected LinkedList<String> paramNames;
    protected int offset;
    protected int end;
    protected int replaceEnd;
    protected int replaceOffset;

    public ParseNode() {
        this(null, null, false, 0, 0);
    }

    public ParseNode(String string, String string2) {
        this(string, string2, false);
    }

    public ParseNode(String string, String string2, boolean bl) {
        this(string, string2, bl, -1, -1);
    }

    public ParseNode(String string, String string2, boolean bl, int n, int n2) {
        this(string, string2, bl, n, n2, PatternType.NONE);
    }

    public ParseNode(String string, String string2, int n, int n2) {
        this(string, string2, true, n, n2);
    }

    public ParseNode(String string, String string2, PatternType patternType) {
        this(null, string2, false, -1, -1, patternType);
        this.addParamName(string);
    }

    private ParseNode(String string, String string2, boolean bl, int n, int n2, PatternType patternType) {
        super(string);
        this.fullValue = string;
        this.type = string2;
        this.checkName = bl;
        this.offset = n;
        this.end = n2;
        this.replaceEnd = n2;
        this.replaceOffset = n;
        this.patternType = patternType;
    }

    public String getType() {
        return this.type;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void setReplaceEnd(int n, String string) {
        this.setReplaceBounds(this.replaceOffset, n, string);
    }

    public void setReplaceBounds(int n, int n2, String string) {
        this.replaceEnd = n2;
        this.replaceOffset = n;
        this.fullValue = (this.replaceEnd != this.end || this.replaceOffset != this.offset) && this.replaceEnd >= 0 && this.replaceEnd <= string.length() && this.replaceOffset >= 0 && this.replaceOffset < string.length() && this.replaceEnd > this.replaceOffset ? string.substring(this.replaceOffset, this.replaceEnd) : (String)this.userObject;
    }

    public int getReplaceOffset() {
        return this.replaceOffset;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public void addParamName(String string) {
        if (this.paramNames == null) {
            this.paramNames = new LinkedList();
        }
        if (!this.paramNames.contains(string)) {
            this.paramNames.addLast(string);
        }
    }

    public List<String> getParamNames() {
        if (this.paramNames == null) {
            return Collections.emptyList();
        }
        return this.paramNames;
    }

    public boolean isCheckName() {
        return this.checkName;
    }

    public void setCheckName(boolean bl) {
        this.checkName = bl;
    }

    public String getParamName() {
        if (this.paramNames == null) {
            return null;
        }
        if (this.paramNames.size() == 1) {
            return this.paramNames.getFirst();
        }
        return this.paramNames.toString();
    }

    public PatternType getPatternType() {
        return this.patternType;
    }

    public void setPatternType(PatternType patternType) {
        this.patternType = patternType;
    }

    public String getFullValue() {
        return this.fullValue;
    }

    public String getValue() {
        return this.userObject == null ? null : this.userObject.toString();
    }

    public List<TreeNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public static enum PatternType {
        CHOICE,
        OPTION,
        LOOP,
        NONE,
        MARK,
        SKIP_CHILDREN;

    }
}

