/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.table;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TablePacker {
    public static final int VISIBLE_ROWS = 0;
    public static final int ALL_ROWS = 1;
    public static final int NO_ROWS = 2;
    private int rowsIncluded = 0;
    private boolean distributeExtraArea = true;

    public TablePacker() {
    }

    public TablePacker(int n, boolean bl) {
        this.rowsIncluded = n;
        this.distributeExtraArea = bl;
    }

    private int preferredWidth(JTable jTable, int n) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        int n2 = (int)jTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(jTable, tableColumn.getIdentifier(), false, false, -1, n).getPreferredSize().getWidth();
        if (jTable.getRowCount() != 0) {
            int n3 = 0;
            int n4 = 0;
            if (this.rowsIncluded == 0) {
                Rectangle rectangle = jTable.getVisibleRect();
                n3 = jTable.rowAtPoint(rectangle.getLocation());
                n4 = jTable.rowAtPoint(new Point((int)rectangle.getMaxX(), (int)rectangle.getMaxY())) + 1;
            } else if (this.rowsIncluded == 1) {
                n3 = 0;
                n4 = jTable.getRowCount();
            }
            for (int i = n3; i < n4; ++i) {
                int n5 = (int)jTable.getCellRenderer(i, n).getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n).getPreferredSize().getWidth();
                n2 = Math.max(n2, n5);
            }
        }
        return n2 + jTable.getIntercellSpacing().width;
    }

    public void pack(JTable jTable) {
        int n;
        int n2;
        if (!jTable.isShowing()) {
            throw new IllegalStateException("table must be showing to pack");
        }
        if (jTable.getColumnCount() == 0) {
            return;
        }
        int[] nArray = new int[jTable.getColumnCount()];
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = this.preferredWidth(jTable, n2);
            n3 += nArray[n2];
        }
        n2 = jTable.getVisibleRect().width - n3;
        if (n2 > 0) {
            if (this.distributeExtraArea) {
                int n4 = n2 / jTable.getColumnCount();
                n = 0;
                while (n < nArray.length) {
                    int n5 = n++;
                    nArray[n5] = nArray[n5] + n4;
                }
                n2 -= n4 * jTable.getColumnCount();
            }
            int n6 = nArray.length - 1;
            nArray[n6] = nArray[n6] + n2;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (n = 0; n < nArray.length; ++n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            jTable.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(nArray[n]);
        }
    }
}

