/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.FlowLayout;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JPanel;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamBuildCommand
extends TemplateHyperParam {
    private static final ParseNode pattern = new ParseNode("buildcommand", Type.BUILDPROCESS.toString(), ParseNode.PatternType.SKIP_CHILDREN);
    private JPanel gui = new JPanel(new FlowLayout(0, 0, 0));
    private String value = "BUILD(\n LOAD \n)\n";
    private static final String DEFAULT_VALUE = "BUILD(\n LOAD \n)\n";
    private static final String WRAP = "BUILD(\n %s \n)\n";

    @Override
    public Component getComponent() {
        return this.gui;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setValue(Object object) {
        if (object != null) {
            if (object instanceof ParseNode) {
                ParseNode parseNode = (ParseNode)object;
                if (Type.valueFrom(parseNode.getType()) != Type.BUILDPROCESS) return false;
                this.value = parseNode.getFullValue();
                return true;
            } else {
                this.value = String.format(WRAP, object);
            }
            return true;
        } else {
            this.value = DEFAULT_VALUE;
        }
        return true;
    }

    @Override
    public String getExpression() {
        return this.value;
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void setValueMap(Map<String, String> map) throws SQLException, IOException {
    }

    @Override
    public int getPixelSize(int n) {
        return 0;
    }

    static {
        pattern.setUserObject("BUILD");
        pattern.setCheckName(true);
    }
}

