/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class TemplateHyperParamDimension
extends TemplateHyperParamCombo {
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamDimension.class.getName());
    private static final String RESERVED_WORD_TIME = "TIME";
    private static final String DEFAULT_NAME = "dimension";
    private static final ParseNode pattern = new ParseNode("dimension", Type.DIMENSION.toString(), ParseNode.PatternType.NONE);

    public TemplateHyperParamDimension() {
        this.setName(DEFAULT_NAME);
        final ListCellRenderer listCellRenderer = this.hyperCombo.getRenderer();
        this.hyperCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object != null && object instanceof Dimension) {
                    Dimension dimension = (Dimension)object;
                    object = dimension.getName();
                }
                return listCellRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
    }

    @Override
    public String getErrorMessage() {
        return OLAPArb.getString("EXPRESSION_EDITOR_ERROR_NO_DIMENSION");
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void init() {
        String string;
        this.addDimensions(this.getTemplateContext().getDimensions());
        if (this.getComboBoxModel().getSize() > 0) {
            this.setSelectedElement(this.getComboBoxModel().getElementAt(0));
        }
        if (this.getParam() != null && (string = this.getParam().getInitialDefault()) != null) {
            this.setValue(string.toUpperCase());
        }
    }

    public void addDimensions(List<Dimension> list) {
        this.removeAllElements();
        for (Dimension dimension : list) {
            int n = 0;
            boolean bl = false;
            for (DimensionHierarchy dimensionHierarchy : dimension.getHierarchies()) {
                if (dimensionHierarchy.getHierarchyLevels().size() <= 0) continue;
                this.addElement(dimension);
                bl = true;
                if (!this.isReadonly()) break;
                return;
            }
            if (!bl) {
                this.getComboBoxModel().insertElementAt(dimension, n);
            }
            ++n;
        }
    }

    private boolean isReadonly() {
        return this.getParam() != null && this.getParam().getContext() != null && this.getParam().getContext().equals("readonly");
    }

    @Override
    public String getExpression() {
        Dimension dimension = (Dimension)this.getSelectedElement();
        String string = dimension.getName();
        if (string.equalsIgnoreCase(RESERVED_WORD_TIME)) {
            string = String.format("\"%s\"", string);
        }
        return string;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        if ("VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof DimensionHierarchy) {
            Dimension dimension;
            String string = null;
            Dimension dimension2 = ((DimensionHierarchy)propertyChangeEvent.getNewValue()).getDimension();
            if (!dimension2.equals(dimension = (Dimension)this.getValue())) {
                if (dimension != null) {
                    string = dimension.getName();
                }
                LOG.finest(String.format("updating dimension [new,old,source] [%s,%s,%s]", dimension2.getName(), string, propertyChangeEvent.getSource()));
                this.setSelectedElement(dimension2);
            }
        } else if ("VALID_PROPERTY".equals(propertyChangeEvent.getPropertyName()) && !(bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue())) {
            this.removeElement(this.getSelectedElement());
            if (this.getComboBoxModel().getSize() > 0) {
                this.setSelectedElement(this.getComboBoxModel().getElementAt(0));
            }
        }
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof ParseNode) {
            Dimension dimension;
            ParseNode parseNode = (ParseNode)object;
            String string = this.stripSchema(parseNode.getValue(), this.getTemplateContext().getSchema().getName());
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            if ((dimension = (Dimension)this.getSelectedElement()).getName().equals(string)) {
                return false;
            }
            Dimension dimension2 = null;
            for (Dimension dimension3 : this.getTemplateContext().getCubeDimensions()) {
                if (!dimension3.getName().equals(string)) continue;
                dimension2 = dimension3;
                break;
            }
            if (this.isReadonly()) {
                this.removeAllElements();
                this.addElement(dimension2);
                object = dimension2;
            } else {
                object = dimension2;
            }
        }
        return super.setValue(object);
    }
}

