/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.view;

import java.awt.Dimension;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.templates.templateview.TemplateHyperContext;
import oracle.olap.app.templates.templateview.TemplateHyperParamFinder;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.syntaxbuilder.qdr.QDRPanel;

public class TemplateHyperContextImpl
implements TemplateHyperContext {
    private TemplateHyperParamFinder finder;
    private Connection conn;
    private FetchIcon fetchIcon;
    private Resources resources;
    private TemplateHyperContext.ResizeMode resizeMode;

    public TemplateHyperContextImpl(Connection connection, Resources resources, FetchIcon fetchIcon, TemplateHyperContext.ResizeMode resizeMode) {
        this.conn = connection;
        this.fetchIcon = fetchIcon;
        this.resources = resources;
        this.resizeMode = resizeMode;
    }

    public TemplateHyperContextImpl(Connection connection, Resources resources, FetchIcon fetchIcon) {
        this(connection, resources, fetchIcon, TemplateHyperContext.ResizeMode.LEGACY);
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public FetchIcon getFetchIcon() {
        return this.fetchIcon;
    }

    @Override
    public TemplateHyperParamFinder getTemplateHyperParamFinder() {
        return this.finder;
    }

    @Override
    public void setTemplateHyperParamFinder(TemplateHyperParamFinder templateHyperParamFinder) {
        this.finder = templateHyperParamFinder;
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public List<QDRData> showQDRSelector(List<QDRData> list, String string, String string2) {
        Vector<QDRData> vector = new Vector<QDRData>();
        for (QDRData qDRData : list) {
            vector.add((QDRData)qDRData.clone());
        }
        QDRPanel qDRPanel = new QDRPanel(this.conn, vector, string, string2);
        qDRPanel.setSize(300, 350);
        qDRPanel.setPreferredSize(new Dimension(300, 350));
        if (UIUtils.showPanelAsDialog((JPanel)qDRPanel, (String)OLAPArb.getString("QDR_SELECTOR_TITLE"), null, (int)7)) {
            return vector;
        }
        return null;
    }

    @Override
    public boolean isTimeTemplate() {
        return false;
    }

    @Override
    public TemplateHyperContext.ResizeMode getResizeMode() {
        return this.resizeMode;
    }
}

