/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.view;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import oracle.olap.app.Resources;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.DimensionLevel;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.app.templates.templatelist.TemplateNameFormat;
import oracle.olap.stringexpr.NameSyntaxParseException;
import oracle.olap.stringexpr.ParamValue;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;
import oracle.olap.stringexpr.TokenMgrError;

public abstract class TemplateView
implements ParamValue {
    private Template template;
    private String type;
    private String desc;
    private String nameSuffix;
    private JCheckBox checkBox;
    private TemplateNameFormat templateNameFormat;
    private Measure baseMeasure;
    private DimensionHierarchy levelHier;

    public TemplateView(Template template, String string, String string2, String string3, Resources resources) {
        this.template = template;
        this.type = string;
        this.nameSuffix = string3;
        if (resources != null) {
            if (template.getTemplateList() != null) {
                this.desc = resources.getXLIFFResource(template.getTemplateList().getFileName(), string2);
            }
        } else {
            this.desc = string2;
        }
        this.checkBox = new JCheckBox(this.desc);
        this.checkBox.setSelected(template.isSelected());
    }

    public String getName() {
        return this.getDesc();
    }

    public Template getTemplate() {
        return this.template;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDescSuffix() {
        return " " + this.desc;
    }

    public TemplateNameFormat getTemplateNameFormat() {
        return this.templateNameFormat;
    }

    public void setTemplateNameFormat(TemplateNameFormat templateNameFormat) {
        this.templateNameFormat = templateNameFormat;
    }

    public void setNameSuffix(String string) {
        this.nameSuffix = string;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setEnabled(boolean bl) {
        this.checkBox.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.checkBox.isEnabled();
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public abstract Object getProperty(String var1);

    public abstract void setProperty(String var1, Object var2);

    public abstract String getExpression(Measure var1, Dimension var2, DimensionHierarchy var3);

    public abstract void checkDependentTemplateView(String var1);

    public abstract void checkReferencedTemplateView(String var1);

    public abstract HashMap<String, String> getSQLExpressions(Measure var1, DimensionHierarchy var2);

    public String generateName(String string, Measure measure, DimensionHierarchy dimensionHierarchy, String string2) throws NameSyntaxParseException, SQLException, IOException {
        if (string.equalsIgnoreCase("name")) {
            return this.generateName(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("description")) {
            return this.generateDescription(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("shortDescription")) {
            return this.generateShortDescription(measure, dimensionHierarchy, string2);
        }
        if (string.equalsIgnoreCase("longDescription")) {
            return this.generateLongDescription(measure, dimensionHierarchy, string2);
        }
        return "";
    }

    public String generateName(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        Object object = measure.getName() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getName() != null && (string2 = this.generateFromRule(this.templateNameFormat.getName(), measure, dimensionHierarchy)).trim().length() > 0) {
            object = string2;
        }
        if (((String)(object = ((String)object).replace(' ', '_'))).length() > 30) {
            object = ((String)object).substring(0, 30);
        }
        return object;
    }

    public String generateDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateShortDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getShortDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getShortDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getShortDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateLongDescription(Measure measure, DimensionHierarchy dimensionHierarchy, String string) throws NameSyntaxParseException, SQLException, IOException {
        String string2;
        String string3 = measure.getDescription() + string;
        if (this.templateNameFormat != null && this.templateNameFormat.getLongDescription() != null && (string2 = this.generateFromRule(this.templateNameFormat.getLongDescription(), measure, dimensionHierarchy)).trim().length() > 0) {
            return string2;
        }
        return string3;
    }

    public String generateFromRule(String string, Measure measure, DimensionHierarchy dimensionHierarchy) throws NameSyntaxParseException, SQLException, IOException {
        try {
            this.baseMeasure = measure;
            this.levelHier = dimensionHierarchy;
            List<String> list = this.getVisibleParamNames();
            String string2 = StringExprParser.getParseTree(string, this, list);
            return string2;
        }
        catch (ParseException parseException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, parseException);
            throw nameSyntaxParseException;
        }
        catch (TokenMgrError tokenMgrError) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, tokenMgrError);
            throw nameSyntaxParseException;
        }
        catch (RuntimeException runtimeException) {
            NameSyntaxParseException nameSyntaxParseException = new NameSyntaxParseException(string, runtimeException);
            throw nameSyntaxParseException;
        }
    }

    private String getObjectValue(String string, Measure measure, DimensionHierarchy dimensionHierarchy) {
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.startsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = string.trim()).toLowerCase().startsWith("measure")) {
            string = string.length() > "measure_".length() ? string.substring("measure_".length(), string.length()) : "name";
            return TemplateView.getObjectDesc(measure, string);
        }
        if (string.toLowerCase().startsWith("hierarchy_level")) {
            Object object = this.getProperty("hierarchy_level");
            if (object instanceof NamedObjectWithDesc) {
                String string2 = "name";
                if (string.startsWith("hierarchy_level_")) {
                    string2 = string.substring("hierarchy_level_".length(), string.length());
                }
                NamedObjectWithDesc namedObjectWithDesc = (NamedObjectWithDesc)object;
                return TemplateView.getObjectDesc(namedObjectWithDesc, string2);
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
        if (string.toLowerCase().startsWith("hierarchy")) {
            string = string.substring("hierarchy_".length(), string.length());
            return TemplateView.getObjectDesc(dimensionHierarchy, string);
        }
        if (string.toLowerCase().startsWith("level")) {
            DimensionHierarchyLevel dimensionHierarchyLevel;
            string = string.length() > "level_".length() ? string.substring("level_".length(), string.length()) : "name";
            Object object = this.getProperty("LEVEL");
            if (object instanceof DimensionHierarchyLevel && (dimensionHierarchyLevel = (DimensionHierarchyLevel)object) != null) {
                DimensionLevel dimensionLevel = dimensionHierarchyLevel.getDimensionLevel();
                return TemplateView.getObjectDesc(dimensionLevel, string);
            }
        } else if (string.toLowerCase().startsWith("dimension")) {
            string = string.length() > "dimension_".length() ? string.substring("dimension_".length(), string.length()) : "name";
            Object object = this.getProperty("DIMENSION");
            if (object instanceof Dimension) {
                Dimension dimension = (Dimension)object;
                return TemplateView.getObjectDesc(dimension, string);
            }
        } else {
            Object object = this.getProperty(string);
            if (object != null) {
                if (object instanceof String) {
                    return (String)object;
                }
                return object.toString();
            }
        }
        return "";
    }

    public static String getObjectDesc(NamedObjectWithDesc namedObjectWithDesc, String string) {
        String string2 = namedObjectWithDesc.getName();
        if (string.equalsIgnoreCase("name")) {
            return string2;
        }
        if (string.equalsIgnoreCase("description")) {
            string2 = namedObjectWithDesc.getDescription();
        }
        if (string.equalsIgnoreCase("short_description")) {
            string2 = namedObjectWithDesc.getShortDescription();
        }
        if (string.equalsIgnoreCase("long_description")) {
            return namedObjectWithDesc.getDescription();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = namedObjectWithDesc.getName();
        }
        return string2;
    }

    @Override
    public String getValue(String string) {
        String string2 = this.getObjectValue(string, this.baseMeasure, this.levelHier);
        return string2;
    }

    public List<String> getVisibleParamNames() {
        return new ArrayList<String>();
    }
}

