/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.tree.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.tree.model.ColumnData;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.NodeType;
import oracle.olap.app.tree.model.Tree;

public class DefaultNode
implements Node {
    private Tree tree;
    private Node parent;
    private List<Node> children;
    private Object nodeData;
    private int depth;
    private NodeType nodeType;
    protected boolean allowsChildren;
    boolean childrenLoaded;
    public static final Enumeration<TreeNode> EMPTY_ENUMERATION = new Enumeration<TreeNode>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public TreeNode nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };

    public DefaultNode(Tree tree, Node node, Object object) {
        this.tree = tree;
        this.parent = node;
        this.nodeData = object;
        this.allowsChildren = true;
        this.childrenLoaded = false;
        this.nodeType = NodeType.EXISTING;
        this.children = new ArrayList<Node>();
        if (node != null) {
            this.depth = node.getDepth() + 1;
            node.addChild(this);
        }
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int n) {
        this.depth = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    @Override
    public void addChild(Node node) {
        this.children.add(node);
    }

    @Override
    public List<Node> getChildren() {
        return this.children;
    }

    public List<Node> loadChildren() {
        if (!this.childrenLoaded && this.children.size() < 1) {
            this.childrenLoaded = true;
            this.tree.getTreeLoader().loadChildren(this);
        }
        return this.children;
    }

    @Override
    public Node getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public void removeAllChildren() {
        this.children.clear();
    }

    @Override
    public void removeChild(Node node) {
        this.children.remove(node);
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public void print(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
        if (this.nodeData != null) {
            System.out.println(this.nodeData);
        }
        for (Node node : this.getChildren()) {
            node.print(n + 2);
        }
    }

    public String toString() {
        if (this.nodeData != null) {
            return this.nodeData.toString();
        }
        return "";
    }

    @Override
    public boolean matches(String string, Object object, SearchOptions searchOptions) {
        boolean bl = false;
        if (this.nodeData instanceof ColumnData) {
            ColumnData columnData = (ColumnData)this.nodeData;
            bl = columnData.matches(string, object, searchOptions);
        } else {
            bl = this.nodeData.equals(object);
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = this.nodeData.equals(object);
        return bl;
    }

    @Override
    public TreeNode getChildAt(int n) {
        if (this.children != null && n < this.children.size()) {
            return this.children.get(n);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.getChildren().indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return Collections.enumeration(this.children);
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
        if (mutableTreeNode2 != null) {
            mutableTreeNode2.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
    }

    @Override
    public void remove(int n) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getChildAt(n);
        this.children.remove(n);
        mutableTreeNode.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(mutableTreeNode)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        int n = this.getIndex(mutableTreeNode);
        this.remove(n);
    }

    @Override
    public void setUserObject(Object object) {
        if (object instanceof String) {
            if (this.nodeData instanceof ColumnData) {
                ColumnData columnData = (ColumnData)this.nodeData;
                columnData.setData(1, object);
                this.nodeType = NodeType.RENAMED;
                this.tree.logRenameNode(this);
            }
        } else {
            this.nodeData = object;
        }
    }

    @Override
    public Object getUserObject() {
        return this.nodeData;
    }

    @Override
    public void removeFromParent() {
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            return;
        }
        DefaultNode defaultNode = (DefaultNode)mutableTreeNode;
        defaultNode.addChild(this);
        this.parent = (Node)mutableTreeNode;
        this.depth = this.parent.getDepth() + 1;
        this.updateChildrenDepth(this.depth);
    }

    private void updateChildrenDepth(int n) {
        this.depth = n;
        for (Node node : this.getChildren()) {
            ((DefaultNode)node).updateChildrenDepth(n + 1);
        }
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        TreeNode treeNode2 = this;
        do {
            if (treeNode2 != treeNode) continue;
            return true;
        } while ((treeNode2 = treeNode2.getParent()) != null);
        return false;
    }

    public boolean isNodeChild(TreeNode treeNode) {
        boolean bl = treeNode == null ? false : (this.getChildCount() == 0 ? false : treeNode.getParent() == this);
        return bl;
    }
}

