/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.table.ReorderableTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.olap.OLAPArb;
import oracle.olap.build.BuildObject;
import oracle.olap.build.wizard.BuildObjectsTable;
import oracle.olap.build.wizard.BuildObjectsTableModel;

public class BuildObjectsPanel
extends DefaultTraversablePanel {
    private BuildObjectsTableModel buildObjectsTableModel;
    private BuildObjectsTable buildObjectsTable;
    private List<BuildObject> _buildObjects = new ArrayList<BuildObject>();
    private TraversableContext m_ctx;
    private JCheckBox autoOrderCheckbox;

    public BuildObjectsPanel() {
        this.buildObjectsTableModel = new BuildObjectsTableModel();
        this.buildObjectsTable = new BuildObjectsTable(this.buildObjectsTableModel);
        this.autoOrderCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.autoOrderCheckbox, (String)OLAPArb.get("BUILD_WIZARD_SEL_OBJ_AUTOMATIC_ORDER_LABEL"));
        this.autoOrderCheckbox.setSelected(true);
        this.autoOrderCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildObjectsPanel.this.buildObjectsTable.clearSelection();
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.buildObjectsTable);
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(OLAPArb.get("BUILD_WIZARD_REF_METHODS_INSTRUCTION_MSG"));
        ReorderableTableWithTitleBar reorderableTableWithTitleBar = new ReorderableTableWithTitleBar((JTable)this.buildObjectsTable, (JComponent)jScrollPane, false, false);
        ReorderableTable reorderableTable = new ReorderableTable(this.buildObjectsTable){

            public boolean isSelectionBottomMobile() {
                return super.isSelectionBottomMobile() && !BuildObjectsPanel.this.autoOrderCheckbox.isSelected();
            }

            public boolean isSelectionDownwardlyMobile() {
                return super.isSelectionDownwardlyMobile() && !BuildObjectsPanel.this.autoOrderCheckbox.isSelected();
            }

            public boolean isSelectionTopMobile() {
                return super.isSelectionTopMobile() && !BuildObjectsPanel.this.autoOrderCheckbox.isSelected();
            }

            public boolean isSelectionUpwardlyMobile() {
                return super.isSelectionUpwardlyMobile() && !BuildObjectsPanel.this.autoOrderCheckbox.isSelected();
            }
        };
        reorderableTableWithTitleBar.setReorderableTable(reorderableTable);
        this.add((Component)reorderableTableWithTitleBar, "Center");
        this.add(this.autoOrderCheckbox, "South");
        this.add((Component)multiLineLabel, "North");
    }

    public void onExit(TraversableContext traversableContext) {
        List<BuildObject> list = this.buildObjectsTableModel.getRowList();
        traversableContext.put("BUILD_OBJECTS", list);
        traversableContext.put("AUTOORDER", (Object)this.autoOrderCheckbox.isSelected());
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this._buildObjects = (List)this.m_ctx.get("BUILD_OBJECTS");
        this.buildObjectsTableModel.setBuildObjectsList(this._buildObjects);
        boolean bl = (Boolean)this.m_ctx.get("AUTOORDER");
        this.autoOrderCheckbox.setSelected(bl);
    }

    public Object getExitTransition() {
        return "OPTS";
    }
}

