/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildreports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.table.Query;
import oracle.olap.app.table.QueryComponent;
import oracle.olap.app.table.QueryComponentBuilder;
import oracle.olap.app.table.QueryPanel;
import oracle.olap.app.table.QueryTabbedPane;
import oracle.olap.buildreports.BuildStatusDialog;
import oracle.olap.buildreports.BuildStepPanel;
import oracle.olap.buildreports.BuildSummaryPanel;

public class BuildStatusPanel
extends JPanel {
    private Runnable refreshAllViews;
    private BuildStatusDialog m_buildparent;
    private BuildStepPanel m_stepPanel;
    private BuildSummaryPanel m_buildSummaryPanel;
    private QueryTabbedPane m_queryTabPanel;
    private JPanel buttonPanel;
    private JSplitPane splitPane;
    private JSplitPane leftSplitPane;
    private GridBagConstraints splitConstraints;
    private JButton m_stopButton;
    private JButton m_helpButton;
    private JButton m_cancelButton;
    private GridBagConstraints conButtonPanel;
    private Query m_validQuery;
    private Query m_statusQuery;
    private Map<String, Object> stepparams = new HashMap<String, Object>();
    private int m_buildid;
    private int m_validBuildId;
    private Connection m_connection;
    private String errorDialogTitle = null;
    private final String QUERY_LAYOUT_XML_FILE = "buildquerylayout.xml";
    private final String QUERY_LAYOUT_NAME_ADVANCED = "advanced";
    private final String QUERY_VIEW_BUILD_LOG = "build_log";
    private final String QUERY_VIEW_LOAD_SUMMARY = "load_summary";

    public BuildStatusPanel(BuildStatusDialog buildStatusDialog) {
        this.m_buildparent = buildStatusDialog;
        this.m_connection = this.m_buildparent.getConnection();
        this.m_buildid = buildStatusDialog.getBuildId();
        this.m_validBuildId = buildStatusDialog.getValidationBuildId();
        this.errorDialogTitle = OLAPArb.get("BUILD_ERROR_DLG_TITLE");
        this.jbInit();
    }

    private void jbInit() {
        this.setMinimumSize(new Dimension(1000, 750));
        this.setLayout(new GridBagLayout());
        QueryComponentBuilder queryComponentBuilder = new QueryComponentBuilder(this.m_connection, this.getClass(), "buildquerylayout.xml", "advanced", this.errorDialogTitle);
        this.m_validQuery = queryComponentBuilder.getQuery("querysteps");
        this.m_statusQuery = queryComponentBuilder.getQuery("statusmessage");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("BUILDID", this.m_buildid);
        QueryComponent queryComponent = queryComponentBuilder.getQueryViewComponent("build_log", hashMap);
        this.m_queryTabPanel = (QueryTabbedPane)queryComponent;
        hashMap = new HashMap();
        hashMap.put("FORCE", "?");
        hashMap.put("BUILDID", this.m_buildid);
        queryComponent = queryComponentBuilder.getQueryViewComponent("load_summary", hashMap);
        this.refreshAllViews = new Runnable(){

            @Override
            public void run() {
                BuildStatusPanel.this.populateAllBuildModels();
            }
        };
        this.m_buildSummaryPanel = new BuildSummaryPanel(queryComponent, this.refreshAllViews);
        this.stepparams.put("VBUILDID", this.m_validBuildId);
        this.stepparams.put("BUILDID", this.m_buildid);
        this.m_stepPanel = new BuildStepPanel(this.m_connection, this.m_validQuery, this.stepparams, this.m_statusQuery, this.m_buildid);
        this.leftSplitPane = new JSplitPane(1, this.m_stepPanel, this.m_buildSummaryPanel);
        this.leftSplitPane.setOneTouchExpandable(true);
        this.leftSplitPane.setResizeWeight(0.1);
        this.splitPane = new JSplitPane(0, this.leftSplitPane, this.m_queryTabPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitConstraints = new GridBagConstraints();
        this.splitConstraints.gridx = 0;
        this.splitConstraints.gridy = 0;
        this.splitConstraints.gridwidth = 1;
        this.splitConstraints.gridheight = 1;
        this.splitConstraints.weightx = 1.0;
        this.splitConstraints.weighty = 1.0;
        this.splitConstraints.fill = 1;
        this.splitConstraints.anchor = 11;
        this.splitConstraints.insets = this.getPanelInsets();
        this.splitPane.setResizeWeight(0.1);
        this.add((Component)this.splitPane, this.splitConstraints);
        String string = OLAPArb.get("WIZARD_CLOSE");
        this.m_cancelButton = new JButton(string);
        this.m_cancelButton.setEnabled(false);
        this.m_cancelButton.setSize(100, 10);
        this.m_cancelButton.setMinimumSize(new Dimension(100, 10));
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BuildStatusPanel.this.m_buildparent.closeBuildDialog();
                }
                catch (Exception exception) {
                    BuildStatusPanel.this.showException(exception);
                }
            }
        });
        string = OLAPArb.get("APP.MENU.HELP.NAME");
        this.m_helpButton = new JButton(string);
        this.m_helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BuildStatusDialog buildStatusDialog = BuildStatusPanel.this.m_buildparent;
                }
                catch (Exception exception) {
                    BuildStatusPanel.this.showException(exception);
                }
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.conButtonPanel = new GridBagConstraints();
        this.conButtonPanel.fill = 0;
        this.conButtonPanel.anchor = 17;
        this.conButtonPanel.gridx = 1;
        this.conButtonPanel.gridy = 0;
        this.conButtonPanel.gridwidth = 3;
        this.conButtonPanel.gridheight = 1;
        this.conButtonPanel.weightx = 1.0;
        this.conButtonPanel.weighty = 0.0;
        this.conButtonPanel.insets = new Insets(0, 20, 0, 20);
        this.m_helpButton.setSize(100, 10);
        this.conButtonPanel.weightx = 0.0;
        this.conButtonPanel.weighty = 0.0;
        this.conButtonPanel.gridwidth = 2;
        this.conButtonPanel.anchor = 13;
        this.conButtonPanel.fill = 2;
        this.conButtonPanel.gridx = 14;
        this.conButtonPanel.gridx = 16;
        this.buttonPanel.add((Component)this.m_cancelButton, this.conButtonPanel);
        this.splitConstraints.gridwidth = 0;
        this.splitConstraints.gridheight = 0;
        this.splitConstraints.weightx = 1.0;
        this.splitConstraints.weighty = 0.0;
        this.splitConstraints.fill = 2;
        this.splitConstraints.anchor = 10;
        ++this.splitConstraints.gridy;
        this.add((Component)this.buttonPanel, this.splitConstraints);
    }

    public void showBuildStatus(int n) {
        this.m_buildSummaryPanel.setDelayTimer(n);
    }

    public synchronized void populateAllBuildModels() {
        try {
            this.m_queryTabPanel.refresh();
            this.m_buildSummaryPanel.refresh();
            this.m_stepPanel.populateBuildStepModel();
            this.m_stepPanel.validate();
        }
        catch (Exception exception) {
            this.showException(exception);
        }
    }

    public void enableCloseButton() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.enableCloseButtonImpl();
            } else {
                RunEnableCloseButton runEnableCloseButton = new RunEnableCloseButton();
                SwingUtilities.invokeAndWait(runEnableCloseButton);
                Exception exception = runEnableCloseButton.getException();
                if (exception != null) {
                    throw exception;
                }
            }
        }
        catch (Exception exception) {
            this.showException(exception);
        }
    }

    protected void enableCloseButtonImpl() throws Exception {
        this.m_buildSummaryPanel.stopTimer();
        this.m_buildSummaryPanel.updateTotalsLabel();
        this.refreshAllViews.run();
        this.m_stepPanel.changeAllPendingToSucceeded();
        int n = this.m_queryTabPanel.getTabCount();
        String string = OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_REJECTEDRECTABLELOG");
        String string2 = OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_DIMENSIONCOMPTABLELOG");
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            QueryPanel queryPanel;
            String string3 = this.m_queryTabPanel.getTitleAt(i);
            if (string3.equalsIgnoreCase(string)) {
                queryPanel = (QueryPanel)this.m_queryTabPanel.getComponent(i);
                bl = queryPanel.isRecordsExist();
            }
            if (!string3.equalsIgnoreCase(string2)) continue;
            queryPanel = (QueryPanel)this.m_queryTabPanel.getComponent(i);
            bl2 = queryPanel.isRecordsExist();
        }
        if (bl && bl2) {
            JOptionPane.showMessageDialog(this.m_buildparent, OLAPArb.get("BUILD_WIZARD_STATUS_REJECTEDRECORD_DIMENSIONCOMPILE_MESSAGE"), OLAPArb.get("BUILD_WIZARD_STATUS_REJECTEDRECORD_AND_DIMENSIONCOMPILE_TITLE"), -1);
        } else if (bl) {
            JOptionPane.showMessageDialog(this.m_buildparent, OLAPArb.get("BUILD_WIZARD_STATUS_REJECTEDRECORD_MESSAGE"), OLAPArb.get("BUILD_WIZARD_STATUS_REJECTEDRECORD_TITLE"), -1);
        } else if (bl2) {
            JOptionPane.showMessageDialog(this.m_buildparent, OLAPArb.get("BUILD_WIZARD_STATUS_DIMENSIONCOMPILE_MESSAGE"), OLAPArb.get("BUILD_WIZARD_STATUS_DIMENSIONCOMPILE_TITLE"), -1);
        }
        JOptionPane.showMessageDialog(this.m_buildparent, OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_COMPLETED_MESSAGE"), OLAPArb.get("BUILD_WIZARD.STATUS.BUILD_COMPLETED_TITLE"), -1);
        this.m_cancelButton.setEnabled(true);
    }

    private void showException(Exception exception) {
        exception.printStackTrace();
        String string = null;
        String string2 = exception.getLocalizedMessage();
        if (string2 == null || string2.length() == 0) {
            string2 = exception.getClass().toString();
        }
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)this.errorDialogTitle, string);
    }

    private Insets getPanelInsets() {
        Insets insets = new Insets(10, 10, 10, 10);
        return insets;
    }

    public void cleanup() {
        this.m_stepPanel.cleanup();
        this.m_stepPanel = null;
        this.m_buildSummaryPanel.cleanup();
        this.m_buildSummaryPanel = null;
        this.m_queryTabPanel.cleanup();
        this.m_queryTabPanel = null;
        this.buttonPanel = null;
        this.splitPane = null;
        this.leftSplitPane = null;
        this.splitConstraints = null;
        this.m_helpButton = null;
        this.m_cancelButton = null;
        this.conButtonPanel = null;
        this.m_validQuery = null;
        this.m_statusQuery = null;
        this.stepparams = null;
        this.m_connection = null;
    }

    private class RunEnableCloseButton
    extends Thread {
        private Exception e1 = null;

        private RunEnableCloseButton() {
        }

        @Override
        public void run() {
            try {
                BuildStatusPanel.this.enableCloseButtonImpl();
            }
            catch (Exception exception) {
                this.e1 = exception;
            }
        }

        public Exception getException() {
            return this.e1;
        }
    }
}

