/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.calcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.calcfactory.generator.CalculatedMeasuresSQLOperationsNotifier;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.Template;
import oracle.olap.calcs.CalculatedMeasureNameValidator;
import oracle.olap.calcs.CalculatedMeasuresConfirmationDialog;
import oracle.olap.calcs.CalculatedMeasuresNameCellEditor;
import oracle.olap.calcs.CalculatedMeasuresSummarySQLXML;
import oracle.olap.calcs.CalculatedMeasuresTableCellRenderer;
import oracle.olap.calcs.CalculatedMeasuresTableModel;
import oracle.olap.calcs.MeasureNameValidator;
import oracle.olap.calcs.ReferencesTableModel;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.CubeCalcPersist;
import oracle.olap.measureexpression.MeasureExpressionBuilder;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.editor.plugins.CodeEditorTextListener;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;

public class CalculatedMeasuresDialog
extends JDialog
implements CalculatedMeasuresSQLOperationsNotifier {
    private JLabel schemaLabel;
    private JLabel cubeNameLabel;
    private JLabel schemaName;
    private JLabel cubeNameText;
    private JButton helpButton;
    private JButton cancel;
    private JButton commit;
    private JLabel addMeasureLabel;
    private JLabel removeMeasureLabel;
    private GenericTable calculatedMeasuresTable;
    private JScrollPane measuresPane;
    private CalculatedMeasuresTableModel tableModel;
    private GenericTable referencesTable;
    private ReferencesTableModel referencesTableModel;
    private GenericTable dependenciesTable;
    private ReferencesTableModel dependenciesTableModel;
    private oracle.olap.cube.model.Cube cube;
    private Connection conn;
    private CubeCalcPersist calcCreator;
    private SyntaxBuilderPanel expressionBuilder;
    private Cube appCube;
    private final ErrorDisplay errorDisplay;
    public static final int MEASURE_NAME_COLUMN = 0;
    public static final int MEASURE_DESCRIPTION_COLUMN = 1;
    public static final int MEASURE_SHORT_DESCRIPTION_COLUMN = 2;
    public static final int MEASURE_LONG_DESCRIPTION_COLUMN = 3;
    public static final int MEASURE_EXPRESSION_COLUMN = 4;
    public static final String MEASURE_DESCRIPTION = "DESCRIPTION";
    public static final String MEASURE_SHORT_DESCRIPTION = "SHORT_DESCRIPTION";
    public static final String MEASURE_LONG_DESCRIPTION = "LONG_DESCRIPTION";
    public static final String OPERATION_ADD = "ADD";
    public static final String OPERATION_UPDATE = "UPDATE";
    public static final String OPERATION_REMOVE = "REMOVE";
    public static final String MEASURE_TYPE = "MEASURE";
    private int newMeasureCount = 1;
    private int previousRow = -1;
    private Action closeAction;
    private Map<Integer, RenameMeasure> existingMeasureNames;
    private Map<Integer, Integer> updatedMeasures;
    private boolean changed = false;
    private transient SwingWorker worker;
    private CalculatedMeasuresConfirmationDialog confirmationDialog;
    private String windowTitle;
    private JPanel referencesDependenciesPanel;
    private Frame parentFrame;
    private StringBuffer createdMeasures;
    private StringBuffer deletedMeasures;
    private StringBuffer modifiedMeasures;
    private OLAPISyntaxParser parser;
    private DBObjectProvider dbObjectProvider;
    private MeasureNameValidator validator;
    private static final Logger LOG = Logger.getLogger(CalculatedMeasuresDialog.class.getName());

    public CalculatedMeasuresDialog(Frame frame, String string, oracle.olap.cube.model.Cube cube, Connection connection, CubeCalcPersist cubeCalcPersist, ErrorDisplay errorDisplay, DBObjectProvider dBObjectProvider) throws SQLException, IOException {
        super(frame, string);
        this.windowTitle = string;
        this.cube = cube;
        this.conn = connection;
        this.calcCreator = cubeCalcPersist;
        this.errorDisplay = errorDisplay;
        this.parentFrame = frame;
        this.dbObjectProvider = dBObjectProvider;
        this.init();
        this.setDefaultCloseOperation(2);
    }

    private void init() throws SQLException, IOException {
        this.existingMeasureNames = new HashMap<Integer, RenameMeasure>();
        this.updatedMeasures = new HashMap<Integer, Integer>();
        this.createdMeasures = new StringBuffer();
        this.deletedMeasures = new StringBuffer();
        this.modifiedMeasures = new StringBuffer();
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(this.conn);
        Properties properties = new Properties();
        properties.setProperty("SCHEMA", this.cube.getSchema().getName());
        Schema schema = SyntaxBuilderLauncher.populateSchema(null, properties, this.cube, databaseImpl);
        this.parser = new OLAPISyntaxParser(schema, properties);
        this.initComponents();
        this.layoutComponents();
        this.registerKeyboardActions();
        this.setModal(true);
        Dimension dimension = new Dimension(800, 650);
        this.setMinimumSize(dimension);
    }

    private void processSelectionChange(int n) throws SQLException, IOException {
        if (this.previousRow != -1) {
            LOG.log(Level.FINEST, String.format("update row with syntax builder (row NOT selected)[%s,%s,%s]", this.previousRow, this.tableModel.getValueAt(this.previousRow, 4), this.expressionBuilder.getText()));
            this.updateModel(this.previousRow);
        }
        LOG.log(Level.FINEST, String.format("load row into syntax builder (row selected) [%s,%s]", n, this.tableModel.getValueAt(n, 4)));
        this.referencesTableModel.clear();
        this.expressionBuilder.setText((String)this.tableModel.getValueAt(n, 4));
        this.previousRow = n;
        this.dependenciesTableModel.clear();
        this.addCalcDependencies((String)this.tableModel.getValueAt(n, 0));
    }

    private void updateModel(int n) throws SQLException, IOException {
        if (n < 0) {
            return;
        }
        String string = this.expressionBuilder.getSyntax();
        if (!(string.equals("") || string.equals(" ") || string.equals(this.tableModel.getValueAt(n, 4)))) {
            this.referencesTableModel.clear();
            this.saveMeasureExpression(n);
        }
        CubeCalculatedMeasure cubeCalculatedMeasure = this.cube.findCalculatedMeasure(String.valueOf(this.tableModel.getValueAt(n, 0)));
        this.addCalcReferences(cubeCalculatedMeasure);
    }

    private void saveMeasureExpression(int n) throws SQLException, IOException {
        this.tableModel.setValueAt(this.expressionBuilder.getText(), n, 4);
        Template template = this.expressionBuilder.getMatchingTemplate();
        String string = null;
        if (template != null) {
            string = template.getType();
        }
        this.tableModel.setCalculatedMeasureExpressionType(string, n);
    }

    private void initComponents() throws SQLException, IOException {
        this.schemaLabel = new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.SCHEMA_LABEL"));
        this.cubeNameLabel = new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.CUBE_NAME_LABEL"));
        this.schemaName = new JLabel(this.cube.getSchema().getName());
        this.schemaName.setBorder(BorderFactory.createEtchedBorder(1));
        this.cubeNameText = new JLabel(this.cube.getName());
        this.cubeNameText.setBorder(BorderFactory.createEtchedBorder(1));
        this.initCalculatedMeasuresTable();
        this.expressionBuilder = MeasureExpressionBuilder.createBuilder(this.cube, "", this.conn);
        this.expressionBuilder.addCodeEditorTextListener(new CodeEditorTextListener(){
            int prevRow = -1;

            @Override
            public void textChanged(String string) {
            }

            @Override
            public void syntaxChecked(String string, boolean bl) throws SQLException, IOException {
                ListSelectionModel listSelectionModel = CalculatedMeasuresDialog.this.calculatedMeasuresTable.getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                if (this.prevRow == n) {
                    CalculatedMeasuresDialog.this.updateModel(n);
                }
                this.prevRow = n;
            }
        });
        this.closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalculatedMeasuresDialog.this.close();
            }
        };
        this.appCube = new Cube(new Schema(this.cube.getSchema().getName()), this.cube.getAnalyticWorkspace(), this.cube.getName(), this.cube.getDescription(), "", false);
        this.calcCreator.setProgressNotifier(this);
    }

    private void addCalcReferences(CubeCalculatedMeasure cubeCalculatedMeasure) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(cubeCalculatedMeasure);
        while (!stack.isEmpty()) {
            CubeCalculatedMeasure cubeCalculatedMeasure2 = (CubeCalculatedMeasure)stack.pop();
            this.parser.setSyntax(cubeCalculatedMeasure2.getMeasureExpression());
            ParseNode parseNode = new ParseNode();
            if (!this.parser.parseSyntax(parseNode)) continue;
            Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                if (parseNode2.getType() == null || !parseNode2.getType().equalsIgnoreCase(MEASURE_TYPE)) continue;
                String string = String.valueOf(parseNode2.getUserObject());
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                CubeMeasure cubeMeasure = this.cube.findMeasure(string2);
                if (cubeMeasure != null) {
                    objectArray = new Object[]{cubeMeasure.getName(), cubeMeasure.getDescription(), cubeMeasure.getShortDescription(), cubeMeasure.getLongDescription(), ""};
                    this.referencesTableModel.addRow(objectArray);
                    continue;
                }
                objectArray = this.cube.findCalculatedMeasure(string2);
                if (cubeCalculatedMeasure == null) continue;
                Object[] objectArray2 = new Object[]{objectArray.getName(), objectArray.getDescription(), objectArray.getShortDescription(), objectArray.getLongDescription(), objectArray.getMeasureExpression()};
                stack.push(objectArray);
                this.referencesTableModel.addRow(objectArray2);
            }
        }
    }

    private void addCalcDependencies(String string) {
        for (CubeCalculatedMeasure cubeCalculatedMeasure : this.cube.getCalculatedMeasures()) {
            if (cubeCalculatedMeasure.getMeasureExpression().indexOf(string) < 0) continue;
            Object[] objectArray = new Object[]{cubeCalculatedMeasure.getName(), cubeCalculatedMeasure.getDescription(), cubeCalculatedMeasure.getShortDescription(), cubeCalculatedMeasure.getLongDescription(), cubeCalculatedMeasure.getMeasureExpression()};
            this.dependenciesTableModel.addRow(objectArray);
        }
    }

    private void showError(Exception exception) {
        ExceptionHandler.handleException((Throwable)exception);
    }

    private void commitChanges() throws SQLException, IOException, Exception {
        Object object;
        int n = this.tableModel.getRowCount();
        if (n == 0) {
            JOptionPane.showMessageDialog(this, OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.ADD_MEASURES_NOTIFY"), OLAPArb.getString("MEASURE_PICKER_CALC_MEASURES"), 1);
            return;
        }
        if (!this.changed) {
            this.dispose();
            return;
        }
        this.commit.setEnabled(false);
        this.helpButton.setEnabled(false);
        this.cancel.setEnabled(false);
        this.addMeasureLabel.setEnabled(false);
        this.removeMeasureLabel.setEnabled(false);
        if (!this.existingMeasureNames.isEmpty()) {
            for (Map.Entry entry : this.existingMeasureNames.entrySet()) {
                RenameMeasure renameMeasure = (RenameMeasure)entry.getValue();
            }
        }
        for (CubeCalculatedMeasure cubeCalculatedMeasure : this.cube.getCalculatedMeasures()) {
            if (!cubeCalculatedMeasure.getNewObject()) continue;
            try {
                this.addMeasureDescription(cubeCalculatedMeasure.getName(), MEASURE_DESCRIPTION, cubeCalculatedMeasure.getDescription());
                this.addMeasureDescription(cubeCalculatedMeasure.getName(), MEASURE_LONG_DESCRIPTION, cubeCalculatedMeasure.getLongDescription());
                this.addMeasureDescription(cubeCalculatedMeasure.getName(), MEASURE_SHORT_DESCRIPTION, cubeCalculatedMeasure.getShortDescription());
                this.createDerivedMeasure(cubeCalculatedMeasure.getName(), cubeCalculatedMeasure.getCalculatedMeasureType(), cubeCalculatedMeasure.getMeasureExpression());
                this.createdMeasures.append(cubeCalculatedMeasure.getName() + ",");
            }
            catch (SQLException iOException) {
            }
            catch (IOException exception) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.updatedMeasures.isEmpty()) {
            object = this.updatedMeasures.keySet().iterator();
            while (object.hasNext()) {
                int calculatedMeasuresSummarySQLXML = (Integer)object.next();
                this.calcCreator.addUpdateMeasure(String.valueOf(this.tableModel.getValueAt(calculatedMeasuresSummarySQLXML, 0)), String.valueOf(this.tableModel.getValueAt(calculatedMeasuresSummarySQLXML, 4)), this.tableModel.getCalculatedMeasureExpressionType(calculatedMeasuresSummarySQLXML), String.valueOf(this.tableModel.getValueAt(calculatedMeasuresSummarySQLXML, 1)), String.valueOf(this.tableModel.getValueAt(calculatedMeasuresSummarySQLXML, 2)), String.valueOf(this.tableModel.getValueAt(calculatedMeasuresSummarySQLXML, 3)));
                this.modifiedMeasures.append(String.valueOf(this.tableModel.getValueAt(calculatedMeasuresSummarySQLXML, 0)) + ",");
            }
        }
        object = this.calcCreator.generateSQLXML();
        CalculatedMeasuresSummarySQLXML calculatedMeasuresSummarySQLXML = new CalculatedMeasuresSummarySQLXML(this.parentFrame, this.windowTitle, (String)object);
        calculatedMeasuresSummarySQLXML.setVisible(true);
        this.worker = new SwingWorker(){

            protected Object doInBackground() {
                try {
                    CalculatedMeasuresDialog.this.calcCreator.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            @Override
            protected void done() {
                CalculatedMeasuresDialog.this.showSummary();
            }
        };
        this.worker.execute();
        this.confirmationDialog = new CalculatedMeasuresConfirmationDialog(this.parentFrame, this, this.windowTitle);
        this.confirmationDialog.setVisible(true);
    }

    private void showSummary() {
        this.confirmationDialog.updateProgressBar(100);
        this.confirmationDialog.addNotification(OLAPArb.getString("CREATE_DERIVED_MEASURES_DIALOG.NOTIFY_DONE"));
    }

    private void addMeasureDescription(String string, String string2, String string3) throws SQLException, IOException, Exception {
        this.calcCreator.setDescription(this.appCube, string, string2, string3);
    }

    private void createDerivedMeasure(String string, String string2, String string3) throws SQLException, IOException, Exception {
        Object object = this.calcCreator.addDerivedMeasure(this.appCube, string, string2, string3, null);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)this.schemaLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.schemaName, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(OracleIcons.getIcon((String)"header/database.png"));
        JPanel jPanel = new JPanel(new FlowLayout(4));
        jPanel.add(jLabel);
        this.add((Component)jPanel, new GridBagConstraints(2, n, 1, 2, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.cubeNameLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.cubeNameText, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JSplitPane jSplitPane = new JSplitPane(0, this.getMeasuresTablePanel(), this.expressionBuilder);
        jSplitPane.setDividerLocation(150);
        this.add((Component)jSplitPane, new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.8, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        JCheckBox jCheckBox = new JCheckBox(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.ADVANCED_OPTIONS"));
        jCheckBox.setSelected(false);
        this.add((Component)jCheckBox, new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 0, 0), 0, 0));
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getItemSelectable();
                if (jCheckBox.isSelected()) {
                    CalculatedMeasuresDialog.this.referencesDependenciesPanel.setVisible(true);
                } else {
                    CalculatedMeasuresDialog.this.referencesDependenciesPanel.setVisible(false);
                }
            }
        });
        this.referencesDependenciesPanel = this.createReferencesDependenciesPanel();
        this.add((Component)this.referencesDependenciesPanel, new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.1, 13, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)OLAPArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.commit = new JButton(OLAPArb.getString("DIALOG_OK_BUTTON_TEXT"));
        this.cancel = new JButton(OLAPArb.getString("DIALOG_CANCEL_BUTTON_TEXT"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalculatedMeasuresDialog.this.close();
            }
        });
        this.commit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CalculatedMeasuresDialog.this.commitChanges();
                }
                catch (SQLException sQLException) {
                    CalculatedMeasuresDialog.this.cancel.setEnabled(true);
                    CalculatedMeasuresDialog.this.commit.setEnabled(true);
                    CalculatedMeasuresDialog.this.helpButton.setEnabled(true);
                    CalculatedMeasuresDialog.this.showError(sQLException);
                }
                catch (IOException iOException) {
                    CalculatedMeasuresDialog.this.cancel.setEnabled(true);
                    CalculatedMeasuresDialog.this.commit.setEnabled(true);
                    CalculatedMeasuresDialog.this.helpButton.setEnabled(true);
                    CalculatedMeasuresDialog.this.showError(iOException);
                }
                catch (Exception exception) {
                    CalculatedMeasuresDialog.this.cancel.setEnabled(true);
                    CalculatedMeasuresDialog.this.commit.setEnabled(true);
                    CalculatedMeasuresDialog.this.helpButton.setEnabled(true);
                    CalculatedMeasuresDialog.this.showError(exception);
                }
            }
        });
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.commit, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.cancel, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, ++n, 3, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 0, 12), 0, 0));
    }

    private JPanel createReferencesDependenciesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setVisible(true);
        jPanel.setVisible(false);
        this.referencesTableModel = new ReferencesTableModel();
        this.referencesTable = new GenericTable((TableModel)this.referencesTableModel);
        this.referencesTable.setColumnSelectorAvailable(false);
        this.referencesTable.setAutoResizeMode(0);
        this.resizeCalculatedMeasuresTableColumns(this.referencesTable);
        JScrollPane jScrollPane = new JScrollPane((Component)this.referencesTable);
        this.dependenciesTableModel = new ReferencesTableModel();
        this.dependenciesTable = new GenericTable((TableModel)this.dependenciesTableModel);
        this.dependenciesTable.setColumnSelectorAvailable(false);
        this.dependenciesTable.setAutoResizeMode(0);
        this.resizeCalculatedMeasuresTableColumns(this.dependenciesTable);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.dependenciesTable);
        jTabbedPane.addTab(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.REFERENCES_TAB"), jScrollPane);
        jTabbedPane.addTab(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB"), jScrollPane2);
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    private void initCalculatedMeasuresTable() {
        this.tableModel = new CalculatedMeasuresTableModel(this.cube){

            @Override
            public void saveOldMeasureName(String string, int n) {
                if (!CalculatedMeasuresDialog.this.cube.isNewMeasure((String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0))) {
                    if (CalculatedMeasuresDialog.this.existingMeasureNames.containsKey(n)) {
                        CalculatedMeasuresDialog.this.existingMeasureNames.get(n).setNewName((String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0));
                    } else {
                        CalculatedMeasuresDialog.this.existingMeasureNames.put(n, new RenameMeasure(string, (String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0)));
                    }
                }
            }
        };
        this.calculatedMeasuresTable = new GenericTable((TableModel)this.tableModel);
        this.calculatedMeasuresTable.setAutoResizeMode(0);
        this.calculatedMeasuresTable.setRowSelectionAllowed(false);
        this.calculatedMeasuresTable.setColumnSelectorAvailable(false);
        this.calculatedMeasuresTable.setCellSelectionEnabled(true);
        this.resizeCalculatedMeasuresTableColumns(this.calculatedMeasuresTable);
        this.calculatedMeasuresTable.getSelectionModel().setSelectionMode(0);
        this.calculatedMeasuresTable.addMouseListener((MouseListener)new CalculatedMeasuresTableRowClicked());
        this.calculatedMeasuresTable.addKeyListener((KeyListener)new CalculatedMeasuresTableKeyPressed());
        this.calculatedMeasuresTable.getModel().addTableModelListener(new CalculatedMeasuresTableModelChanged());
        this.setCalculatedMeasuresTableCellEditor();
    }

    private void resizeCalculatedMeasuresTableColumns(GenericTable genericTable) {
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(385);
    }

    private void setCalculatedMeasuresTableCellEditor() {
        this.validator = new CalculatedMeasureNameValidator(this.dbObjectProvider);
        TableColumn tableColumn = this.calculatedMeasuresTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new CalculatedMeasuresNameCellEditor(this, this.cube, this.validator));
    }

    private JPanel getMeasuresTablePanel() {
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(OLAPArb.getString("MEASURE_PICKER_CALC_MEASURES")));
        componentWithTitlebar.setControlBar(this.createControlBar());
        this.measuresPane = new JScrollPane((Component)this.calculatedMeasuresTable);
        this.measuresPane.setHorizontalScrollBarPolicy(30);
        this.measuresPane.setVerticalScrollBarPolicy(20);
        componentWithTitlebar.setComponent((JComponent)this.measuresPane);
        return componentWithTitlebar;
    }

    private ControlBar createControlBar() {
        ControlBar controlBar = new ControlBar();
        this.addMeasureLabel = new JLabel();
        this.addMeasureLabel.setIcon(OracleIcons.getIcon((String)"add.png"));
        controlBar.add((Component)this.addMeasureLabel);
        this.removeMeasureLabel = new JLabel();
        this.removeMeasureLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        controlBar.add(Box.createRigidArea(new Dimension(5, 16)));
        controlBar.add((Component)this.removeMeasureLabel);
        if (this.tableModel.getRowCount() == 0) {
            this.removeMeasureLabel.setEnabled(false);
        }
        this.addMeasureLabel.addMouseListener(new AddNewMeasure());
        this.removeMeasureLabel.addMouseListener(new RemoveMeasure());
        return controlBar;
    }

    private void close() {
        this.dispose();
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.closeAction, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private boolean isNewMeasure(String string) {
        for (CubeCalculatedMeasure cubeCalculatedMeasure : this.cube.getCalculatedMeasures()) {
            if (!cubeCalculatedMeasure.getName().equalsIgnoreCase(string)) continue;
            return cubeCalculatedMeasure.getNewObject();
        }
        return true;
    }

    private boolean isMeasureCreated(String string) {
        for (CubeCalculatedMeasure cubeCalculatedMeasure : this.cube.getCalculatedMeasures()) {
            if (!cubeCalculatedMeasure.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void notifyProgress(String string, int n) {
        this.confirmationDialog.updateProgressBar(n);
        if (string.equalsIgnoreCase(OPERATION_ADD)) {
            this.confirmationDialog.addNotification(OLAPArb.format("CREATE_DERIVED_MEASURE_DIALOG.NOTIFY_ADDING_MEASURE", this.createdMeasures.toString()));
        } else if (string.equalsIgnoreCase(OPERATION_UPDATE)) {
            this.confirmationDialog.addNotification(OLAPArb.format("CREATE_DERIVED_MEASURE_DIALOG.NOTIFY_UPDATING_MEASURE", this.modifiedMeasures.toString()));
        } else if (string.equalsIgnoreCase(OPERATION_REMOVE)) {
            this.confirmationDialog.addNotification(OLAPArb.format("CREATE_DERIVED_MEASURE_DIALOG.NOTIFY_REMOVING_MEASURE", this.deletedMeasures.toString()));
        }
    }

    private class RenameMeasure {
        private String oldName;
        private String newName;

        public RenameMeasure(String string, String string2) {
            this.oldName = string;
            this.newName = string2;
        }

        public String getOldName() {
            return this.oldName;
        }

        public void setOldName(String string) {
            this.oldName = string;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String string) {
            this.newName = string;
        }
    }

    private class CalculatedMeasuresTableModelChanged
    implements TableModelListener {
        private CalculatedMeasuresTableModelChanged() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            TableModel tableModel;
            int n = tableModelEvent.getLastRow();
            int n2 = tableModelEvent.getColumn();
            CalculatedMeasuresDialog.this.changed = true;
            if (n2 >= 0 && n >= 0 && !CalculatedMeasuresDialog.this.cube.isNewMeasure((String)(tableModel = (TableModel)tableModelEvent.getSource()).getValueAt(n, 0))) {
                TableColumn tableColumn = CalculatedMeasuresDialog.this.calculatedMeasuresTable.getColumnModel().getColumn(n2);
                tableColumn.setCellRenderer(new CalculatedMeasuresTableCellRenderer(n, n2));
                if (!CalculatedMeasuresDialog.this.updatedMeasures.containsKey(n)) {
                    CalculatedMeasuresDialog.this.updatedMeasures.put(n, n);
                }
            }
        }
    }

    private class RemoveMeasure
    extends MouseAdapter {
        private RemoveMeasure() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (CalculatedMeasuresDialog.this.tableModel.getRowCount() > 0) {
                if (CalculatedMeasuresDialog.this.calculatedMeasuresTable.getSelectionModel().getLeadSelectionIndex() >= 0) {
                    int n = CalculatedMeasuresDialog.this.calculatedMeasuresTable.getSelectionModel().getLeadSelectionIndex();
                    try {
                        StringBuffer stringBuffer;
                        if (CalculatedMeasuresDialog.this.calcCreator.isMeasureCreated(CalculatedMeasuresDialog.this.appCube, (String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0)) && !CalculatedMeasuresDialog.this.cube.isNewMeasure((String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0)) && (stringBuffer = CalculatedMeasuresDialog.this.cube.getMeasureDependencies((String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0))).length() > 0) {
                            JOptionPane.showMessageDialog(CalculatedMeasuresDialog.this, OLAPArb.format("CREATE_DERIVED_MEASURES_DIALOG.REMOVE_MEASURE_WARNING", (String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0), stringBuffer.toString()), CalculatedMeasuresDialog.this.windowTitle, 0);
                            return;
                        }
                        if (CalculatedMeasuresDialog.this.updatedMeasures.containsKey(n)) {
                            CalculatedMeasuresDialog.this.updatedMeasures.remove(n);
                        }
                        CalculatedMeasuresDialog.this.deletedMeasures.append((String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0) + ",");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CalculatedMeasuresDialog.this.tableModel.removeRow((String)CalculatedMeasuresDialog.this.tableModel.getValueAt(n, 0));
                    CalculatedMeasuresDialog.this.expressionBuilder.setText(" ");
                    CalculatedMeasuresDialog.this.referencesTableModel.clear();
                }
                CalculatedMeasuresDialog.this.changed = true;
                if (CalculatedMeasuresDialog.this.tableModel.getRowCount() == 0) {
                    CalculatedMeasuresDialog.this.removeMeasureLabel.setEnabled(false);
                }
                CalculatedMeasuresDialog.this.referencesTableModel.clear();
                CalculatedMeasuresDialog.this.dependenciesTableModel.clear();
            }
        }
    }

    private class AddNewMeasure
    extends MouseAdapter {
        private AddNewMeasure() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            while (CalculatedMeasuresDialog.this.cube.findCalculatedMeasure(OLAPArb.format("CREATE_DERIVED_MEASURE_DIALOG.NEW_MEASURE_NAME", CalculatedMeasuresDialog.this.newMeasureCount)) != null) {
                ++CalculatedMeasuresDialog.this.newMeasureCount;
            }
            CalculatedMeasuresDialog.this.referencesTableModel.clear();
            CubeCalculatedMeasure cubeCalculatedMeasure = new CubeCalculatedMeasure(OLAPArb.format("CREATE_DERIVED_MEASURE_DIALOG.NEW_MEASURE_NAME", CalculatedMeasuresDialog.this.newMeasureCount));
            cubeCalculatedMeasure.setCube(CalculatedMeasuresDialog.this.cube);
            cubeCalculatedMeasure.setDescription(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_DESCRIPTION"));
            cubeCalculatedMeasure.setShortDescription(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_SHORT_DESCRIPTION"));
            cubeCalculatedMeasure.setLongDescription(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.MEASURE_LONG_DESCRIPTION"));
            cubeCalculatedMeasure.setMeasureExpression(String.format("%s.%s*%.1f", CalculatedMeasuresDialog.this.cube.getName(), CalculatedMeasuresDialog.this.cube.getMeasures()[0].getName(), 0.9));
            cubeCalculatedMeasure.setNewObject();
            CalculatedMeasuresDialog.this.tableModel.addRow(cubeCalculatedMeasure);
            CalculatedMeasuresDialog.this.calculatedMeasuresTable.changeSelection(CalculatedMeasuresDialog.this.tableModel.getRowCount() - 1, 0, false, false);
            CalculatedMeasuresDialog.this.calculatedMeasuresTable.scrollToSelection();
            CalculatedMeasuresDialog.this.expressionBuilder.setText(cubeCalculatedMeasure.getMeasureExpression());
            CalculatedMeasuresDialog.this.changed = true;
            CalculatedMeasuresDialog.this.removeMeasureLabel.setEnabled(true);
        }
    }

    private class CalculatedMeasuresTableKeyPressed
    extends KeyAdapter {
        private CalculatedMeasuresTableKeyPressed() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                int n = CalculatedMeasuresDialog.this.calculatedMeasuresTable.getSelectedRow();
                try {
                    CalculatedMeasuresDialog.this.processSelectionChange(n);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }
    }

    private class CalculatedMeasuresTableRowClicked
    extends MouseAdapter {
        private CalculatedMeasuresTableRowClicked() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = CalculatedMeasuresDialog.this.calculatedMeasuresTable.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0) {
                try {
                    CalculatedMeasuresDialog.this.processSelectionChange(n);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }
    }
}

