/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.calcs;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import oracle.javatools.db.InvalidNameException;
import oracle.olap.OLAPArb;
import oracle.olap.calcs.MeasureNameValidator;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeCalculatedMeasure;

public class CalculatedMeasuresNameCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private JTextField textField = new JTextField();
    private MeasureNameValidator validator;
    private String errorMessage = "";
    private Cube cube;
    private String previousMeasureName = "";
    private JDialog parentDialog;

    public CalculatedMeasuresNameCellEditor(JDialog jDialog, Cube cube, MeasureNameValidator measureNameValidator) {
        super(new JTextField());
        this.validator = measureNameValidator;
        this.cube = cube;
        this.parentDialog = jDialog;
    }

    @Override
    public Object getCellEditorValue() {
        String string = this.textField.getText().toUpperCase();
        try {
            this.validator.validateName("CALCULATED_MEASURE", string);
        }
        catch (InvalidNameException invalidNameException) {
            this.errorMessage = invalidNameException.getMessage();
            string = "";
        }
        return string;
    }

    @Override
    public boolean stopCellEditing() {
        int n;
        StringBuffer stringBuffer;
        String string = String.valueOf(this.getCellEditorValue());
        if (string.equals("")) {
            this.fireEditingCanceled();
            JOptionPane.showMessageDialog(this.parentDialog, this.errorMessage, OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.TITLE"), 0);
            return false;
        }
        CubeCalculatedMeasure cubeCalculatedMeasure = this.cube.findCalculatedMeasure(this.previousMeasureName);
        if (!cubeCalculatedMeasure.getNewObject() && (stringBuffer = this.cube.getMeasureDependencies(this.previousMeasureName)).length() > 0 && (n = JOptionPane.showConfirmDialog(this.parentDialog, OLAPArb.format("CREATE_DERIVED_MEASURES_DIALOG.DEPENDENCIES_WARNING", this.previousMeasureName, stringBuffer.toString()), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.TITLE"), 1)) != 0) {
            this.fireEditingCanceled();
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.previousMeasureName = String.valueOf(object);
        this.textField.setText(String.valueOf(object));
        return this.textField;
    }
}

