/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.calcs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.ui.RestrictedTextField;
import oracle.olap.calcs.CalculatedMeasureNameValidator;
import oracle.olap.util.UIStringUtils;

public class NewCalcMeasurePanel
extends JPanel
implements FocusListener {
    private JTextField longLabel;
    private JTextField shortLabel;
    private JTextField description;
    private RestrictedTextField nameField;
    private boolean descAltered;
    private boolean shortAltered;
    private boolean longAltered;
    private Cube cube;
    private CalculatedMeasureNameValidator validator;

    public NewCalcMeasurePanel(Cube cube, DBObjectProvider dBObjectProvider) {
        super(new GridBagLayout());
        this.cube = cube;
        this.validator = new CalculatedMeasureNameValidator(dBObjectProvider);
        this.layoutComponents();
        UIStringUtils.setKeyAdapterToNameField(this.nameField);
        this.setDefaultName();
    }

    private void layoutComponents() {
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        gridBagConstraints.anchor = 512;
        gridBagConstraints.fill = 2;
        this.add((Component)new JLabel(OLAPArb.getString("CALC_MEASURE_CREATE_CUBE_NAME")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JLabel(this.cube.getName()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_NAME_LABEL")), gridBagConstraints);
        this.nameField = new RestrictedTextField(30);
        this.nameField.setFilterMode(1);
        this.nameField.setMinimumSize(new Dimension(300, (int)this.nameField.getMinimumSize().getHeight()));
        this.nameField.setName("nameField");
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateDescs();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateDescs();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateDescs();
            }

            private void updateDescs() {
                String string = UIStringUtils.setupTextForDescriptions(NewCalcMeasurePanel.this.nameField.getText());
                if (!NewCalcMeasurePanel.this.descAltered) {
                    NewCalcMeasurePanel.this.description.setText(string);
                }
                if (!NewCalcMeasurePanel.this.shortAltered) {
                    NewCalcMeasurePanel.this.shortLabel.setText(string);
                }
                if (!NewCalcMeasurePanel.this.longAltered) {
                    NewCalcMeasurePanel.this.longLabel.setText(string);
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_SHORT_LABEL")), gridBagConstraints);
        this.shortLabel = new JTextField(30);
        this.shortLabel.setMinimumSize(this.nameField.getMinimumSize());
        this.shortLabel.setName("shortLabel");
        this.shortLabel.addFocusListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.shortLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_LONG_LABEL")), gridBagConstraints);
        this.longLabel = new JTextField(30);
        this.longLabel.setMinimumSize(this.nameField.getMinimumSize());
        this.longLabel.setName("longLabel");
        this.longLabel.addFocusListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.longLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 10, 4);
        this.add((Component)new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_DESCRIPTION")), gridBagConstraints);
        this.description = new JTextField(30);
        this.description.setMinimumSize(this.nameField.getMinimumSize());
        this.description.setName("description");
        this.description.addFocusListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.description, gridBagConstraints);
    }

    public String getMeasureName() {
        return this.nameField.getText();
    }

    public String getDescription() {
        return this.description.getText();
    }

    public String getLongLabel() {
        return this.longLabel.getText();
    }

    public String getShortLabel() {
        return this.shortLabel.getText();
    }

    private void updateChange(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.description) {
            this.descAltered = true;
        } else if (focusEvent.getSource() == this.longLabel) {
            this.longAltered = true;
        } else if (focusEvent.getSource() == this.shortLabel) {
            this.shortAltered = true;
        }
    }

    public boolean validateMeasureName() {
        boolean bl = true;
        try {
            this.validator.validateName("CALCULATED_MEASURE", this.nameField.getText());
            Measure measure = this.cube.findMeasure(this.nameField.getText());
            if (measure != null) {
                String string = "BASE_MEASURE_ALREADY_EXISTS_ERROR";
                if (measure.isDerived()) {
                    string = "CALC_MEASURE_ALREADY_EXISTS_ERROR";
                }
                bl = false;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.format(string, this.nameField.getText()), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.TITLE"), 0);
            }
        }
        catch (InvalidNameException invalidNameException) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), invalidNameException.getMessage(), OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.TITLE"), 0);
            this.nameField.requestFocusInWindow();
            bl = false;
        }
        return bl;
    }

    private void setDefaultName() {
        int n = 1;
        while (this.cube.findMeasure(String.format("%s%d", "CALCULATED_MEASURE", n)) != null) {
            ++n;
        }
        this.nameField.setText(String.format("%s%d", "CALCULATED_MEASURE", n));
        String string = UIStringUtils.setupTextForDescriptions(String.format("%s_%d", "CALCULATED_MEASURE", n));
        this.longLabel.setText(string);
        this.shortLabel.setText(string);
        this.description.setText(string);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.updateChange(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.updateChange(focusEvent);
    }
}

