/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Internal;
import oracle.olap.app.metadata.CubePartitionSupport;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cube.model.MeasureExpressionCascade;
import oracle.olap.cube.model.SideEffects;
import oracle.olap.cube.partition.model.PrecomputeSelection;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.olap.db.model.Descriptions;

public class Cube
extends AbstractMappableSchemaObjectWithDesc
implements Descriptions,
CubePartitionSupport,
SideEffects {
    public static final String TYPE = "CUBE";
    public static final String SPARSE_TYPE_COMPRESSED = "COMPRESSED";
    public static final String SPARSE_TYPE_SPARSE = "SPARSE";
    public static final String SPARSE_TYPE_DENSE = "DENSE";
    public static final String SPARSE_TYPE_GLOBAL = "SPARSE_GLOBAL";
    public static final String MEASURE_INDEPENDENT = "INDEPENDENT";
    public static final String MEASURE_SHARED = "SHARED";
    public static final int MAP_NO_MEASURES = 1;
    private MeasureExpressionCascade cascadeHandler;

    public Cube() {
        this.setCubeMVEnabled(false);
    }

    public String getType() {
        return TYPE;
    }

    public CubeMeasure[] getMeasures() {
        return (CubeMeasure[])this.getChildSupport("measures").getChildArray(CubeMeasure.class);
    }

    public void removeMeasure(CubeMeasure cubeMeasure) {
        this.getChildSupport("measures").removeChild((Object)cubeMeasure);
    }

    public void removeAllMeasures() {
        this.getChildSupport("measures").clearChildren();
    }

    public void setMeasures(CubeMeasure[] cubeMeasureArray) {
        this.getChildSupport("measures").setChildArray((Object[])cubeMeasureArray);
    }

    public void addMeasure(CubeMeasure cubeMeasure) {
        this.getChildSupport("measures").addChild((Object)cubeMeasure);
        String string = cubeMeasure.getName();
    }

    public CubeMeasure findMeasure(String string) {
        CubeMeasure[] cubeMeasureArray;
        for (CubeMeasure cubeMeasure : cubeMeasureArray = (CubeMeasure[])this.getChildSupport("measures").getChildArray(CubeMeasure.class)) {
            if (!cubeMeasure.getName().equals(string)) continue;
            return cubeMeasure;
        }
        return null;
    }

    public CubeCalculatedMeasure[] getCalculatedMeasures() {
        return (CubeCalculatedMeasure[])this.getChildSupport("calculatedMeasures").getChildArray(CubeCalculatedMeasure.class);
    }

    public void removeCalculatedMeasure(CubeCalculatedMeasure cubeCalculatedMeasure) {
        this.getChildSupport("calculatedMeasures").removeChild((Object)cubeCalculatedMeasure);
    }

    public void removeAllCalculatedMeasures() {
        this.getChildSupport("calculatedMeasures").clearChildren();
    }

    public void setCalculatedMeasures(CubeCalculatedMeasure[] cubeCalculatedMeasureArray) {
        this.getChildSupport("calculatedMeasures").setChildArray((Object[])cubeCalculatedMeasureArray);
    }

    public void addCalculatedMeasure(CubeCalculatedMeasure cubeCalculatedMeasure) {
        this.getChildSupport("calculatedMeasures").addChild((Object)cubeCalculatedMeasure);
    }

    public CubeCalculatedMeasure findCalculatedMeasure(String string) {
        CubeCalculatedMeasure[] cubeCalculatedMeasureArray;
        for (CubeCalculatedMeasure cubeCalculatedMeasure : cubeCalculatedMeasureArray = (CubeCalculatedMeasure[])this.getChildSupport("calculatedMeasures").getChildArray(CubeCalculatedMeasure.class)) {
            if (!cubeCalculatedMeasure.getName().equals(string)) continue;
            return cubeCalculatedMeasure;
        }
        return null;
    }

    public boolean isNewMeasure(String string) {
        CubeCalculatedMeasure cubeCalculatedMeasure = this.findCalculatedMeasure(string);
        if (cubeCalculatedMeasure != null) {
            return cubeCalculatedMeasure.getNewObject();
        }
        return true;
    }

    public StringBuffer getMeasureDependencies(String string) {
        CubeCalculatedMeasure[] cubeCalculatedMeasureArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (CubeCalculatedMeasure cubeCalculatedMeasure : cubeCalculatedMeasureArray = (CubeCalculatedMeasure[])this.getChildSupport("calculatedMeasures").getChildArray(CubeCalculatedMeasure.class)) {
            if (cubeCalculatedMeasure.getMeasureExpression().indexOf(string) < 0) continue;
            stringBuffer.append(cubeCalculatedMeasure.getName() + ",");
        }
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        }
        return stringBuffer;
    }

    public CubeDimensionality[] getDimensions() throws IllegalStateException {
        return (CubeDimensionality[])this.getChildSupport("dimensions").getChildArray(CubeDimensionality.class);
    }

    public void setDimensions(CubeDimensionality[] cubeDimensionalityArray) {
        this.getChildSupport("dimensions").setChildArray((Object[])cubeDimensionalityArray);
    }

    public void setDimensions(String[] stringArray) {
        this.getChildSupport("dimensions").setChildArray((Object[])stringArray);
    }

    public void addDimensionality(CubeDimensionality cubeDimensionality) {
        this.getChildSupport("dimensions").addChild((Object)cubeDimensionality);
        Object object = cubeDimensionality.getName();
        if (cubeDimensionality.getMapExpression() == null && ((String)object).equalsIgnoreCase("TIME")) {
            object = "\"" + (String)object + "\"";
        }
    }

    public CubeDimensionality findDimensionality(String string) {
        CubeDimensionality[] cubeDimensionalityArray;
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 2) {
            string = stringArray[1];
        }
        for (CubeDimensionality cubeDimensionality : cubeDimensionalityArray = (CubeDimensionality[])this.getChildSupport("dimensions").getChildArray(CubeDimensionality.class)) {
            if (!cubeDimensionality.getName().equals(string)) continue;
            return cubeDimensionality;
        }
        return null;
    }

    public void removeAllDimensions() {
        this.getChildSupport("dimensions").clearChildren();
    }

    public CubeBuildSpecification[] getBuildSpecifications() {
        return (CubeBuildSpecification[])this.getChildSupport("buildSpecifications").getChildArray(CubeBuildSpecification.class);
    }

    public void addBuildSpecification(CubeBuildSpecification cubeBuildSpecification) {
        this.getChildSupport("buildSpecifications").addChild((Object)cubeBuildSpecification);
    }

    public CubeBuildSpecification findBuildSpecification(String string) {
        CubeBuildSpecification[] cubeBuildSpecificationArray;
        for (CubeBuildSpecification cubeBuildSpecification : cubeBuildSpecificationArray = this.getBuildSpecifications()) {
            if (!cubeBuildSpecification.getName().equals(string)) continue;
            return cubeBuildSpecification;
        }
        return null;
    }

    public void removeAllBuildSpecification() {
        this.getChildSupport("buildSpecifications").clearChildren();
    }

    public void setBuildSpecifications(CubeBuildSpecification[] cubeBuildSpecificationArray) {
        this.getChildSupport("buildSpecifications").setChildArray((Object[])cubeBuildSpecificationArray);
    }

    public CubeBuildSpecification getBuildSpecification(String string) {
        CubeBuildSpecification[] cubeBuildSpecificationArray;
        for (CubeBuildSpecification cubeBuildSpecification : cubeBuildSpecificationArray = (CubeBuildSpecification[])this.getChildSupport("buildSpecifications").getChildArray(CubeBuildSpecification.class)) {
            if (!cubeBuildSpecification.getName().equals(string)) continue;
            return cubeBuildSpecification;
        }
        return null;
    }

    public void setDefaultBuildSpecification(String string) {
        this.setProperty("defaultBuildSpecifications", string);
    }

    public String getDefaultBuildSpecification() {
        return (String)this.getProperty("defaultBuildSpecifications");
    }

    public void setPrecomputeCondition(String string) {
        this.setProperty("precomputeCondition", string);
    }

    public String getPrecomputeCondition() {
        return (String)this.getProperty("precomputeCondition");
    }

    public void setPrecomputePercent(Integer n) {
        this.setProperty("precomputePercent", n);
    }

    public Integer getPrecomputePercent() {
        Integer n = (Integer)this.getProperty("precomputePercent");
        return n;
    }

    public void setPrecomputePercentTop(Integer n) {
        this.setProperty("precomputePercentTop", n);
    }

    public Integer getPrecomputePercentTop() {
        Integer n = (Integer)this.getProperty("precomputePercentTop");
        return n;
    }

    public void setCompressed() {
        this.setSparseType(SPARSE_TYPE_COMPRESSED);
    }

    public boolean isCompress() {
        String string = this.getSparseType();
        return string != null && string.equals(SPARSE_TYPE_COMPRESSED);
    }

    public String getSparseType() {
        return (String)this.getProperty("sparseType");
    }

    public void setSparseType(String string) {
        this.setProperty("sparseType", string);
    }

    public String getMeasureStorage() {
        return (String)this.getProperty("measureStorage");
    }

    public void setMeasureStorage(String string) {
        this.setProperty("measureStorage", string);
    }

    public String getSqlCubeStorageType() {
        return (String)this.getProperty("sqlCubeStorageType");
    }

    public void setSqlCubeStorageType(String string) {
        this.setProperty("sqlCubeStorageType", string);
    }

    public String getCubeStorageType() {
        return (String)this.getProperty("cubeStorageType");
    }

    public void setCubeStorageType(String string) {
        this.setProperty("cubeStorageType", string);
    }

    public void addPartition(CubePartition cubePartition) {
        this.getChildSupport("partitions").addChild((Object)cubePartition);
    }

    public CubePartition[] getPartitions() {
        return (CubePartition[])this.getChildSupport("partitions").getChildArray(CubePartition.class);
    }

    public void setPartitions(CubePartition[] cubePartitionArray) {
        this.getChildSupport("partitions").setChildArray((Object[])cubePartitionArray);
    }

    public void removePartition(CubePartition cubePartition) {
        this.getChildSupport("partitions").removeChild((Object)cubePartition);
    }

    public void removeAllPartitions() {
        this.getChildSupport("partitions").clearChildren();
    }

    public String getConsistentSolveSpec() {
        return (String)this.getProperty("consistentSolveSpec");
    }

    public void setConsistentSolveSpec(String string) {
        this.setProperty("consistentSolveSpec", string);
    }

    public void setAggregationMethod(String string) {
        this.setProperty("aggregationMethod", string);
    }

    public String getAggregationMethod() {
        return (String)this.getProperty("aggregationMethod");
    }

    public void setMapName(String string) {
        this.setProperty("mapName", string);
    }

    public String getMapName() {
        return (String)this.getProperty("mapName");
    }

    public void setMapQuery(String string) {
        this.setProperty("mapQuery", string);
    }

    public String getMapQuery() {
        return (String)this.getProperty("mapQuery");
    }

    public void setMapWhereClause(String string) {
        this.setProperty("mapWhereClause", string);
    }

    public String getMapWhereClause() {
        return (String)this.getProperty("mapWhereClause");
    }

    public void setName(String string) {
        String string2 = this.getName();
        super.setName(string);
        String string3 = this.getMapQuery();
        if (string3 == null || string3.equals(string2)) {
            string3 = string;
        }
    }

    @Override
    public boolean isSupported(String string) {
        return true;
    }

    @Override
    public boolean isPartitioned() {
        int n = this.getPartitions().length;
        return n > 0;
    }

    @Override
    public String getPartitionDimensionName() {
        if (this.isPartitioned()) {
            CubePartition cubePartition = this.getPartitions()[0];
            return cubePartition.getPartitionDimension();
        }
        return null;
    }

    @Override
    public List<PrecomputeSelection> getSecondaryLevelPrecomputeValues() {
        ArrayList<PrecomputeSelection> arrayList = new ArrayList<PrecomputeSelection>();
        for (CubePartition cubePartition : this.getPartitions()) {
            String string = cubePartition.getPartitionHierarchy();
            String string2 = cubePartition.getPartitionLevel();
            Integer n = cubePartition.getPrecomputePercent();
            PrecomputeSelection precomputeSelection = new PrecomputeSelection(string, string2, n.toString());
            arrayList.add(precomputeSelection);
        }
        return arrayList;
    }

    public boolean isMVOn() {
        boolean bl = false;
        String string = this.getMVOption();
        if (string != null && (string.equals("COMPLETE_REFRESH") || string.equals("FAST_REFRESH") || string.equals("REWRITE_WITH_ATTRIBUTES") || string.equals("REWRITE"))) {
            bl = true;
        }
        return bl;
    }

    public String getMVOption() {
        return (String)this.getProperty("MVOption");
    }

    public void setMVOption(String string) {
        this.setProperty("MVOption", string);
    }

    public void setSQLExpressions(boolean bl) {
        this.setProperty("SQLExpressions", bl);
    }

    public boolean getSQLExpressions() {
        if (this.getProperty("SQLExpressions") != null) {
            return (Boolean)this.getProperty("SQLExpressions");
        }
        return false;
    }

    @Override
    public List<SystemObject> getAffectedObjectOld() {
        if (this.cascadeHandler == null) {
            return Collections.emptyList();
        }
        return this.cascadeHandler.getAffectedObjectOld();
    }

    @Override
    public List<SystemObject> getAffectedObjectNew() {
        if (this.cascadeHandler == null) {
            return Collections.emptyList();
        }
        return this.cascadeHandler.getAffectedObjectNew();
    }

    public void propagateRenameToExpressions(String string, String string2, boolean bl) {
        if (string == null || string2 == null || string.equals(string2)) {
            return;
        }
        this.cascadeHandler.runRenames(string, string2, bl);
    }

    public synchronized void setCascadeHandler(MeasureExpressionCascade measureExpressionCascade) {
        this.cascadeHandler = measureExpressionCascade;
    }

    @Internal
    public MeasureExpressionCascade getCascadeHandler() {
        return this.cascadeHandler;
    }

    @Override
    public int getNotMappableCause() {
        if (this.getMeasures().length == 0) {
            return 1;
        }
        return 0;
    }

    @Internal
    public Map<String, CubeDimension> getDimensionMap(Object object) {
        LinkedHashMap<String, CubeDimension> linkedHashMap = new LinkedHashMap<String, CubeDimension>();
        List list = (List)object;
        for (CubeDimensionality cubeDimensionality : this.getDimensions()) {
            for (CubeDimension cubeDimension : list) {
                if (!cubeDimensionality.getName().equals(cubeDimension.getName())) continue;
                linkedHashMap.put(cubeDimensionality.getName(), cubeDimension);
            }
        }
        return linkedHashMap;
    }

    @Internal
    public CubeDimension[] getDimensions(Object object) {
        Map<String, CubeDimension> map = this.getDimensionMap(object);
        CubeDimension[] cubeDimensionArray = new CubeDimension[map.keySet().size()];
        int n = 0;
        for (String string : map.keySet()) {
            CubeDimension cubeDimension = map.get(string);
            cubeDimensionArray[n++] = cubeDimension;
        }
        return cubeDimensionArray;
    }

    public CubeDimension findDimension(Object object, String string) {
        for (CubeDimension cubeDimension : this.getDimensions(object)) {
            if (!cubeDimension.getName().equals(string)) continue;
            return cubeDimension;
        }
        return null;
    }

    public CubeDimension findDimension(Object object, CubeDimensionality cubeDimensionality) {
        return this.findDimension(object, cubeDimensionality.getName());
    }

    @Internal
    public void setCubeMVEnabled(boolean bl) {
        this.setProperty("cubeMVEnabled", bl);
    }

    @Internal
    public boolean getCubeMVEnabled() {
        Boolean bl = (Boolean)this.getProperty("cubeMVEnabled");
        return bl;
    }
}

