/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.property.Internal;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.cubedimension.model.CubeDimensionMap;
import oracle.olap.cubedimension.model.CubeSubDimension;

public class CubeDimensionHierarchy
extends CubeSubDimension {
    public static final String TYPE = "DIM_HIERARCHY";

    public CubeDimensionHierarchy() {
    }

    public CubeDimensionHierarchy(String string) {
        super(string);
        this._setHierarchyLevelType(true);
        this.setOriginalHierarchyName(string);
    }

    public String getType() {
        return TYPE;
    }

    public void setHierarchyLevelType(boolean bl) {
        this._setHierarchyLevelType(bl);
    }

    private void _setHierarchyLevelType(boolean bl) {
        this.setProperty("hierarchyLevelType", bl);
        this.setProperty("hierarchyValueType", !bl);
    }

    public boolean getHierarchyLevelType() {
        boolean bl = (Boolean)this.getProperty("hierarchyLevelType");
        return bl;
    }

    public void setHierarchyValueType(boolean bl) {
        this.setProperty("hierarchyValueType", bl);
        this.setProperty("hierarchyLevelType", !bl);
    }

    public boolean getHierarchyValueType() {
        boolean bl = false;
        if (this.getProperty("hierarchyValueType") != null) {
            bl = (Boolean)this.getProperty("hierarchyValueType");
        }
        return bl;
    }

    public boolean isHierarchyDefault() {
        boolean bl = false;
        if (this.getProperty("hierarchyDefault") != null) {
            bl = (Boolean)this.getProperty("hierarchyDefault");
        }
        return bl;
    }

    public void setHierarchyDefault(boolean bl) {
        this.setProperty("hierarchyDefault", bl);
    }

    public boolean isNotSkipLevel() {
        boolean bl = false;
        if (this.getProperty("notSkipLevel") != null) {
            bl = (Boolean)this.getProperty("notSkipLevel");
        }
        return bl;
    }

    public void setNotSkipLevel(boolean bl) {
        this.setProperty("notSkipLevel", bl);
    }

    public boolean isNotRagged() {
        boolean bl = false;
        if (this.getProperty("notRagged") != null) {
            bl = (Boolean)this.getProperty("notRagged");
        }
        return bl;
    }

    public void setNotRagged(boolean bl) {
        this.setProperty("notRagged", bl);
    }

    public void setMap(CubeDimensionMap cubeDimensionMap) {
        this.setProperty("map", (Object)cubeDimensionMap);
    }

    public CubeDimensionMap getMap() {
        return (CubeDimensionMap)((Object)this.getProperty("map"));
    }

    public void addHierarchyLevel(CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel) {
        this.getChildSupport("hierarchyLevels").addChild((Object)cubeDimensionHierarchyLevel);
    }

    public void setViewName(String string) {
        this.setProperty("etViewName", string);
    }

    public String getViewName() {
        return (String)this.getProperty("etViewName");
    }

    public CubeDimensionHierarchyLevel[] getHierarchyLevels() {
        return (CubeDimensionHierarchyLevel[])this.getChildSupport("hierarchyLevels").getChildArray(CubeDimensionHierarchyLevel.class);
    }

    public void setHierarchyLevels(CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray) {
        this.getChildSupport("hierarchyLevels").setChildArray((Object[])cubeDimensionHierarchyLevelArray);
    }

    public CubeDimensionHierarchyLevel[] getHierarchyLevelsReverse() {
        CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = (CubeDimensionHierarchyLevel[])this.getChildSupport("hierarchyLevels").getChildArray(CubeDimensionHierarchyLevel.class);
        List<CubeDimensionHierarchyLevel> list = Arrays.asList(cubeDimensionHierarchyLevelArray);
        ArrayList<CubeDimensionHierarchyLevel> arrayList = new ArrayList<CubeDimensionHierarchyLevel>();
        arrayList.addAll(list);
        Collections.reverse(arrayList);
        cubeDimensionHierarchyLevelArray = arrayList.toArray(new CubeDimensionHierarchyLevel[arrayList.size()]);
        return cubeDimensionHierarchyLevelArray;
    }

    public void removeAllHierarchyLevels() {
        this.getChildSupport("hierarchyLevels").clearChildren();
    }

    public void removeHierarchyLevel(CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel) {
        this.getChildSupport("hierarchyLevels").removeChild((Object)cubeDimensionHierarchyLevel);
    }

    public void setOriginalHierarchyName(String string) {
        this.setProperty("originalHierarchyName", string);
    }

    @Internal
    public String getOriginalHierarchyName() {
        return (String)this.getProperty("originalHierarchyName");
    }

    private CubeDimensionLevel checkLevel(CubeDimensionLevel cubeDimensionLevel, CubeDimension cubeDimension) {
        String string;
        if (cubeDimension == null) {
            throw new IllegalArgumentException("need a dimension set to add levels to  " + this.getName());
        }
        if (cubeDimensionLevel.getCubeDimension() != cubeDimension && (cubeDimensionLevel = cubeDimension.findLevel(string = cubeDimensionLevel.getName())) == null) {
            throw new IllegalArgumentException("cannot add level " + string + " to hierarchy " + this.getName() + " - level doesn't exist on this cube dimension");
        }
        return cubeDimensionLevel;
    }

    public boolean isChanged(List<CubeDimensionLevel> list) {
        CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = this.getHierarchyLevels();
        if (cubeDimensionHierarchyLevelArray.length != list.size()) {
            return true;
        }
        for (int i = 0; i < cubeDimensionHierarchyLevelArray.length; ++i) {
            CubeDimensionLevel cubeDimensionLevel;
            CubeDimensionLevel cubeDimensionLevel2 = cubeDimensionHierarchyLevelArray[i].getLevel();
            if (cubeDimensionLevel2.equals(cubeDimensionLevel = list.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean containsLevel(CubeDimensionLevel cubeDimensionLevel) {
        for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : this.getHierarchyLevels()) {
            CubeDimensionLevel cubeDimensionLevel2 = cubeDimensionHierarchyLevel.getLevel();
            if (!cubeDimensionLevel2.equals(cubeDimensionLevel)) continue;
            return true;
        }
        return false;
    }

    public CubeDimensionHierarchyLevel findHierarchyLevel(CubeDimensionLevel cubeDimensionLevel) {
        for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : this.getHierarchyLevels()) {
            if (cubeDimensionHierarchyLevel.getLevel() != cubeDimensionLevel) continue;
            return cubeDimensionHierarchyLevel;
        }
        return null;
    }

    public CubeDimensionHierarchyLevel findHierarchyLevel(String string) {
        for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel : this.getHierarchyLevels()) {
            if (!cubeDimensionHierarchyLevel.getLevel().getName().equals(string)) continue;
            return cubeDimensionHierarchyLevel;
        }
        return null;
    }
}

