/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.ide.Ide;
import oracle.ide.db.components.ComponentFactory;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.olap.OLAPArb;
import oracle.olap.app.tree.loader.TreeLoaderXML;
import oracle.olap.app.tree.model.TreeTable;
import oracle.olap.app.tree.view.JTreeTable;
import oracle.olap.app.tree.view.JTreeTableToolTipManager;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.Descriptions;
import oracle.olap.db.model.LanguageDescription;
import oracle.olap.db.model.LanguageDescriptionsHelper;
import oracle.olap.db.model.StatefulDescriptions;
import oracle.olap.db.view.DescriptionPanelTreeLoaderXML;
import oracle.olap.db.view.LanguagesSelectorDialog;
import oracle.olap.db.view.MyTableCellEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class DescriptionPanel<T extends AbstractSchemaObjectWithDesc>
extends BaseEditorPanel<T>
implements JTreeTableToolTipManager {
    private TreeLoaderXML treeLoaderXML;
    private JTreeTable namingTreeTable;
    private String rootXMLNodeName;
    private int operationResult;
    private String editDescriptionText;
    private JButton modifyLanguagesBtn;
    private DefaultListModel descriptionTranslations = new DefaultListModel();
    private String defaultLanguage;
    private String[] initialLanguages;
    private boolean languagesChanged;
    private boolean languageDescriptionsModified;

    public DescriptionPanel() {
        this.layoutComponents();
    }

    public void setLanguageDescriptionsModified(boolean bl) {
        this.languageDescriptionsModified = bl;
    }

    protected void initialisePanel() {
        try {
            this.defaultLanguage = LanguageDBSettings.getDefaultLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.descriptionTranslations.contains(this.defaultLanguage)) {
            this.descriptionTranslations.addElement(this.defaultLanguage);
        }
        this.initExistingDescriptionTranslationColumns(this.descriptionTranslations);
        this.initTreeLoader();
        this.populateNameTreeTable();
    }

    private void initTreeLoader() {
        String string = this.getDescriptionXML();
        try {
            Object object;
            String string2 = this.getDescriptionEditorXML();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.descriptionTranslations.getSize() > 1) {
                object = this.descriptionTranslations.elements();
                while (object.hasMoreElements()) {
                    String string3 = (String)object.nextElement();
                    if (string3.equalsIgnoreCase(this.defaultLanguage)) continue;
                    arrayList.add(string3);
                }
            }
            this.treeLoaderXML = new DescriptionPanelTreeLoaderXML(string, this.getClass(), string2, arrayList);
            int n = 0;
            object = this.treeLoaderXML.getDocument().getChildNodes();
            if (n < object.getLength()) {
                this.rootXMLNodeName = object.item(n).getNodeName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void populateNameTreeTable() {
        TreeTable treeTable = (TreeTable)this.treeLoaderXML.getTree();
        this.namingTreeTable.setModel(treeTable);
        this.namingTreeTable.expandAll(true);
        this.namingTreeTable.getColumnModel().getColumn(0).setHeaderValue(OLAPArb.getString("DESCRIPTION_PANEL_NAME_TITLE"));
        this.namingTreeTable.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.namingTreeTable.getColumnModel().getColumn(1).setHeaderValue(this.defaultLanguage);
        this.namingTreeTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        if (this.namingTreeTable.getColumnCount() > 2) {
            for (int i = 2; i < this.namingTreeTable.getColumnCount(); ++i) {
                this.namingTreeTable.getColumnModel().getColumn(i).setPreferredWidth(250);
            }
        }
    }

    protected void initExistingDescriptionTranslationColumns(DefaultListModel defaultListModel) {
        LanguageDescriptionsHelper languageDescriptionsHelper = (LanguageDescriptionsHelper)this.getUpdatedObject();
        for (LanguageDescription languageDescription : languageDescriptionsHelper.getLanguageDescriptions()) {
            if (defaultListModel.contains(languageDescription.getLanguage())) continue;
            defaultListModel.addElement(languageDescription.getLanguage());
        }
        try {
            List<String> list = LanguageDBSettings.getDescriptionLanguages(((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getAnalyticWorkspace());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (defaultListModel.contains(string)) continue;
                defaultListModel.addElement(string);
            }
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(DescriptionPanel.class.getName());
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    protected abstract String[] getObjectXPaths();

    protected abstract String getDescriptionXML();

    protected abstract String getDescriptionEditorXML();

    protected String getDescXML(String string, AbstractChildObjectWithDesc abstractChildObjectWithDesc) {
        return this.getDescXML(string, abstractChildObjectWithDesc.getName(), abstractChildObjectWithDesc);
    }

    protected String getDescXML(String string, String string2, Descriptions descriptions) {
        String string3;
        String string4;
        LanguageDescriptionsHelper languageDescriptionsHelper = this.getLanguageDescriptionsHelper(string, string2);
        String string5 = descriptions.getDescription();
        if (string5 == null) {
            string5 = "";
        }
        if ((string4 = descriptions.getShortDescription()) == null) {
            string4 = "";
        }
        if ((string3 = descriptions.getLongDescription()) == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string6 = String.format("  <%s name=\"%s\">\n", string, string2);
        stringBuffer.append(string6);
        string6 = String.format("    <%sDescription description=\"%s\" shortDescription=\"%s\" longDescription=\"%s\">\n", string, string5, string4, string3);
        stringBuffer.append(string6);
        if (languageDescriptionsHelper != null) {
            LanguageDescription[] languageDescriptionArray;
            for (LanguageDescription languageDescription : languageDescriptionArray = languageDescriptionsHelper.getLanguageDescriptions()) {
                stringBuffer.append(String.format("<LanguageDescription language='%s' description='%s' shortDescription='%s' longDescription='%s' /> \n", languageDescription.getLanguage(), languageDescription.getDescription(), languageDescription.getShortDescription(), languageDescription.getLongDescription()));
            }
        }
        stringBuffer.append(String.format("</%sDescription>\n", string));
        string6 = String.format("  </%s>\n", string);
        stringBuffer.append(string6);
        return stringBuffer.toString();
    }

    protected void commitPanel() {
        String string = this.treeLoaderXML.generateXML();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            Document document = documentBuilder.parse(new InputSource(stringReader));
            XPath xPath = XPathFactory.newInstance().newXPath();
            for (String string2 : this.getObjectXPaths()) {
                XPathExpression xPathExpression = xPath.compile(string2);
                Object object = xPathExpression.evaluate(document, XPathConstants.NODESET);
                NodeList nodeList = (NodeList)object;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.commitFromXMLNode(xPath, nodeList.item(i));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void commitFromXMLNode(XPath xPath, Node node) throws XPathExpressionException {
        Object object;
        StatefulDescriptions statefulDescriptions = this.findDBObjectWithDesc(node);
        LanguageDescriptionsHelper languageDescriptionsHelper = this.getLanguageDescriptionHelper(node);
        if (this.initialLanguages != null && this.initialLanguages.length != this.descriptionTranslations.size()) {
            for (String string : this.initialLanguages) {
                if (this.descriptionTranslations.contains(string) || (object = languageDescriptionsHelper.findLanguageDescription(string)) == null) continue;
                languageDescriptionsHelper.removeLanguageDescription((LanguageDescription)object);
            }
        }
        if (statefulDescriptions != null) {
            String string;
            Object object2 = xPath.compile("*/@description");
            String string2 = object2.evaluate(node);
            if (!(string2 = string2.trim()).equalsIgnoreCase(statefulDescriptions.getDescription()) && !this.isEditing()) {
                statefulDescriptions.markDescriptionDirty(true);
            }
            statefulDescriptions.setDescription(string2);
            object2 = xPath.compile("*/@shortDescription");
            String string3 = object2.evaluate(node);
            string3 = string3.trim();
            if (!string3.equalsIgnoreCase(statefulDescriptions.getShortDescription()) && !this.isEditing()) {
                statefulDescriptions.markShortDescriptionDirty(true);
            }
            statefulDescriptions.setShortDescription(string3);
            object2 = xPath.compile("*/@longDescription");
            string = object2.evaluate(node);
            string = string.trim();
            if (!string.equalsIgnoreCase(statefulDescriptions.getLongDescription()) && !this.isEditing()) {
                statefulDescriptions.markLongDescriptionDirty(true);
            }
            statefulDescriptions.setLongDescription(string);
            object2 = xPath.compile("./*[@language]");
            object = object2.evaluate(node, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)object;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.addLanguageDescriptions(xPath, nodeList.item(i), languageDescriptionsHelper);
            }
        }
    }

    private StatefulDescriptions findDBObjectWithDesc(Node node) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xPath.compile("@name");
        String string = xPathExpression.evaluate(node);
        String string2 = node.getNodeName();
        return this.findDBObjectWithDesc(string2, string);
    }

    private LanguageDescriptionsHelper getLanguageDescriptionHelper(Node node) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xPath.compile("@name");
        String string = xPathExpression.evaluate(node);
        String string2 = node.getNodeName();
        return this.getLanguageDescriptionsHelper(string2, string);
    }

    protected abstract StatefulDescriptions findDBObjectWithDesc(String var1, String var2);

    protected abstract LanguageDescriptionsHelper getLanguageDescriptionsHelper(String var1, String var2);

    private void addLanguageDescriptions(XPath xPath, Node node, LanguageDescriptionsHelper languageDescriptionsHelper) throws XPathExpressionException {
        if (languageDescriptionsHelper != null) {
            XPathExpression xPathExpression = xPath.compile("@language");
            String string = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@description");
            String string2 = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@shortDescription");
            String string3 = xPathExpression.evaluate(node);
            xPathExpression = xPath.compile("@longDescription");
            String string4 = xPathExpression.evaluate(node);
            LanguageDescription languageDescription = languageDescriptionsHelper.findLanguageDescription(string);
            if (languageDescription != null) {
                languageDescription.setDescription(string2);
                languageDescription.setShortDescription(string3);
                languageDescription.setLongDescription(string4);
            } else if (this.languagesChanged || !string4.isEmpty() || !string2.isEmpty() || !string3.isEmpty() || this.languageDescriptionsModified) {
                languageDescription = new LanguageDescription(string);
                languageDescription.setLanguage(string);
                languageDescription.setDescription(string2);
                languageDescription.setShortDescription(string3);
                languageDescription.setLongDescription(string4);
                languageDescriptionsHelper.addLanguageDescription(languageDescription);
            }
        }
    }

    private void layoutComponents() {
        this.namingTreeTable = new JTreeTable();
        this.namingTreeTable.setToolTipManager(this);
        this.modifyLanguagesBtn = new JButton(OLAPArb.getString("DESCRIPTION_PANEL_MODIFY_LANGUAGES_BTN"));
        this.modifyLanguagesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DescriptionPanel.this.initialLanguages = new String[DescriptionPanel.this.descriptionTranslations.size()];
                DescriptionPanel.this.descriptionTranslations.copyInto(DescriptionPanel.this.initialLanguages);
                LanguagesSelectorDialog languagesSelectorDialog = new LanguagesSelectorDialog((Frame)Ide.getMainWindow(), OLAPArb.getString("LANGUAGES_SELECTOR_DIALOG_TITLE"), DescriptionPanel.this.descriptionTranslations, DescriptionPanel.this.defaultLanguage);
                languagesSelectorDialog.setVisible(true);
                if (languagesSelectorDialog.isOkClicked() && !DescriptionPanel.this.descriptionTranslations.isEmpty()) {
                    DescriptionPanel.this.languagesChanged = true;
                    DescriptionPanel.this.initTreeLoader();
                    DescriptionPanel.this.populateNameTreeTable();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.namingTreeTable, 30, 20);
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)this.namingTreeTable, "languageDescriptions");
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(jScrollPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.modifyLanguagesBtn, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.namingTreeTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                Object object2;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1 && (object2 = jTable.getModel().getValueAt(n, 0)) instanceof String && (string = (String)object2).toLowerCase().endsWith("/name")) {
                    Font font = component.getFont();
                    component.setFont(font.deriveFont(1));
                }
                return component;
            }
        });
        this.namingTreeTable.setDefaultEditor(Object.class, new MyTableCellEditor(this));
    }

    @Override
    public String getCellToolTipValue(JTreeTable jTreeTable, int n, int n2) {
        if (n > 0) {
            Object object = jTreeTable.getValueAt(n2, n);
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        return null;
    }

    protected void setEditOperationResult(int n) {
        this.operationResult = n;
    }

    protected int getEditOperationResult() {
        return this.operationResult;
    }

    protected void setEditDescriptionText(String string) {
        this.editDescriptionText = string;
    }

    protected String getEditDescriptionText() {
        return this.editDescriptionText;
    }

    protected String getJTreeTableCellValue(int n) {
        Object object = this.namingTreeTable.getValueAt(n, 0);
        return object.toString();
    }
}

