/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.ddl;

import java.util.ArrayList;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabase;

public class CubeDDLSupport {
    private static final String BASE = "/oracle/olap/ddl/";
    private static final String ORACLE_11g_DDL = "/oracle/olap/ddl/Oracle11gDDL.properties";
    private static final String ORACLE_12c_DDL = "/oracle/olap/ddl/Oracle12cDDL.properties";

    public static String[] getBundles(DBObjectProvider dBObjectProvider) {
        boolean bl = CubeDDLSupport.isDatabaseCompatible12(dBObjectProvider);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ORACLE_11g_DDL);
        if (bl) {
            arrayList.add(ORACLE_12c_DDL);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getBundles(Class<? extends OracleDatabase> clazz) {
        String[] stringArray = new String[]{ORACLE_11g_DDL};
        return stringArray;
    }

    public static boolean isDatabaseCompatible12(DBObjectProvider dBObjectProvider) {
        boolean bl = false;
        String string = CubeDDLSupport.getDatabaseCompatibleLevel(dBObjectProvider);
        if (string.startsWith("12")) {
            bl = true;
        }
        return bl;
    }

    public static String getDatabaseCompatibleLevel(DBObjectProvider dBObjectProvider) {
        String string = null;
        if (dBObjectProvider instanceof OracleDatabase) {
            OracleDatabase oracleDatabase = (OracleDatabase)dBObjectProvider;
            string = oracleDatabase.getCompatibleLevel();
        }
        return string;
    }
}

