/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor.structure;

import java.awt.Component;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.plsql.structure.OutlineMenu;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.olap.dml.editor.structure.OLAPDMLOutlinePanel;
import oracle.olap.dml.editor.structure.OLAPDMLOutlineWindow;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLOutlineMenu
extends OutlineMenu {
    public static String QUICK_OUTLINE = Messages.getString((String)"QuickOutline");
    private static int cmdOutline = Ide.findOrCreateCmdID((String)"oracle.olap.editor.structure.OUTLINE");
    private IdeAction actionOutline = null;
    private static OLAPDMLOutlineMenu _instance;

    public static OLAPDMLOutlineMenu getInstance() {
        if (_instance == null) {
            _instance = new OLAPDMLOutlineMenu();
        }
        return _instance;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        OLAPDMLOutlineWindow oLAPDMLOutlineWindow = OLAPDMLOutlineWindow.getInstance();
        DockUtil.showDockableWindow((DockableView)oLAPDMLOutlineWindow);
        View view = context.getView();
        ((OLAPDMLOutlinePanel)((Object)oLAPDMLOutlineWindow.getGUI())).buildNewOutlineTree(view);
        return true;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context;
        Context context2 = context = contextMenu == null ? null : contextMenu.getContext();
        if (context == null) {
            return;
        }
        Node node = context.getNode();
        if (!(node instanceof OLAPDMLNode)) {
            return;
        }
        String string = node.getShortLabel();
        if (string != null && string.toLowerCase().startsWith("anon_block")) {
            return;
        }
        this.createAction();
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.actionOutline));
    }

    private void createAction() {
        if (this.actionOutline == null) {
            this.actionOutline = IdeAction.findOrCreate((int)cmdOutline, null, (String)QUICK_OUTLINE, null, null, null, null, (boolean)true);
            this.actionOutline.addController((Controller)this);
        }
    }

    public static void init() {
        if (!RaptorExtensionConstants.isStandAlone()) {
            return;
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)OLAPDMLOutlineMenu.getInstance());
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
    }

    private void initAction() {
        String string = QUICK_OUTLINE;
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionOutline == null) {
            this.actionOutline = IdeAction.findOrCreate((int)cmdOutline, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this.actionOutline.setEnabled(true);
        }
        this.actionOutline.addController((Controller)this);
        this.actionOutline.setEnabled(true);
    }
}

