/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.parser;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;
import oracle.olap.dml.parser.OlapEarley;

public class UnitTest {
    static int testNo = 0;
    static boolean unitTestIsOK = true;
    private static int output = -1;
    private static int assertion = -1;
    private static int query = -1;
    private static int comment = -1;

    public static void main(String[] stringArray) throws Exception {
        Set<RuleTuple> set = UnitTest.getRules();
        Earley earley = new Earley(set){

            protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                LexerToken lexerToken = list.get(n);
                return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
            }
        };
        output = (Integer)earley.symbolIndexes.get("output");
        assertion = (Integer)earley.symbolIndexes.get("assertion");
        query = (Integer)earley.symbolIndexes.get("query");
        comment = (Integer)earley.symbolIndexes.get("comment");
        String string = Service.readFile(UnitTest.class, (String)"unit.test");
        List list = LexerToken.parse((String)string);
        Object var5_5 = null;
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(list, (Matriceable)matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)earley, (Matrix)matrix);
        if (syntaxError != null) {
            if (var5_5 != null) {
                var5_5.draw((Matriceable)matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ",");
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        UnitTest.atest(parseNode, list, string);
        if (unitTestIsOK) {
            System.out.println("*** ALL TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> ");
        }
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String string = Service.readFile(UnitTest.class, (String)"unitTest.grammar");
        List list = LexerToken.parse((String)string);
        ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
        return treeSet;
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            UnitTest.assertion(parseNode, list, string);
            return;
        }
        if (parseNode.contains(output)) {
            Iterator iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = (ParseNode)iterator.next();
                Boolean bl = UnitTest.query(parseNode2, list, string);
                System.out.println("TEST#" + testNo++ + ":  ---> ");
                if (bl == null) {
                    System.out.println("undefined");
                } else {
                    System.out.println(bl);
                }
                return;
            }
            return;
        }
        if (parseNode.contains(comment)) {
            UnitTest.comment(parseNode, list, string);
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            UnitTest.atest(parseNode3, list, string);
        }
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        System.out.println(string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end - 1));
        return null;
    }

    private static boolean query(ParseNode parseNode, List<LexerToken> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UnitTest.sql_fragment(parseNode, list, string));
        OlapEarley olapEarley = OlapEarley.getInstance();
        return olapEarley.recognize(stringBuilder.toString());
    }

    private static String sql_fragment(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.from + 1 == parseNode.to) {
            String string2 = list.get((int)parseNode.from).content;
            if (string2.charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return " " + string2 + " ";
        }
        Object object = "";
        for (ParseNode parseNode2 : parseNode.children()) {
            object = (String)object + " " + UnitTest.sql_fragment(parseNode2, list, string);
        }
        return object;
    }

    private static ParseNode assertion(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        Boolean bl = null;
        Boolean bl2 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(query)) {
                bl = UnitTest.query(parseNode2, list, string);
                continue;
            }
            if (parseNode2.from + 1 != parseNode2.to) continue;
            if ("-".equals(parseNode2.content(list))) {
                bl2 = false;
            }
            if (!"+".equals(parseNode2.content(list))) continue;
            bl2 = true;
        }
        if (bl2 == null || bl == null) {
            throw new AssertionError((Object)"Undefined cmp or output");
        }
        boolean bl3 = bl2.equals(bl);
        if (!bl3) {
            unitTestIsOK = false;
        }
        System.out.println("TEST#" + testNo++ + ":  ---> " + bl3);
        return null;
    }
}

