/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.javatools.util.Pair;
import oracle.olap.graph.Vertex;

public class DirectedGraph<T> {
    private LinkedList<Vertex<T>> vertexes = new LinkedList();
    private List<Pair<Integer, Integer>> edges = new ArrayList<Pair<Integer, Integer>>();
    private int[][] adjacencyMatrix;
    private int vertexCount;
    private Vertex<T>[] vertexList;
    private Vertex<T>[] sortedArray;

    public DirectedGraph(List<List<T>> list) {
        this();
        for (List<T> list2 : list) {
            Object var4_4 = null;
            int n = -1;
            for (T t : list2) {
                int n2 = this.findVertex(t);
                if (n2 == -1) {
                    this.addVertex(t);
                    n2 = this.findVertex(t);
                }
                if (n != -1) {
                    this.addEdge(n, n2);
                }
                var4_4 = t;
                n = n2;
            }
        }
    }

    public DirectedGraph() {
    }

    public int getSize() {
        return this.vertexes.size();
    }

    public Vertex<T>[] getVertexes() {
        return this.vertexList;
    }

    public void addVertex(T t) {
        Vertex<T> vertex = new Vertex<T>(t);
        this.vertexes.add(vertex);
    }

    public int findVertex(T t) {
        for (int i = 0; i < this.vertexes.size(); ++i) {
            if (!this.vertexes.get(i).getData().equals(t)) continue;
            return i;
        }
        return -1;
    }

    public void addEdge(int n, int n2) {
        this.edges.add((Pair<Integer, Integer>)new Pair((Object)n, (Object)n2));
    }

    public Vertex<T>[] topologicalSort() {
        int n = this.vertexes.size();
        this.vertexList = new Vertex[n];
        this.vertexCount = 0;
        for (Vertex vertex : this.vertexes) {
            this.vertexList[this.vertexCount++] = vertex;
        }
        this.adjacencyMatrix = new int[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.adjacencyMatrix[i][j] = 0;
            }
        }
        this.sortedArray = new Vertex[n];
        for (Pair<Integer, Integer> pair : this.edges) {
            this.adjacencyMatrix[((Integer)pair.getFirst()).intValue()][((Integer)pair.getSecond()).intValue()] = 1;
        }
        int n2 = this.vertexCount;
        while (this.vertexCount > 0) {
            int n3 = this.noSuccessors();
            if (n3 == -1) {
                this.vertexCount = n2;
                return null;
            }
            this.sortedArray[this.vertexCount - 1] = this.vertexList[n3];
            this.deleteVertex(n3);
        }
        this.vertexCount = n2;
        return this.sortedArray;
    }

    public int noSuccessors() {
        for (int i = 0; i < this.vertexCount; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.vertexCount; ++j) {
                if (this.adjacencyMatrix[i][j] <= 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return i;
        }
        return -1;
    }

    private void deleteVertex(int n) {
        if (n != this.vertexCount - 1) {
            int n2;
            for (n2 = n; n2 < this.vertexCount - 1; ++n2) {
                this.vertexList[n2] = this.vertexList[n2 + 1];
            }
            for (n2 = n; n2 < this.vertexCount - 1; ++n2) {
                this.moveRowUp(n2, this.vertexCount);
            }
            for (n2 = n; n2 < this.vertexCount - 1; ++n2) {
                this.moveColLeft(n2, this.vertexCount - 1);
            }
        }
        --this.vertexCount;
    }

    private void moveRowUp(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.adjacencyMatrix[n][i] = this.adjacencyMatrix[n + 1][i];
        }
    }

    private void moveColLeft(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.adjacencyMatrix[i][n] = this.adjacencyMatrix[i][n + 1];
        }
    }
}

