/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.awt.Dialog;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.olap.app.actions.ActionHandler;
import oracle.olap.app.context.Context;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.Tree;
import oracle.olap.app.tree.model.VirtualTreeModel;
import oracle.olap.hierarchyviewer.HierarchyEditorDialog;
import oracle.olap.hierarchyviewer.NewMemberDialog;
import oracle.olap.hierarchyviewer.SetEquationDialog;

public class NodeAction
implements ActionHandler {
    @Override
    public void handle(Object object, Context context) {
        Object object2 = context.getProperty("DIALOG");
        HierarchyEditorDialog hierarchyEditorDialog = null;
        if (object2 instanceof JDialog) {
            hierarchyEditorDialog = (HierarchyEditorDialog)object2;
        }
        if (context.getSource() instanceof JTree) {
            String string;
            Object object3;
            Object object4;
            JTree jTree = (JTree)context.getSource();
            TreePath treePath = jTree.getSelectionPath();
            TreeModel treeModel = jTree.getModel();
            VirtualTreeModel virtualTreeModel = null;
            if (treeModel instanceof VirtualTreeModel) {
                virtualTreeModel = (VirtualTreeModel)treeModel;
            }
            if (treePath == null) {
                return;
            }
            Object object5 = treePath.getLastPathComponent();
            Node node = null;
            if (object5 instanceof Node) {
                node = (Node)object5;
            }
            Object object6 = node.getUserObject();
            HierarchyNodeData hierarchyNodeData = null;
            if (object6 instanceof HierarchyNodeData) {
                hierarchyNodeData = (HierarchyNodeData)node.getUserObject();
            }
            Object object7 = context.getProperty("TREEDATA");
            Tree tree = null;
            if (object7 instanceof Tree) {
                tree = (Tree)object7;
            }
            if (context.getAction().equals("insert")) {
                object4 = node.toString();
                object3 = tree.getLevelName(node.getDepth() + 1);
                string = tree.getLevelName(0);
                NewMemberDialog newMemberDialog = new NewMemberDialog(hierarchyEditorDialog, (String)object4, (String)object3, string);
                newMemberDialog.setVisible(true);
                if (!newMemberDialog.isCancel()) {
                    DefaultNode defaultNode = (DefaultNode)node;
                    if (newMemberDialog.isRoot()) {
                        defaultNode = null;
                    }
                    HierarchyNodeData hierarchyNodeData2 = new HierarchyNodeData(tree);
                    hierarchyNodeData2.desc = hierarchyNodeData2.dimKey = newMemberDialog.getMember();
                    if (virtualTreeModel != null) {
                        Node node2 = virtualTreeModel.newNode(defaultNode, hierarchyNodeData2);
                        jTree.setRootVisible(!virtualTreeModel.isMultipleRoot());
                        TreePath treePath2 = treePath.pathByAddingChild(node2);
                        jTree.setSelectionPath(treePath2);
                    }
                }
                jTree.updateUI();
            }
            if (context.getAction().equals("remove")) {
                object4 = (DefaultNode)node;
                object3 = treePath.getParentPath();
                virtualTreeModel.removeNodeOnly((Node)object4);
                jTree.setRootVisible(!virtualTreeModel.isMultipleRoot());
                jTree.setSelectionPath((TreePath)object3);
                jTree.updateUI();
                jTree.treeDidChange();
            }
            if (context.getAction().equals("removeall")) {
                object4 = (DefaultNode)node;
                object3 = treePath.getParentPath();
                tree.removeAllNode((Node)object4);
                jTree.setSelectionPath((TreePath)object3);
                jTree.updateUI();
                jTree.treeDidChange();
            }
            if (context.getAction().equals("setequation")) {
                object4 = node.toString();
                object3 = new SetEquationDialog(hierarchyEditorDialog, (String)object4);
                ((Dialog)object3).setVisible(true);
                if (!((SetEquationDialog)object3).isCancel()) {
                    string = ((SetEquationDialog)object3).getEquation();
                    hierarchyNodeData.setProperty("equation", string);
                }
            }
        }
    }
}

