/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.insight.SynonymsCache;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.javatools.util.Pair;
import oracle.olap.map.Projection;

public class SQLExtractor {
    static int where_clause = -1;
    static int subquery = -1;
    static int scalar_subquery_expression = -1;
    static int query_table_expression = -1;
    static int table_reference = -1;
    static int as = -1;
    static int select_term = -1;
    static int expr = -1;
    static int identifier = -1;
    static int user_defined_function = -1;
    static int aggregate_function = -1;
    static int column = -1;
    static int dot = -1;
    static int star = -1;
    static int mult_op = -1;
    static int select = -1;
    static int select_list = -1;
    static int query_block = -1;
    static int subquery_factoring_clause = -1;
    private ParseNode root;
    private List<LexerToken> _src;
    private SynonymsCache synonyms = null;
    private Map<ParseNode, String> _tables;
    private Map<String, String> _tblAliases;

    public SQLExtractor(String string) {
        this._src = LexerToken.parse((String)string);
        this.root = this.parse();
    }

    private ParseNode parse() {
        SqlEarley sqlEarley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)sqlEarley);
        sqlEarley.parse(this._src, (Matriceable)matrix);
        return sqlEarley.forest(this._src, matrix);
    }

    public String getTokenForColumn(Projection projection) {
        return projection.getColExpr().content(this._src);
    }

    public Collection<String> getTableNames() {
        Map<ParseNode, String> map = this.tblNames(this.root, this._src);
        return map.values();
    }

    private List<ParseNode> getTableNodes(ParseNode parseNode) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(table_reference) && parseNode2.to - parseNode2.from < 5) {
                linkedList.add(parseNode2);
                continue;
            }
            if (parseNode2.contains(where_clause)) continue;
            linkedList.addAll(this.getTableNodes(parseNode2));
        }
        return linkedList;
    }

    private Map<ParseNode, String> tblNames(ParseNode parseNode, List<LexerToken> list) {
        TreeMap<ParseNode, String> treeMap = new TreeMap<ParseNode, String>();
        Iterator<ParseNode> iterator = this.getTableNodes(parseNode).iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Object object;
            ParseNode parseNode2;
            ParseNode parseNode3 = parseNode2 = iterator.next();
            String string3 = parseNode3.content(list);
            Pair<ParseNode, ParseNode> pair = SQLExtractor.findTableAlias(parseNode3);
            if (pair != null) {
                ParseNode parseNode4;
                string3 = ((ParseNode)pair.getSecond()).content(list);
                parseNode3 = (ParseNode)pair.getFirst();
                object = parseNode.descendant(parseNode3.from, parseNode3.to, scalar_subquery_expression);
                string2 = parseNode.descendant(parseNode3.from, parseNode3.to, query_table_expression);
                string = null;
                if (object == null && string2 != null) {
                    string = string2;
                } else if (object != null && string2 == null) {
                    string = object;
                } else if (object != null && string2 != null && object.from <= ((ParseNode)string2).from) {
                    string = string2;
                } else if (object != null && string2 != null && object.from >= ((ParseNode)string2).from) {
                    string = object;
                }
                if (string != null && (parseNode4 = parseNode.parent(((ParseNode)string).from, ((ParseNode)string).to)).contains(table_reference)) {
                    for (ParseNode parseNode5 : parseNode4.children()) {
                        if (!parseNode5.contains(identifier)) continue;
                        parseNode3 = parseNode5;
                    }
                }
            }
            if (this.synonyms != null) {
                object = null;
                string2 = string3;
                if (string2.indexOf(46) > 0) {
                    object = string2.substring(0, string2.indexOf(46));
                    string2 = string2.substring(string2.indexOf(46) + 1);
                }
                if ((string = this.synonyms.getTable(object, string2)) != null) {
                    string3 = string;
                }
            }
            treeMap.put(parseNode3, string3);
        }
        return treeMap;
    }

    private static Pair<ParseNode, ParseNode> findTableAlias(ParseNode parseNode) {
        if (!parseNode.contains(table_reference)) {
            return null;
        }
        Pair pair = null;
        if (parseNode.children().size() == 0 || parseNode.children().size() == 3) {
            pair = new Pair((Object)parseNode, (Object)parseNode);
        } else if (parseNode.children().size() == 2) {
            ParseNode parseNode2 = null;
            ParseNode parseNode3 = null;
            for (ParseNode parseNode4 : parseNode.children()) {
                if (parseNode4.contains(query_table_expression)) {
                    parseNode3 = parseNode4;
                    continue;
                }
                if (!parseNode4.contains(identifier)) continue;
                parseNode2 = parseNode4;
            }
            if (parseNode2 != null && parseNode3 != null) {
                pair = new Pair(parseNode2, parseNode3);
            }
        }
        return pair;
    }

    public ArrayList<Projection> getProjections(boolean bl) {
        this._tables = this.tblNames(this.root, this._src);
        ParseNode parseNode = SQLExtractor.getSelectList(SQLExtractor.getMainQueryBlock(this.root));
        if (parseNode == null) {
            return null;
        }
        ArrayList<Projection> arrayList = this.extractColumns(parseNode, bl);
        return arrayList;
    }

    private static ParseNode getSelectList(ParseNode parseNode) {
        if (parseNode == null) {
            return null;
        }
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (!parseNode2.contains(select_list)) continue;
            return parseNode2;
        }
        return null;
    }

    private ArrayList<Projection> extractColumns(ParseNode parseNode, boolean bl) {
        ArrayList<Projection> arrayList = new ArrayList<Projection>();
        if (this.starPosition(parseNode, this._src) > 0) {
            bl = false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ParseNode parseNode2 : this.getProjectionNodes(parseNode)) {
            String string;
            Set set = parseNode2.children();
            if (set.size() == 0) {
                string = this._src.get((int)parseNode2.from).content;
                arrayList.add(new Projection(parseNode2, string));
                if (hashSet.contains(string)) {
                    bl = false;
                }
                hashSet.add(string);
                continue;
            }
            if (parseNode2.contains(expr)) {
                arrayList.add(new Projection(parseNode2, null));
                bl = false;
                continue;
            }
            string = null;
            String string2 = null;
            int n = -1;
            for (ParseNode parseNode3 : set) {
                if (++n == 0) {
                    if (parseNode3.contains(expr)) {
                        string = parseNode3;
                    } else if (parseNode2.contains(select_term)) {
                        string = parseNode2;
                        bl = false;
                        break;
                    }
                }
                if (n != 1) continue;
                string2 = this._src.get((int)(parseNode3.to - 1)).content;
                break;
            }
            if (string2 == null || hashSet.contains(string2)) {
                bl = false;
            }
            arrayList.add(new Projection((ParseNode)string, string2));
            hashSet.add(string2);
        }
        return arrayList;
    }

    public static ParseNode getMainQueryBlock(ParseNode parseNode) {
        if (parseNode == null) {
            return null;
        }
        if (parseNode.contains(query_block)) {
            return parseNode;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(subquery) && !parseNode2.contains(query_block)) continue;
            return SQLExtractor.getMainQueryBlock(parseNode2);
        }
        return null;
    }

    public List<ParseNode> getProjectionNodes(ParseNode parseNode) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        if (parseNode.contains(select_term) || parseNode.contains(select_list) && parseNode.contains(star)) {
            String string = this.getTokens(parseNode);
            System.out.println("   #####" + string + "####");
            parseNode.printTree();
            linkedList.add(parseNode);
            return linkedList;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            linkedList.addAll(this.getProjectionNodes(parseNode2));
        }
        return linkedList;
    }

    public List<ParseNode> getColumnNodes(ParseNode parseNode) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        if (parseNode.contains(column)) {
            String string = this.getTokens(parseNode);
            System.out.println("   #####" + string + "####");
            if (string.equals("sum") || string.equals("sales") || string.equals("calendar_quarter_timespan")) {
                parseNode.printTree();
            }
            linkedList.add(parseNode);
            return linkedList;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            linkedList.addAll(this.getColumnNodes(parseNode2));
        }
        return linkedList;
    }

    public List<String> getColumns(ParseNode parseNode) {
        LinkedList<String> linkedList = new LinkedList<String>();
        List<ParseNode> list = this.getColumnNodes(parseNode);
        if (list.size() == 0) {
            String[] stringArray;
            Object object = parseNode.content(this._src);
            if (((String)object).startsWith("SUM(")) {
                object = ((String)object).substring(4, ((String)object).length());
            }
            if (((String)object).endsWith(")")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if ((stringArray = ((String)object).split("\\.")).length == 2) {
                linkedList.add(stringArray[1]);
            }
        }
        for (ParseNode parseNode2 : list) {
            linkedList.add(parseNode2.content(this._src));
        }
        return linkedList;
    }

    public boolean isAggregate(ParseNode parseNode) {
        if (parseNode.contains(aggregate_function)) {
            return true;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!this.isAggregate(parseNode2)) continue;
            return true;
        }
        return false;
    }

    public List<ParseNode> getWhereNodes() {
        return this.getWhereNodes(this.root);
    }

    public List<ParseNode> getWhereNodes(ParseNode parseNode) {
        LinkedList<ParseNode> linkedList = new LinkedList<ParseNode>();
        if (parseNode.contains(where_clause)) {
            String string = this.getTokens(parseNode);
            System.out.println("   #####" + string + "####");
            parseNode.printTree();
            linkedList.add(parseNode);
            return linkedList;
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            linkedList.addAll(this.getWhereNodes(parseNode2));
        }
        return linkedList;
    }

    public String getTokens(ParseNode parseNode) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (int i = parseNode.from; i < parseNode.to; ++i) {
                stringBuilder.append(this._src.get((int)i).content + "!");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("src out of sync with parse tree?:" + indexOutOfBoundsException.getMessage());
        }
        return stringBuilder.toString();
    }

    public int starPosition(ParseNode parseNode, List<LexerToken> list) {
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (parseNode2.from + 1 != parseNode2.to || !"*".equals(list.get((int)parseNode2.from).content) || parseNode2.contains(mult_op)) continue;
            return parseNode2.from;
        }
        return -1;
    }

    void printTokens() {
        System.out.println("%%%%%%%%%%%%%%");
        for (LexerToken lexerToken : this._src) {
            lexerToken.print();
        }
        System.out.println("%%%%%%%%%%%%%%");
    }

    public static void main(String[] stringArray) {
        String string = "select empname, deptname dnum, sum(sales) from emp,dept group by channel_id";
        string = "SELECT \n  channel_dim.channel_id,\n  channel_dsc || 'foo',\n  total_channel_id,\n  total_channel_dsc,\n  month_id,\n  month_dsc,\n  month_end_date,\n  month_timespan,\n  calendar_quarter_id,\n  calendar_quarter_dsc,\n  calendar_quarter_end_date,\n  calendar_quarter_timespan,\n  sum(sales)\nFROM units_fact,\n  channel_dim,\n  time_dim\nWHERE channel_dim.channel_id = units_fact.channel_id\nAND time_dim.month_id        = units_fact.time_id\nAND calendar_quarter_dsc     = 'Q1-00'\nGROUP BY channel_dim.channel_id,\n  channel_dsc,\n  total_channel_id,\n  total_channel_dsc,\n  month_id,\n  month_dsc,\n  month_end_date,\n  month_timespan,\n  calendar_quarter_id,\n  calendar_quarter_dsc,\n  calendar_quarter_end_date,\n  calendar_quarter_timespan";
        string = "select sal * 1.1 from emp";
        string = "select ename, emp.sal from emp";
        try {
            SQLExtractor sQLExtractor = new SQLExtractor(string);
            Collection<String> collection = sQLExtractor.getTableNames();
            System.out.println(collection);
            ArrayList<Projection> arrayList = sQLExtractor.getProjections(true);
            System.out.println("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
            for (Projection projection : arrayList) {
                Object object = "";
                for (String string2 : sQLExtractor.getColumns(projection.getColExpr())) {
                    object = (String)object + string2 + ",";
                }
                System.out.println((String)object + " expr=" + sQLExtractor.getTokenForColumn(projection) + " alias=" + projection.getAlias());
                if (!sQLExtractor.isAggregate(projection.getColExpr())) continue;
                System.out.println("       is an aggregate");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        SqlEarley sqlEarley = SqlEarley.getInstance();
        where_clause = sqlEarley.getSymbol("where_clause");
        subquery = sqlEarley.getSymbol("subquery");
        scalar_subquery_expression = sqlEarley.getSymbol("scalar_subquery_expression");
        query_table_expression = sqlEarley.getSymbol("query_table_expression");
        table_reference = sqlEarley.getSymbol("table_reference");
        as = sqlEarley.getSymbol("'AS'");
        select_term = sqlEarley.getSymbol("select_term");
        expr = sqlEarley.getSymbol("expr");
        identifier = sqlEarley.getSymbol("identifier");
        user_defined_function = sqlEarley.getSymbol("user_defined_function");
        aggregate_function = sqlEarley.getSymbol("aggregate_function");
        column = sqlEarley.getSymbol("column");
        dot = sqlEarley.getSymbol("'.'");
        star = sqlEarley.getSymbol("'*'");
        mult_op = sqlEarley.getSymbol("mult_op");
        select = sqlEarley.getSymbol("select");
        select_list = sqlEarley.getSymbol("select_list");
        query_block = sqlEarley.getSymbol("query_block");
        subquery_factoring_clause = sqlEarley.getSymbol("subquery_factoring_clause");
    }
}

