/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.map.panels;

import java.awt.Color;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import oracle.javatools.util.ModelUtil;

public class SourceValidationController {
    private JComponent m_comp;
    private Popup m_pup;
    private int m_xOffset = 10;
    private int m_yOffset = 2;

    public SourceValidationController(JComponent jComponent) {
        this.m_comp = jComponent;
    }

    public void setXOffset(int n) {
        this.m_xOffset = n;
    }

    public void setyOffset(int n) {
        this.m_yOffset = n;
    }

    public void hidePopup() {
        this.m_comp.setBackground(new Color(255, 255, 255));
        this.m_comp.getAccessibleContext().setAccessibleDescription(null);
        if (this.m_pup != null) {
            this.m_pup.hide();
            this.m_pup = null;
        }
    }

    public void showError(String string) {
        if (ModelUtil.hasLength((String)string)) {
            Color color = new Color(255, 175, 175);
            this.m_comp.setBackground(color);
            this.showTooltip(string, color);
        } else {
            this.hidePopup();
        }
    }

    public void showTooltip(String string, Color color) {
        try {
            JToolTip jToolTip = new JToolTip();
            jToolTip.setComponent(this.m_comp);
            jToolTip.setTipText(string);
            jToolTip.setVisible(true);
            if (color != null) {
                jToolTip.setBackground(color);
            }
            jToolTip.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            Point point = this.m_comp.getLocationOnScreen();
            int n = (int)(point.getX() + this.m_comp.getBounds().getWidth()) + this.m_xOffset;
            int n2 = (int)point.getY() + this.m_yOffset;
            if (this.m_pup != null) {
                this.m_pup.hide();
            }
            this.m_pup = PopupFactory.getSharedInstance().getPopup(this.m_comp, jToolTip, n, n2);
            this.m_comp.getAccessibleContext().setAccessibleDescription(string);
            this.m_pup.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

