/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.data.DimensionMetadataContext;
import oracle.olap.security.DMLDataSecurityPanel;
import oracle.olap.security.DataSecurityPolicy;
import oracle.olap.security.GeneralDataSecurityPanel;
import oracle.olap.security.MemberSelectionPanel;
import oracle.olap.security.ORASUtil;
import oracle.olap.security.RealmConstraint;

public class DimensionDataSecurityPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(DimensionDataSecurityPanel.class.getName());
    private JDialog window;
    private final HelpProvider helpProvider;
    private DimensionMetadataContext dimensionMetadataContext;
    private List<DimensionHierarchy> hierarchies;
    private GeneralDataSecurityPanel generalPanel;
    private MemberSelectionPanel memberSelectionPanel;
    private DMLDataSecurityPanel dmlPanel;
    private JTabbedPane tabPanel;
    private DataSecurityPolicy policy;

    public DimensionDataSecurityPanel(JDialog jDialog, HelpProvider helpProvider, Connection connection, DimensionMetadataContext dimensionMetadataContext, List<DimensionHierarchy> list) {
        this.window = jDialog;
        this.helpProvider = helpProvider;
        this.dimensionMetadataContext = dimensionMetadataContext;
        this.hierarchies = list;
        ORASUtil oRASUtil = ORASUtil.getInstance();
        String string = dimensionMetadataContext.getName();
        String string2 = oRASUtil.createDSPName(string);
        this.policy = oRASUtil.getDSPDO(connection, string2);
        this.generalPanel = new GeneralDataSecurityPanel(connection, jDialog, this);
        this.memberSelectionPanel = new MemberSelectionPanel(dimensionMetadataContext);
        this.dmlPanel = new DMLDataSecurityPanel();
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.tabPanel = new JTabbedPane(1);
        this.tabPanel.add(OLAPArb.getString("DATA_SECURITY_PANEL_GENERAL"), (Component)((Object)this.generalPanel));
        this.tabPanel.add(OLAPArb.getString("DATA_SECURITY_PANEL_GENERAL_MEMBER_SELECTION"), (Component)((Object)this.memberSelectionPanel));
        this.tabPanel.add(OLAPArb.getString("DATA_SECURITY_PANEL_GENERAL_DML"), (Component)((Object)this.dmlPanel));
        this.tabPanel.setEnabledAt(2, false);
        this.add((Component)this.tabPanel, "Center");
    }

    public void enableMemberSelection(boolean bl) {
        this.tabPanel.setEnabledAt(1, bl);
        this.tabPanel.setEnabledAt(2, !bl);
    }

    public DataSecurityPolicy saveData(RealmConstraint realmConstraint) {
        realmConstraint.setPolicy(this.policy.getName());
        this.generalPanel.setData(realmConstraint);
        this.memberSelectionPanel.setData(realmConstraint);
        return this.policy;
    }
}

