/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.documentation;

import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import oracle.olap.syntaxbuilder.documentation.DocumentationRenderer;
import oracle.olap.syntaxbuilder.specification.Spec;

public class JTextPaneDocRenderer
implements DocumentationRenderer {
    private JTextPane description;
    private Spec spec;
    private JScrollPane component;
    private String key;
    private static Logger LOG = Logger.getLogger(JTextPaneDocRenderer.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JTextPaneDocRenderer(Spec spec) {
        this.spec = spec;
        this.description = new JTextPane();
        this.description.setContentType("text/html");
        Font font = UIManager.getFont("Label.font");
        String string = String.format("body { font-family: %s}", font.getFamily());
        ((HTMLDocument)this.description.getDocument()).getStyleSheet().addRule(string);
        StyleSheet styleSheet = ((HTMLDocument)this.description.getDocument()).getStyleSheet();
        InputStreamReader inputStreamReader = null;
        try {
            InputStream inputStream = JTextPaneDocRenderer.class.getResourceAsStream("documentation.css");
            inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                styleSheet.addRule(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Exception exception) {}
        }
        this.description.setEditable(false);
        this.description.setBackground(UIManager.getColor("Label.background"));
        this.component = new JScrollPane(this.description);
    }

    @Override
    public void setKey(String string) {
        String string2;
        if (string == null) {
            this.description.setText(null);
            this.key = null;
        }
        if ((string2 = this.spec.getDocumentation(string)) != null) {
            try {
                this.description.setPage(string2);
                this.description.setCaretPosition(0);
                this.key = string;
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Unable to load doc URL", iOException);
            }
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }
}

