/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.qdr;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.olap.app.templates.templatelist.QDRData;

public class QDRTableModel
extends AbstractTableModel {
    static final int DIMENSION = 0;
    static final int MEMBER = 1;
    private transient Vector<QDRData> qdr;
    static final String[] COLUMNS = new String[]{"DIMENSION", "MEMBER"};

    QDRTableModel(Vector<QDRData> vector) {
        this.qdr = vector;
    }

    @Override
    public int getRowCount() {
        if (this.qdr != null) {
            return this.qdr.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.qdr.get(n).getDimension();
        }
        if (n2 == 1) {
            String string = this.qdr.get(n).getMemberDescription();
            if (string == null) {
                string = this.qdr.get(n).getMemberKey();
            }
            return string;
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 1) {
            return;
        }
        boolean bl = false;
        if (object == null) {
            bl = true;
        } else if (object instanceof String) {
            if (((String)object).trim().length() == 0) {
                bl = true;
            } else {
                this.qdr.get(n).setMemberDescription(object.toString());
                this.qdr.get(n).setMemberKey(object.toString());
            }
        } else if (object instanceof QDRData) {
            this.qdr.get(n).setData((QDRData)object);
        }
        if (bl) {
            this.qdr.get(n).setMemberKey(null);
            this.qdr.get(n).setMemberDescription(null);
        }
    }

    public void setRowValue(QDRData qDRData, int n) {
        this.qdr.insertElementAt(qDRData, n);
        this.qdr.remove(n + 1);
        this.fireTableDataChanged();
    }

    public QDRData getRowValue(int n) {
        QDRData qDRData = null;
        qDRData = this.qdr.get(n);
        return qDRData;
    }
}

