/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen.ui.wizard;

import java.awt.Component;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.cubetemplate.NamespaceValidator;
import oracle.olap.db.AWListRunnable;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.timegen.TimeDimensionGeneratorDDL;
import oracle.olap.timegen.TimeTableGenerator;
import oracle.olap.timegen.TimeTableGeneratorXML;
import oracle.olap.timegen.model.TimeGenAttribute;
import oracle.olap.timegen.model.TimeGenLevel;
import oracle.olap.timegen.timexml.Format;
import oracle.olap.timegen.timexml.Time;
import oracle.olap.timegen.timexml.TimeColumn;
import oracle.olap.timegen.timexml.TimeLevel;
import oracle.olap.timegen.ui.wizard.TimeGenAttrsPanel;
import oracle.olap.timegen.ui.wizard.TimeGenGeneralPanel;
import oracle.olap.timegen.ui.wizard.TimeGenLevelsPanel;
import oracle.olap.timegen.ui.wizard.TimeGenSummaryPanel;

public class TimeGenWizMain {
    static final String STATE_LEVELS = "StateLevels";
    static final String TRANSITION_LEVELS = "LEVELS";
    static final String STATE_ATTRIBUTES = "StateAttributes";
    static final String TRANSITION_ATTRIBUTES = "ATTRIBUTES";
    static final String STATE_SUMMARY = "StateSummary";
    static final String TRANSITION_SUMMARY = "SUMMARY";
    public static final String DBOBJECT = "DBOBJECT";
    public static final String DBOBJECTPROVIDER = "DBOBJECTPROVIDER";
    public static final String DATABASE = "DATABASE";
    public static final String SCHEMA = "SCHEMA";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String START_DATE = "START_DATE";
    public static final String NUMBER_OF_YEARS = "NUMBER_OF_YEARS";
    public static final String DIMENSION_NAME = "DIMENSION_NAME";
    public static final String HIERARCHY_NAME = "HIERARCHY_NAME";
    public static final String LEVELS = "LEVELS";
    public static final String CREATE_DIMENSION = "CREATE_DIMENSION";
    public static final String TIME_DIMENSIONS = "TIME_DIMENSIONS";
    public static final String ANALYTIC_WORKSPACES = "ANALYTIC_WORKSPACES";
    public static final String ANALYTIC_WORKSPACE = "ANALYTIC_WORKSPACE";
    public static final String SHOW_CREATE_DIMENSION_UI = "SHOW_CREATE_DIMENSION_UI";
    private static final String DEFAULT_DIMENSION_NAME = "TIME";
    private static final String DEFAULT_TABLE_NAME = "TIME_SOURCE";
    private static final String DEFAULT_HIERARCHY_NAME = "CALENDAR";
    private static TimeGenWizMain INSTANCE;
    private static final Logger LOGGER;
    private Time time;
    private boolean success;
    private boolean refreshTree = false;

    private TimeGenWizMain() {
    }

    public static TimeGenWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TimeGenWizMain();
        }
        return INSTANCE;
    }

    public void launchWizard(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getSchemaName();
        oracle.javatools.db.Database database = dBObject.getDatabase();
        this._launchWizard(connection, string, dBObject, (DBObjectProvider)database);
    }

    public void launchWizard(Connection connection, String string, DBObjectProvider dBObjectProvider) {
        this._launchWizard(connection, string, null, dBObjectProvider);
    }

    private void _launchWizard(Connection connection, String string, DBObject dBObject, DBObjectProvider dBObjectProvider) {
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        FSM fSM = TimeGenWizMain.getFSM();
        Namespace namespace = new Namespace();
        try {
            DatabaseImpl databaseImpl = new DatabaseImpl();
            databaseImpl.setConnection(connection);
            namespace.put(DBOBJECT, (Object)dBObject);
            namespace.put(DBOBJECTPROVIDER, (Object)dBObjectProvider);
            namespace.put(DATABASE, (Object)databaseImpl);
            namespace.put(SCHEMA, (Object)string);
            this.loadTimeXMLDocument();
            Schema schema = dBObjectProvider.getSchema(string);
            String string2 = dBObjectProvider.getUniqueName("TABLE", (oracle.javatools.db.DBObject)schema, DEFAULT_TABLE_NAME);
            if (string2 == null) {
                namespace.put(TABLE_NAME, (Object)DEFAULT_TABLE_NAME);
            } else {
                namespace.put(TABLE_NAME, (Object)string2);
            }
            namespace.put(DIMENSION_NAME, (Object)DEFAULT_DIMENSION_NAME);
            namespace.put(HIERARCHY_NAME, (Object)DEFAULT_HIERARCHY_NAME);
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(1);
            int n2 = 0;
            int n3 = 1;
            calendar.set(n, n2, n3);
            Date date = calendar.getTime();
            namespace.put(START_DATE, (Object)date);
            namespace.put(NUMBER_OF_YEARS, (Object)1);
            List<TimeGenLevel> list = this.getLevelList();
            namespace.put("LEVELS", list);
            boolean bl = false;
            namespace.put(SHOW_CREATE_DIMENSION_UI, (Object)bl);
            namespace.put(CREATE_DIMENSION, (Object)bl);
            List<Object> list2 = new ArrayList<String>();
            String string3 = null;
            List<Object> list3 = new ArrayList();
            if (bl) {
                string3 = CubeAWUtil.getAnalyticWorkspaceName(dBObject);
                if (string3 != null) {
                    list2.add(string3);
                } else {
                    list2 = this.getAnalyticWorkspaces(connection, string);
                }
                list3 = TimeGenWizMain.getTimeDimensions(databaseImpl, string, (String)list2.get(0));
                string3 = (String)list2.get(0);
            }
            namespace.put(ANALYTIC_WORKSPACES, list2);
            namespace.put(ANALYTIC_WORKSPACE, (Object)string3);
            namespace.put(TIME_DIMENSIONS, list3);
            FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
            String string4 = OLAPArb.get("TIME_GEN_WIZARD_CREATE_TIME_DIMENSION");
            fSMWizard.setWizardTitle(string4);
            fSMWizard.setRoadmapVisible(true);
            fSMWizard.setDefaultWizardSize(1);
            fSMWizard.addCommitListener(new CommitListener(){

                public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
                }

                public void commit(ApplyEvent applyEvent) throws TraversalException {
                }

                public void rollback(ApplyEvent applyEvent) {
                }

                public void cancel(ApplyEvent applyEvent) {
                }
            });
            WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
            if (WizardLauncher.runDialog((JDialog)wizardDialog)) {
                Object object;
                Object object2;
                boolean bl2;
                boolean bl3 = true;
                String string5 = (String)namespace.get(TABLE_NAME);
                String string6 = "select count(*) from user_tables where table_name = :TABLENAME";
                String string7 = "0";
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TABLENAME", string5);
                string7 = dBUtil.executeOracleReturnOneCol(string6, hashMap);
                boolean bl4 = string7.equalsIgnoreCase("1");
                if (bl4 && (bl2 = JOptionPane.showConfirmDialog((Component)wizardDialog, object2 = OLAPArb.format("TIME_GEN_WIZARD_TABLE_EXISTS_CONFIRM_MSG", string5), (String)(object = OLAPArb.get("TIME_GEN_WIZARD_CREATE_TIME_TABLE")), 0))) {
                    bl3 = false;
                }
                if (bl3) {
                    object2 = null;
                    object = null;
                    object2 = new TimeTableGeneratorXML(this.time, namespace);
                    object = new TimeDimensionGeneratorDDL();
                    bl2 = (Boolean)namespace.get(CREATE_DIMENSION);
                    this.success = false;
                    boolean bl5 = bl2;
                    final Namespace namespace2 = namespace;
                    Object object3 = object2;
                    Object object4 = object;
                    DatabaseImpl databaseImpl2 = databaseImpl;
                    final String string8 = string5;
                    RaptorTask raptorTask = new RaptorTask(OLAPArb.get("TIME_GEN_WIZARD_CREATING_TIME"), true, IRaptorTaskRunMode.MODAL, (TimeTableGenerator)object3, databaseImpl2, bl5, namespace2, (TimeDimensionGeneratorDDL)object4){
                        final /* synthetic */ TimeTableGenerator val$tg2;
                        final /* synthetic */ Database val$database2;
                        final /* synthetic */ boolean val$createTimeDim2;
                        final /* synthetic */ Namespace val$initialData2;
                        final /* synthetic */ TimeDimensionGeneratorDDL val$tdg2;
                        {
                            this.val$tg2 = timeTableGenerator;
                            this.val$database2 = database;
                            this.val$createTimeDim2 = bl2;
                            this.val$initialData2 = namespace;
                            this.val$tdg2 = timeDimensionGeneratorDDL;
                            super(string, bl, iRaptorTaskRunMode);
                        }

                        protected Object doWork() throws TaskException {
                            Boolean bl = Boolean.TRUE;
                            try {
                                this.setMessage(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_TABLE", string8));
                                this.val$tg2.generateTimeTable();
                                this.val$database2.executeSQL("commit");
                                if (this.val$createTimeDim2) {
                                    String string = (String)this.val$initialData2.get(TimeGenWizMain.DIMENSION_NAME);
                                    this.setMessage(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION", string));
                                    TimeGenWizMain.this.success = this.val$tdg2.generateTimeDimension(TimeGenWizMain.this.time, this.val$initialData2);
                                }
                            }
                            catch (Exception exception) {
                                bl = Boolean.FALSE;
                                throw new TaskException((Throwable)exception);
                            }
                            return bl;
                        }
                    };
                    ObjectAction objectAction = new ObjectAction();
                    objectAction = new ObjectAction();
                    objectAction.setReload(true);
                    raptorTask.setCancellable(false);
                    raptorTask.setPausable(false);
                    ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
                    IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
                    raptorTask.getDescriptor().addListener(iRaptorTaskListener);
                    raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    String string = RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable());
                                    LOGGER.warning(string);
                                    String string2 = null;
                                    String string3 = OLAPArb.get("TIME_GEN_ERROR_DLG_TITLE");
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string3, string2);
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_TABLE_SUCCESS", string8));
                                    Boolean bl = (Boolean)namespace2.get(TimeGenWizMain.CREATE_DIMENSION);
                                    if (TimeGenWizMain.this.success) {
                                        String string = (String)namespace2.get(TimeGenWizMain.DIMENSION_NAME);
                                        String string2 = (String)namespace2.get(TimeGenWizMain.HIERARCHY_NAME);
                                        stringBuffer.append("\n");
                                        stringBuffer.append(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION_SUCCESS", string));
                                        stringBuffer.append("\n");
                                        stringBuffer.append(OLAPArb.format("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION_HIERARCHY_SUCCESS", string2));
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringBuffer.toString());
                                        TimeGenWizMain.this.refreshTree = true;
                                    } else if (!TimeGenWizMain.this.success && bl.booleanValue()) {
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.get("TIME_GEN_WIZARD_CREATING_TIME_DIMENSION_FAILURE"));
                                        TimeGenWizMain.this.refreshTree = false;
                                    } else {
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringBuffer.toString());
                                        TimeGenWizMain.this.refreshTree = false;
                                    }
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    });
                    RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
                    raptorTaskManager.addTask(raptorTask);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            String string9 = null;
            String string10 = exception.getLocalizedMessage();
            if (string10 == null || string10.length() == 0) {
                string10 = exception.getClass().toString();
            }
            String string11 = OLAPArb.get("TIME_GEN_ERROR_DLG_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string10, (String)string11, string9);
        }
    }

    private static FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_TITLE"), TimeGenGeneralPanel.class, "olap_time_gen_general");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)"LEVELS", (Object)STATE_LEVELS);
        Step step2 = new Step(OLAPArb.get("TIME_GEN_WIZARD_LEVELS_STEP_TITLE"), TimeGenLevelsPanel.class, "olap_time_gen_select_levels");
        fSMBuilder.newState((Object)STATE_LEVELS, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_ATTRIBUTES, (Object)STATE_ATTRIBUTES);
        Step step3 = new Step(OLAPArb.get("TIME_GEN_WIZARD_ATTRIBUTES_STEP_TITLE"), TimeGenAttrsPanel.class, "olap_time_gen_select_attributes");
        fSMBuilder.newState((Object)STATE_ATTRIBUTES, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_SUMMARY, (Object)STATE_SUMMARY);
        Step step4 = new Step(OLAPArb.get("TIME_GEN_WIZARD_SUMMARY_STEP_TITLE"), TimeGenSummaryPanel.class, "olap_time_gen_summary");
        fSMBuilder.newFinalState((Object)STATE_SUMMARY, step4);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public String getSQL(Namespace namespace) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        TimeTableGeneratorXML timeTableGeneratorXML = null;
        boolean bl = (Boolean)namespace.get(CREATE_DIMENSION);
        timeTableGeneratorXML = new TimeTableGeneratorXML(null, namespace);
        string = timeTableGeneratorXML.getTimeTableSQL();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        if (bl) {
            TimeDimensionGeneratorDDL timeDimensionGeneratorDDL = new TimeDimensionGeneratorDDL();
            string2 = timeDimensionGeneratorDDL.getTimeDimensionSQL(this.time, namespace);
            stringBuffer.append("\n");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String checkNameConflicts(Connection connection, String string, String string2) {
        String string3 = "";
        NamespaceValidator namespaceValidator = new NamespaceValidator(connection, string);
        NamespaceValidator.Collision collision = null;
        if (string3.length() == 0) {
            collision = namespaceValidator.checkForCollisions(string2, null);
            if (collision != NamespaceValidator.Collision.NONE && string3.length() == 0) {
                if (collision == NamespaceValidator.Collision.TABLE) {
                    string3 = OLAPArb.format("TIME_GEN_WIZARD_GENERAL_STEP_TABLE_ERROR_TABLE", string2);
                } else if (collision == NamespaceValidator.Collision.VIEW) {
                    string3 = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_TABLE_ERROR_VIEW");
                } else if (collision == NamespaceValidator.Collision.SYNONYM) {
                    string3 = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_TABLE_ERROR_SYN");
                } else if (collision == NamespaceValidator.Collision.CUBE) {
                    string3 = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_TABLE_ERROR_CUBE");
                } else if (collision == NamespaceValidator.Collision.DIMENSION) {
                    string3 = OLAPArb.get("TIME_GEN_WIZARD_GENERAL_STEP_TABLE_ERROR_DIM");
                }
            }
        }
        return string3;
    }

    public void addTime(Time time) {
        this.time = time;
    }

    private List<String> getAnalyticWorkspaces(Connection connection, String string) {
        List<String> list = null;
        try {
            AWListRunnable aWListRunnable = new AWListRunnable(connection, string);
            String string2 = OLAPArb.get("AW.FETCH.TITLE");
            string2 = MessageFormat.format(string2, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string2, (Runnable)aWListRunnable, true);
            progressBar.setCancelable(false);
            aWListRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("AW.FETCH.LIST"), null);
            if (aWListRunnable.getException() != null) {
                throw aWListRunnable.getException();
            }
            list = aWListRunnable.getAnalyticWorkspaces();
        }
        catch (Exception exception) {
            String string3 = null;
            String string4 = exception.getLocalizedMessage();
            if (string4 == null || string4.length() == 0) {
                string4 = exception.getClass().toString();
            }
            String string5 = OLAPArb.get("AW.FETCH.TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)string5, string3);
        }
        return list;
    }

    private void loadTimeXMLDocument() throws Exception {
        String string = "time.xml";
        String string2 = JavaXMLBind.LoadDocument(TimeTableGeneratorXML.class, string);
        JavaXMLBind.BindToJavaStr(string2, "oracle.olap.timegen.timexml", this);
    }

    private List<TimeGenLevel> getLevelList() {
        ArrayList<TimeGenLevel> arrayList = new ArrayList<TimeGenLevel>();
        List<TimeLevel> list = this.time.getTimeLevels();
        for (TimeLevel timeLevel : list) {
            String string = timeLevel.getName();
            TimeGenLevel timeGenLevel = new TimeGenLevel(string);
            timeGenLevel.setType(string);
            ArrayList<TimeGenAttribute> arrayList2 = new ArrayList<TimeGenAttribute>();
            List<TimeColumn> list2 = timeLevel.getTimeColumns();
            for (TimeColumn timeColumn : list2) {
                String string2 = timeColumn.getAttribute();
                String string3 = timeColumn.getColumn();
                String string4 = timeColumn.getFormat();
                String string5 = timeColumn.getDataType();
                TimeGenAttribute timeGenAttribute = new TimeGenAttribute(string3);
                timeGenAttribute.setFormat(string4);
                timeGenAttribute.setType(string2);
                timeGenAttribute.setDatatype(string5);
                arrayList2.add(timeGenAttribute);
            }
            timeGenLevel.setAttributes(arrayList2);
            List<Format> list3 = timeLevel.getFormats();
            timeGenLevel.setFormats(list3);
            arrayList.add(timeGenLevel);
        }
        return arrayList;
    }

    public static List<String> getTimeDimensions(Database database, String string, String string2) throws Exception {
        String string3 = "SELECT SYS.DBMS_CUBE_ADVISE_SEC.GET_MVNAME(?, ?) DIMHIER_MVNAME from dual";
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct dimension_name ");
        stringBuffer.append("from all_cube_dimensions ");
        stringBuffer.append("where owner=? and dimension_type='TIME' and aw_name=?");
        stringBuffer.append("order by dimension_name");
        List<Object> list = new ArrayList();
        list = database.executeSQL(stringBuffer.toString(), new Object[]{string, string2});
        for (List object : list) {
            arrayList2.add((String)object.get(0));
        }
        for (String string4 : arrayList2) {
            List<List<String>> list2 = database.executeSQL(string3, new Object[]{string, string4});
            for (List<String> list3 : list2) {
                String string5 = list3.get(0);
                if (string5 == null) {
                    arrayList.add(string4);
                    continue;
                }
                if (string5 == null || !string5.equalsIgnoreCase("")) continue;
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    static {
        LOGGER = Logger.getLogger(TimeGenWizMain.class.getName());
    }
}

