/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.tools.pivot;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.tools.pivot.ColumnProperty;

public class MeasureDimension {
    private String schemaName;
    private String dimensionTableName;
    private String factViewName;
    private String factTableName;
    private List<ColumnProperty> columns;

    private String getColumList() {
        Object object = "";
        for (ColumnProperty columnProperty : this.columns) {
            if (!columnProperty.isIncluded()) continue;
            if (((String)object).equals("")) {
                object = columnProperty.getName();
                continue;
            }
            object = (String)object + "," + columnProperty.getName();
        }
        return object;
    }

    public void setDimensionTableName(String string) {
        this.dimensionTableName = string.toUpperCase();
    }

    public String getDimensionTableName() {
        return this.dimensionTableName;
    }

    public String getFactViewName() {
        return this.factViewName;
    }

    public String getCreateFactViewSql() {
        String string = "create or replace view " + this.schemaName + "." + this.factViewName + " as\n   (select * from " + this.schemaName + "." + this.factTableName + "\n   unpivot (measure_value  for measure_dim in (" + this.getColumList() + ")));";
        return string;
    }

    public String getInsertMeasureColumnSql() {
        Object object = "";
        for (ColumnProperty columnProperty : this.getSelectedColumns()) {
            object = (String)object + "Insert into " + this.schemaName + "." + this.dimensionTableName + " values ('" + columnProperty.getName().toUpperCase() + "', '" + this.initCap(columnProperty.getName()) + "');\n";
        }
        return object;
    }

    private String initCap(String string) {
        String[] stringArray = string.split("_");
        Object object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].substring(0, 1).toUpperCase();
            String string3 = stringArray[i].substring(1).toLowerCase();
            object = i > 0 ? (String)object + "_" + string2 + string3 : (String)object + string2 + string3;
        }
        return object;
    }

    public List<ColumnProperty> getSelectedColumns() {
        ArrayList<ColumnProperty> arrayList = new ArrayList<ColumnProperty>();
        if (this.columns != null) {
            for (ColumnProperty columnProperty : this.columns) {
                if (!columnProperty.isIncluded()) continue;
                arrayList.add(columnProperty);
            }
        }
        return arrayList;
    }

    public void setFactViewName(String string) {
        this.factViewName = string.toUpperCase();
    }

    public String getDropDimensionTableSql() {
        String string = "drop table " + this.schemaName + "." + this.dimensionTableName + ";\n";
        return string;
    }

    public String getCreateDimensionTableSql() {
        String string = "create table " + this.schemaName + "." + this.dimensionTableName + " (measure_id varchar2(60), measure_desc varchar2(120));\n";
        return string;
    }

    public void setColumns(List<ColumnProperty> list) {
        this.columns = list;
    }

    public void setFactTableName(String string) {
        this.factTableName = string;
    }

    public String getFactTableName() {
        return this.factTableName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }
}

